/*
 * Iko.travel
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our platform, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with iko.travel. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@iko.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import travel.wink.sdk.affiliate.model.CategoryAxisCrosshairTooltip;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The configuration options of the crosshair. The crosshair is displayed when the &#x60;categoryAxis.crosshair.visible&#x60; option is set to &#x60;true&#x60;.
 */
@ApiModel(description = "The configuration options of the crosshair. The crosshair is displayed when the `categoryAxis.crosshair.visible` option is set to `true`.")
@JsonPropertyOrder({
  CategoryAxisCrosshair.JSON_PROPERTY_COLOR,
  CategoryAxisCrosshair.JSON_PROPERTY_DASH_TYPE,
  CategoryAxisCrosshair.JSON_PROPERTY_OPACITY,
  CategoryAxisCrosshair.JSON_PROPERTY_VISIBLE,
  CategoryAxisCrosshair.JSON_PROPERTY_WIDTH,
  CategoryAxisCrosshair.JSON_PROPERTY_TOOLTIP
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:47:12.254493+07:00[Asia/Bangkok]")
public class CategoryAxisCrosshair {
  public static final String JSON_PROPERTY_COLOR = "color";
  private String color;

  /**
   * Gets or Sets dashType
   */
  public enum DashTypeEnum {
    DASH("dash"),
    
    DASHDOT("dashDot"),
    
    DOT("dot"),
    
    LONGDASH("longDash"),
    
    LONGDASHDOT("longDashDot"),
    
    LONGDASHDOTDOT("longDashDotDot"),
    
    SOLID("solid");

    private String value;

    DashTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DashTypeEnum fromValue(String value) {
      for (DashTypeEnum b : DashTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DASH_TYPE = "dashType";
  private DashTypeEnum dashType;

  public static final String JSON_PROPERTY_OPACITY = "opacity";
  private BigDecimal opacity;

  public static final String JSON_PROPERTY_VISIBLE = "visible";
  private Boolean visible;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private BigDecimal width;

  public static final String JSON_PROPERTY_TOOLTIP = "tooltip";
  private CategoryAxisCrosshairTooltip tooltip;

  public CategoryAxisCrosshair() { 
  }

  public CategoryAxisCrosshair color(String color) {
    
    this.color = color;
    return this;
  }

   /**
   * Get color
   * @return color
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColor(String color) {
    this.color = color;
  }


  public CategoryAxisCrosshair dashType(DashTypeEnum dashType) {
    
    this.dashType = dashType;
    return this;
  }

   /**
   * Get dashType
   * @return dashType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DASH_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DashTypeEnum getDashType() {
    return dashType;
  }


  @JsonProperty(JSON_PROPERTY_DASH_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDashType(DashTypeEnum dashType) {
    this.dashType = dashType;
  }


  public CategoryAxisCrosshair opacity(BigDecimal opacity) {
    
    this.opacity = opacity;
    return this;
  }

   /**
   * Get opacity
   * @return opacity
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OPACITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getOpacity() {
    return opacity;
  }


  @JsonProperty(JSON_PROPERTY_OPACITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpacity(BigDecimal opacity) {
    this.opacity = opacity;
  }


  public CategoryAxisCrosshair visible(Boolean visible) {
    
    this.visible = visible;
    return this;
  }

   /**
   * Get visible
   * @return visible
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VISIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getVisible() {
    return visible;
  }


  @JsonProperty(JSON_PROPERTY_VISIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisible(Boolean visible) {
    this.visible = visible;
  }


  public CategoryAxisCrosshair width(BigDecimal width) {
    
    this.width = width;
    return this;
  }

   /**
   * Get width
   * @return width
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWidth(BigDecimal width) {
    this.width = width;
  }


  public CategoryAxisCrosshair tooltip(CategoryAxisCrosshairTooltip tooltip) {
    
    this.tooltip = tooltip;
    return this;
  }

   /**
   * Get tooltip
   * @return tooltip
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOOLTIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CategoryAxisCrosshairTooltip getTooltip() {
    return tooltip;
  }


  @JsonProperty(JSON_PROPERTY_TOOLTIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTooltip(CategoryAxisCrosshairTooltip tooltip) {
    this.tooltip = tooltip;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CategoryAxisCrosshair categoryAxisCrosshair = (CategoryAxisCrosshair) o;
    return Objects.equals(this.color, categoryAxisCrosshair.color) &&
        Objects.equals(this.dashType, categoryAxisCrosshair.dashType) &&
        Objects.equals(this.opacity, categoryAxisCrosshair.opacity) &&
        Objects.equals(this.visible, categoryAxisCrosshair.visible) &&
        Objects.equals(this.width, categoryAxisCrosshair.width) &&
        Objects.equals(this.tooltip, categoryAxisCrosshair.tooltip);
  }

  @Override
  public int hashCode() {
    return Objects.hash(color, dashType, opacity, visible, width, tooltip);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CategoryAxisCrosshair {\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    dashType: ").append(toIndentedString(dashType)).append("\n");
    sb.append("    opacity: ").append(toIndentedString(opacity)).append("\n");
    sb.append("    visible: ").append(toIndentedString(visible)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    tooltip: ").append(toIndentedString(tooltip)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

