/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.AddStaticSellerListItemRequest;
import travel.wink.sdk.affiliate.model.BooleanResponse;
import travel.wink.sdk.affiliate.model.CopyMoveStaticSellerListItemRequest;
import travel.wink.sdk.affiliate.model.CreateStaticSellerListAndAddItemRequest;
import travel.wink.sdk.affiliate.model.DynamicSellerListView;
import travel.wink.sdk.affiliate.model.RemoveEntryResponse;
import travel.wink.sdk.affiliate.model.SellerInventoryList;
import travel.wink.sdk.affiliate.model.SellerInventoryListView;
import travel.wink.sdk.affiliate.model.SellerInventoryRankedList;
import travel.wink.sdk.affiliate.model.SellerInventoryRankedListView;
import travel.wink.sdk.affiliate.model.SortStaticSellerListItemsRequest;
import travel.wink.sdk.affiliate.model.StaticSellerList;
import travel.wink.sdk.affiliate.model.StaticSellerListItemView;
import travel.wink.sdk.affiliate.model.StaticSellerListWrapper;

public class InventoryGridsApi {
    private ApiClient apiClient;

    public InventoryGridsApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryGridsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec addInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequest addStaticSellerListItemRequest) throws WebClientResponseException {
        AddStaticSellerListItemRequest postBody = addStaticSellerListItemRequest;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addStaticSellerListItemRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'addStaticSellerListItemRequest' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListItemView> addInventoryToCuratedList(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequest addStaticSellerListItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>(){};
        return this.addInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListItemRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemView>> addInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequest addStaticSellerListItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>(){};
        return this.addInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListItemRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec copyInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequest copyMoveStaticSellerListItemRequest) throws WebClientResponseException {
        CopyMoveStaticSellerListItemRequest postBody = copyMoveStaticSellerListItemRequest;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (copyMoveStaticSellerListItemRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticSellerListItemRequest' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListItemView> copyInventoryToCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequest copyMoveStaticSellerListItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>(){};
        return this.copyInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemView>> copyInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequest copyMoveStaticSellerListItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>(){};
        return this.copyInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec createCuratedListRequestCreation(String companyIdentifier, CreateStaticSellerListAndAddItemRequest createStaticSellerListAndAddItemRequest) throws WebClientResponseException {
        CreateStaticSellerListAndAddItemRequest postBody = createStaticSellerListAndAddItemRequest;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (createStaticSellerListAndAddItemRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStaticSellerListAndAddItemRequest' when calling createCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListWrapper> createCuratedList(String companyIdentifier, CreateStaticSellerListAndAddItemRequest createStaticSellerListAndAddItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>(){};
        return this.createCuratedListRequestCreation(companyIdentifier, createStaticSellerListAndAddItemRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListWrapper>> createCuratedListWithHttpInfo(String companyIdentifier, CreateStaticSellerListAndAddItemRequest createStaticSellerListAndAddItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>(){};
        return this.createCuratedListRequestCreation(companyIdentifier, createStaticSellerListAndAddItemRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec createSellerInventoryListRequestCreation(String companyIdentifier, SellerInventoryList sellerInventoryList) throws WebClientResponseException {
        SellerInventoryList postBody = sellerInventoryList;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sellerInventoryList == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerInventoryList' when calling createSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryListView> createSellerInventoryList(String companyIdentifier, SellerInventoryList sellerInventoryList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>(){};
        return this.createSellerInventoryListRequestCreation(companyIdentifier, sellerInventoryList).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListView>> createSellerInventoryListWithHttpInfo(String companyIdentifier, SellerInventoryList sellerInventoryList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>(){};
        return this.createSellerInventoryListRequestCreation(companyIdentifier, sellerInventoryList).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec createSellerInventoryRankedListRequestCreation(String companyIdentifier, SellerInventoryRankedList sellerInventoryRankedList) throws WebClientResponseException {
        SellerInventoryRankedList postBody = sellerInventoryRankedList;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sellerInventoryRankedList == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerInventoryRankedList' when calling createSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryRankedListView> createSellerInventoryRankedList(String companyIdentifier, SellerInventoryRankedList sellerInventoryRankedList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>(){};
        return this.createSellerInventoryRankedListRequestCreation(companyIdentifier, sellerInventoryRankedList).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRankedListView>> createSellerInventoryRankedListWithHttpInfo(String companyIdentifier, SellerInventoryRankedList sellerInventoryRankedList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>(){};
        return this.createSellerInventoryRankedListRequestCreation(companyIdentifier, sellerInventoryRankedList).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec moveInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequest copyMoveStaticSellerListItemRequest) throws WebClientResponseException {
        CopyMoveStaticSellerListItemRequest postBody = copyMoveStaticSellerListItemRequest;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (copyMoveStaticSellerListItemRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticSellerListItemRequest' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListItemView> moveInventoryToCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequest copyMoveStaticSellerListItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>(){};
        return this.moveInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemView>> moveInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequest copyMoveStaticSellerListItemRequest) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemView> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemView>(){};
        return this.moveInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeCuratedList(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeCuratedListRequestCreation(companyIdentifier, listIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeCuratedListRequestCreation(companyIdentifier, listIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeInventoryFromCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeInventoryFromCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeInventoryFromCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeInventoryFromCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeInventoryFromCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeSellerInventoryListRequestCreation(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/{listIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeSellerInventoryList(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeSellerInventoryListWithHttpInfo(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeSellerInventoryRankedListRequestCreation(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/{listIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeSellerInventoryRankedList(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeSellerInventoryRankedListWithHttpInfo(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showCuratedListsRequestCreation(String companyIdentifier, Boolean withItems, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCuratedLists", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "withItems", withItems));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<StaticSellerListWrapper> showCuratedLists(String companyIdentifier, Boolean withItems, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>(){};
        return this.showCuratedListsRequestCreation(companyIdentifier, withItems, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<StaticSellerListWrapper>>> showCuratedListsWithHttpInfo(String companyIdentifier, Boolean withItems, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>(){};
        return this.showCuratedListsRequestCreation(companyIdentifier, withItems, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showSavedSearchesRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSavedSearches", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<DynamicSellerListView> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/dynamic/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<DynamicSellerListView> showSavedSearches(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicSellerListView> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListView>(){};
        return this.showSavedSearchesRequestCreation(companyIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<DynamicSellerListView>>> showSavedSearchesWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicSellerListView> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListView>(){};
        return this.showSavedSearchesRequestCreation(companyIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showSellerInventoryListRequestCreation(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/{listIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryListView> showSellerInventoryList(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>(){};
        return this.showSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListView>> showSellerInventoryListWithHttpInfo(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>(){};
        return this.showSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showSellerInventoryListsRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryLists", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SellerInventoryListView> showSellerInventoryLists(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>(){};
        return this.showSellerInventoryListsRequestCreation(companyIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellerInventoryListView>>> showSellerInventoryListsWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>(){};
        return this.showSellerInventoryListsRequestCreation(companyIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showSellerInventoryRankedListRequestCreation(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/{listIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryRankedListView> showSellerInventoryRankedList(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>(){};
        return this.showSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRankedListView>> showSellerInventoryRankedListWithHttpInfo(String companyIdentifier, String listIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>(){};
        return this.showSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showSellerInventoryRankedListsRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryRankedLists", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SellerInventoryRankedListView> showSellerInventoryRankedLists(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>(){};
        return this.showSellerInventoryRankedListsRequestCreation(companyIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellerInventoryRankedListView>>> showSellerInventoryRankedListsWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>(){};
        return this.showSellerInventoryRankedListsRequestCreation(companyIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec sortCuratedListItemsRequestCreation(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequest sortStaticSellerListItemsRequest) throws WebClientResponseException {
        SortStaticSellerListItemsRequest postBody = sortStaticSellerListItemsRequest;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sortStaticSellerListItemsRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'sortStaticSellerListItemsRequest' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<BooleanResponse> localVarReturnType = new ParameterizedTypeReference<BooleanResponse>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}/sort", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponse> sortCuratedListItems(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequest sortStaticSellerListItemsRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponse> localVarReturnType = new ParameterizedTypeReference<BooleanResponse>(){};
        return this.sortCuratedListItemsRequestCreation(companyIdentifier, listIdentifier, sortStaticSellerListItemsRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponse>> sortCuratedListItemsWithHttpInfo(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequest sortStaticSellerListItemsRequest) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponse> localVarReturnType = new ParameterizedTypeReference<BooleanResponse>(){};
        return this.sortCuratedListItemsRequestCreation(companyIdentifier, listIdentifier, sortStaticSellerListItemsRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateCuratedListRequestCreation(String companyIdentifier, String listIdentifier, StaticSellerList staticSellerList) throws WebClientResponseException {
        StaticSellerList postBody = staticSellerList;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (staticSellerList == null) {
            throw new WebClientResponseException("Missing the required parameter 'staticSellerList' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/static/list/{listIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListWrapper> updateCuratedList(String companyIdentifier, String listIdentifier, StaticSellerList staticSellerList) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>(){};
        return this.updateCuratedListRequestCreation(companyIdentifier, listIdentifier, staticSellerList).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListWrapper>> updateCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, StaticSellerList staticSellerList) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapper> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapper>(){};
        return this.updateCuratedListRequestCreation(companyIdentifier, listIdentifier, staticSellerList).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateSellerInventoryListRequestCreation(String companyIdentifier, String listIdentifier, SellerInventoryList sellerInventoryList) throws WebClientResponseException {
        SellerInventoryList postBody = sellerInventoryList;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sellerInventoryList == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerInventoryList' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list/{listIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryListView> updateSellerInventoryList(String companyIdentifier, String listIdentifier, SellerInventoryList sellerInventoryList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>(){};
        return this.updateSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, sellerInventoryList).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListView>> updateSellerInventoryListWithHttpInfo(String companyIdentifier, String listIdentifier, SellerInventoryList sellerInventoryList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListView>(){};
        return this.updateSellerInventoryListRequestCreation(companyIdentifier, listIdentifier, sellerInventoryList).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateSellerInventoryRankedListRequestCreation(String companyIdentifier, String listIdentifier, SellerInventoryRankedList sellerInventoryRankedList) throws WebClientResponseException {
        SellerInventoryRankedList postBody = sellerInventoryRankedList;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sellerInventoryRankedList == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerInventoryRankedList' when calling updateSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/ranked/list/{listIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryRankedListView> updateSellerInventoryRankedList(String companyIdentifier, String listIdentifier, SellerInventoryRankedList sellerInventoryRankedList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>(){};
        return this.updateSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, sellerInventoryRankedList).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRankedListView>> updateSellerInventoryRankedListWithHttpInfo(String companyIdentifier, String listIdentifier, SellerInventoryRankedList sellerInventoryRankedList) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListView>(){};
        return this.updateSellerInventoryRankedListRequestCreation(companyIdentifier, listIdentifier, sellerInventoryRankedList).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

