/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

@ApiModel(description="Address information")
@JsonPropertyOrder(value={"address1", "address2", "cityName", "state", "postalCode", "county", "countryCode", "countryName", "fullAddress"})
public class AddressDto {
    public static final String JSON_PROPERTY_ADDRESS1 = "address1";
    private String address1;
    public static final String JSON_PROPERTY_ADDRESS2 = "address2";
    private String address2;
    public static final String JSON_PROPERTY_CITY_NAME = "cityName";
    private String cityName;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_COUNTY = "county";
    private String county;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_COUNTRY_NAME = "countryName";
    private String countryName;
    public static final String JSON_PROPERTY_FULL_ADDRESS = "fullAddress";
    private String fullAddress;

    public AddressDto address1(String address1) {
        this.address1 = address1;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="234 Near da beach", required=true, value="Address line 1")
    @JsonProperty(value="address1")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAddress1() {
        return this.address1;
    }

    @JsonProperty(value="address1")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public AddressDto address2(String address2) {
        this.address2 = address2;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Pebble #5001", value="Address line 2")
    @JsonProperty(value="address2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress2() {
        return this.address2;
    }

    @JsonProperty(value="address2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public AddressDto cityName(String cityName) {
        this.cityName = cityName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Los Angeles", required=true, value="City name")
    @JsonProperty(value="cityName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCityName() {
        return this.cityName;
    }

    @JsonProperty(value="cityName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public AddressDto state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CA", value="State")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public AddressDto postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="90210", required=true, value="Postal / zip code")
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public AddressDto county(String county) {
        this.county = county;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Alameda county", value="County")
    @JsonProperty(value="county")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCounty() {
        return this.county;
    }

    @JsonProperty(value="county")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounty(String county) {
        this.county = county;
    }

    public AddressDto countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="US", required=true, value="Country code")
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public AddressDto countryName(String countryName) {
        this.countryName = countryName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="United States", value="Country name")
    @JsonProperty(value="countryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryName() {
        return this.countryName;
    }

    @JsonProperty(value="countryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public AddressDto fullAddress(String fullAddress) {
        this.fullAddress = fullAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="fullAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullAddress() {
        return this.fullAddress;
    }

    @JsonProperty(value="fullAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullAddress(String fullAddress) {
        this.fullAddress = fullAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressDto addressDto = (AddressDto)o;
        return Objects.equals(this.address1, addressDto.address1) && Objects.equals(this.address2, addressDto.address2) && Objects.equals(this.cityName, addressDto.cityName) && Objects.equals(this.state, addressDto.state) && Objects.equals(this.postalCode, addressDto.postalCode) && Objects.equals(this.county, addressDto.county) && Objects.equals(this.countryCode, addressDto.countryCode) && Objects.equals(this.countryName, addressDto.countryName) && Objects.equals(this.fullAddress, addressDto.fullAddress);
    }

    public int hashCode() {
        return Objects.hash(this.address1, this.address2, this.cityName, this.state, this.postalCode, this.county, this.countryCode, this.countryName, this.fullAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressDto {\n");
        sb.append("    address1: ").append(this.toIndentedString(this.address1)).append("\n");
        sb.append("    address2: ").append(this.toIndentedString(this.address2)).append("\n");
        sb.append("    cityName: ").append(this.toIndentedString(this.cityName)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    county: ").append(this.toIndentedString(this.county)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    countryName: ").append(this.toIndentedString(this.countryName)).append("\n");
        sb.append("    fullAddress: ").append(this.toIndentedString(this.fullAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

