/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="The configuration of the chart series. The series type is determined by the value of the type field. If a type value is missing, the chart renders the type that is specified in `seriesDefaults`. Some options accept functions as arguments. These arguments are evaluated for each point which is supplied as a parameter. If no value is returned, the chart uses the `theme` or `seriesDefaults` values.")
@JsonPropertyOrder(value={"name", "data"})
public class ChartSeries {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<BigDecimal> data = null;

    public ChartSeries name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the Chart series which is visible in the legend.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ChartSeries data(List<BigDecimal> data) {
        this.data = data;
        return this;
    }

    public ChartSeries addDataItem(BigDecimal dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<BigDecimal>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The array of data items which represent the series data.  You can set it to:  - Array of numbers. Supported when the series.type option is set to `area`, `bar`, `column`, `donut`, `pie`, `line`, or `waterfall`. The Bubble series need arrays of three values\u2014X value, Y value, and Size value\u2014for example, [1, 1, 10]. The Scatter and ScatterLine series need arrays of two values\u2014X value and Y value. The OHLC and Candlestick series need arrays of four values\u2014open, high, low, and close. The RangeBar and RangeArea series need arrays of two values\u2014the from and to value.")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BigDecimal> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(List<BigDecimal> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChartSeries chartSeries = (ChartSeries)o;
        return Objects.equals(this.name, chartSeries.name) && Objects.equals(this.data, chartSeries.data);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChartSeries {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

