/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.affiliate.model.EngineConfigurationTheme;
import travel.wink.sdk.affiliate.model.Multimedia;
import travel.wink.sdk.affiliate.model.RoomConfiguration;

@JsonPropertyOrder(value={"name", "appendToPageTitle", "facebookApiToken", "googleOauthToken", "wcFacebookApiToken", "wcGoogleOauthToken", "googleTagManagerKey", "wcGoogleTagManagerKey", "googleMapsAPIKey", "wcGoogleMapsAPIKey", "tawkToKey", "wcTawkToKey", "recaptcha3Key", "recaptcha3SecretKey", "defaultCurrency", "defaultLanguage", "logos", "hostedBookingEngineUrl", "selfHosted", "themeColors", "numberOfAdvanceDays", "numberOfStayDays", "startDate", "endDate", "roomConfigurations", "useDays", "promotionalCodes", "sendBookingNotificationEmailsToProperty", "sendBookingNotificationEmailsToBooker", "wcBookClickAction"})
public class SaveEngineConfigurationRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_APPEND_TO_PAGE_TITLE = "appendToPageTitle";
    private String appendToPageTitle;
    public static final String JSON_PROPERTY_FACEBOOK_API_TOKEN = "facebookApiToken";
    private String facebookApiToken;
    public static final String JSON_PROPERTY_GOOGLE_OAUTH_TOKEN = "googleOauthToken";
    private String googleOauthToken;
    public static final String JSON_PROPERTY_WC_FACEBOOK_API_TOKEN = "wcFacebookApiToken";
    private String wcFacebookApiToken;
    public static final String JSON_PROPERTY_WC_GOOGLE_OAUTH_TOKEN = "wcGoogleOauthToken";
    private String wcGoogleOauthToken;
    public static final String JSON_PROPERTY_GOOGLE_TAG_MANAGER_KEY = "googleTagManagerKey";
    private String googleTagManagerKey;
    public static final String JSON_PROPERTY_WC_GOOGLE_TAG_MANAGER_KEY = "wcGoogleTagManagerKey";
    private String wcGoogleTagManagerKey;
    public static final String JSON_PROPERTY_GOOGLE_MAPS_A_P_I_KEY = "googleMapsAPIKey";
    private String googleMapsAPIKey;
    public static final String JSON_PROPERTY_WC_GOOGLE_MAPS_A_P_I_KEY = "wcGoogleMapsAPIKey";
    private String wcGoogleMapsAPIKey;
    public static final String JSON_PROPERTY_TAWK_TO_KEY = "tawkToKey";
    private String tawkToKey;
    public static final String JSON_PROPERTY_WC_TAWK_TO_KEY = "wcTawkToKey";
    private String wcTawkToKey;
    public static final String JSON_PROPERTY_RECAPTCHA3_KEY = "recaptcha3Key";
    private String recaptcha3Key;
    public static final String JSON_PROPERTY_RECAPTCHA3_SECRET_KEY = "recaptcha3SecretKey";
    private String recaptcha3SecretKey;
    public static final String JSON_PROPERTY_DEFAULT_CURRENCY = "defaultCurrency";
    private String defaultCurrency = "USD";
    public static final String JSON_PROPERTY_DEFAULT_LANGUAGE = "defaultLanguage";
    private String defaultLanguage = "en";
    public static final String JSON_PROPERTY_LOGOS = "logos";
    private List<Multimedia> logos = null;
    public static final String JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL = "hostedBookingEngineUrl";
    private String hostedBookingEngineUrl = "https://ota.iko.travel";
    public static final String JSON_PROPERTY_SELF_HOSTED = "selfHosted";
    private Boolean selfHosted = false;
    public static final String JSON_PROPERTY_THEME_COLORS = "themeColors";
    private EngineConfigurationTheme themeColors;
    public static final String JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS = "numberOfAdvanceDays";
    private Integer numberOfAdvanceDays;
    public static final String JSON_PROPERTY_NUMBER_OF_STAY_DAYS = "numberOfStayDays";
    private Integer numberOfStayDays;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_ROOM_CONFIGURATIONS = "roomConfigurations";
    private List<RoomConfiguration> roomConfigurations = null;
    public static final String JSON_PROPERTY_USE_DAYS = "useDays";
    private Boolean useDays;
    public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
    private List<String> promotionalCodes = null;
    public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY = "sendBookingNotificationEmailsToProperty";
    private Boolean sendBookingNotificationEmailsToProperty = true;
    public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER = "sendBookingNotificationEmailsToBooker";
    private Boolean sendBookingNotificationEmailsToBooker = true;
    public static final String JSON_PROPERTY_WC_BOOK_CLICK_ACTION = "wcBookClickAction";
    private WcBookClickActionEnum wcBookClickAction;

    public SaveEngineConfigurationRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Engine Configuration 1", required=true, value="Engine configuration name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public SaveEngineConfigurationRequest appendToPageTitle(String appendToPageTitle) {
        this.appendToPageTitle = appendToPageTitle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to append text to the existing booking engine page title.")
    @JsonProperty(value="appendToPageTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppendToPageTitle() {
        return this.appendToPageTitle;
    }

    @JsonProperty(value="appendToPageTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppendToPageTitle(String appendToPageTitle) {
        this.appendToPageTitle = appendToPageTitle;
    }

    public SaveEngineConfigurationRequest facebookApiToken(String facebookApiToken) {
        this.facebookApiToken = facebookApiToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="fb-app-id-1", value="Add your Facebook API token here if you want to allow users to be able to log in with their Facebook account on your self-hosted booking engine. Only applicable when you host our booking engine on your domain.")
    @JsonProperty(value="facebookApiToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFacebookApiToken() {
        return this.facebookApiToken;
    }

    @JsonProperty(value="facebookApiToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFacebookApiToken(String facebookApiToken) {
        this.facebookApiToken = facebookApiToken;
    }

    public SaveEngineConfigurationRequest googleOauthToken(String googleOauthToken) {
        this.googleOauthToken = googleOauthToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="google-token-1", value="Add your Google OAuth token here if you want to allow users to be able to log in with their Google account on your self-hosted booking engine. Only applicable when you host our booking engine on your domain.")
    @JsonProperty(value="googleOauthToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGoogleOauthToken() {
        return this.googleOauthToken;
    }

    @JsonProperty(value="googleOauthToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGoogleOauthToken(String googleOauthToken) {
        this.googleOauthToken = googleOauthToken;
    }

    public SaveEngineConfigurationRequest wcFacebookApiToken(String wcFacebookApiToken) {
        this.wcFacebookApiToken = wcFacebookApiToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="fb-app-id-2", value="Add a Facebook API token here if you want to allow users to be able to log in with their Facebook account directly through one of our embeddable Web Components. Only applicable when you are using our Web Components.")
    @JsonProperty(value="wcFacebookApiToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWcFacebookApiToken() {
        return this.wcFacebookApiToken;
    }

    @JsonProperty(value="wcFacebookApiToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWcFacebookApiToken(String wcFacebookApiToken) {
        this.wcFacebookApiToken = wcFacebookApiToken;
    }

    public SaveEngineConfigurationRequest wcGoogleOauthToken(String wcGoogleOauthToken) {
        this.wcGoogleOauthToken = wcGoogleOauthToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="google-token-2", value="Add a Google Oauth token here if you want to allow users to be able to log in with their Google account directly through one of our embeddable Web Components. Only applicable when you are using our Web Components.")
    @JsonProperty(value="wcGoogleOauthToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWcGoogleOauthToken() {
        return this.wcGoogleOauthToken;
    }

    @JsonProperty(value="wcGoogleOauthToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWcGoogleOauthToken(String wcGoogleOauthToken) {
        this.wcGoogleOauthToken = wcGoogleOauthToken;
    }

    public SaveEngineConfigurationRequest googleTagManagerKey(String googleTagManagerKey) {
        this.googleTagManagerKey = googleTagManagerKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If you want to track analytics with Google Analytics and GTM for your self-hosted booking engine, you need to import our [GTM profile](https://www.dropbox.com/s/o6rwluclvsgydma/gtm-template-2020-2.json?dl=0) into your GTM container and link it with your Google Analytics account. [More about that here](https://bearchoke.atlassian.net/wiki/spaces/TC/pages/2941648897/Linking+your+Google+Tag+Manager+account) ")
    @JsonProperty(value="googleTagManagerKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGoogleTagManagerKey() {
        return this.googleTagManagerKey;
    }

    @JsonProperty(value="googleTagManagerKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGoogleTagManagerKey(String googleTagManagerKey) {
        this.googleTagManagerKey = googleTagManagerKey;
    }

    public SaveEngineConfigurationRequest wcGoogleTagManagerKey(String wcGoogleTagManagerKey) {
        this.wcGoogleTagManagerKey = wcGoogleTagManagerKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If you want to track analytics with Google Analytics and GTM for the Web Components you've embedded, you need to import our [GTM profile](https://www.dropbox.com/s/o6rwluclvsgydma/gtm-template-2020-2.json?dl=0) into your GTM container and link it with your Google Analytics account. [More about that here](https://bearchoke.atlassian.net/wiki/spaces/TC/pages/2941648897/Linking+your+Google+Tag+Manager+account) ")
    @JsonProperty(value="wcGoogleTagManagerKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWcGoogleTagManagerKey() {
        return this.wcGoogleTagManagerKey;
    }

    @JsonProperty(value="wcGoogleTagManagerKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWcGoogleTagManagerKey(String wcGoogleTagManagerKey) {
        this.wcGoogleTagManagerKey = wcGoogleTagManagerKey;
    }

    public SaveEngineConfigurationRequest googleMapsAPIKey(String googleMapsAPIKey) {
        this.googleMapsAPIKey = googleMapsAPIKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="google-maps-api-123", value="If you want your users to see Google Maps in your hosted booking engine, go to [Google Maps](https://console.developers.google.com/projectselector2/apis/credentials?supportedpurview=project) and create an API key for your site.")
    @JsonProperty(value="googleMapsAPIKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGoogleMapsAPIKey() {
        return this.googleMapsAPIKey;
    }

    @JsonProperty(value="googleMapsAPIKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGoogleMapsAPIKey(String googleMapsAPIKey) {
        this.googleMapsAPIKey = googleMapsAPIKey;
    }

    public SaveEngineConfigurationRequest wcGoogleMapsAPIKey(String wcGoogleMapsAPIKey) {
        this.wcGoogleMapsAPIKey = wcGoogleMapsAPIKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="google-maps-api-321", value="If you want your users to see Google Maps in any of our Web Components, go to [Google Maps](https://console.developers.google.com/projectselector2/apis/credentials?supportedpurview=project) and create an API key for your site.")
    @JsonProperty(value="wcGoogleMapsAPIKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWcGoogleMapsAPIKey() {
        return this.wcGoogleMapsAPIKey;
    }

    @JsonProperty(value="wcGoogleMapsAPIKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWcGoogleMapsAPIKey(String wcGoogleMapsAPIKey) {
        this.wcGoogleMapsAPIKey = wcGoogleMapsAPIKey;
    }

    public SaveEngineConfigurationRequest tawkToKey(String tawkToKey) {
        this.tawkToKey = tawkToKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="tawk-to-1", value="If you want your users to be able to chat with you on your hosted booking engine, set yourself up with a [tawk.to account](https://dashboard.tawk.to/signup) and add your API key here.")
    @JsonProperty(value="tawkToKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTawkToKey() {
        return this.tawkToKey;
    }

    @JsonProperty(value="tawkToKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTawkToKey(String tawkToKey) {
        this.tawkToKey = tawkToKey;
    }

    public SaveEngineConfigurationRequest wcTawkToKey(String wcTawkToKey) {
        this.wcTawkToKey = wcTawkToKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="tawk-to-2", value="If you want your users to be able to chat with in any of our Web Components, set yourself up with a [tawk.to account](https://dashboard.tawk.to/signup) and add your API key here.")
    @JsonProperty(value="wcTawkToKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWcTawkToKey() {
        return this.wcTawkToKey;
    }

    @JsonProperty(value="wcTawkToKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWcTawkToKey(String wcTawkToKey) {
        this.wcTawkToKey = wcTawkToKey;
    }

    public SaveEngineConfigurationRequest recaptcha3Key(String recaptcha3Key) {
        this.recaptcha3Key = recaptcha3Key;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="google-recaptcha-key-1", value="Our platform protects against fraud with [Google ReCaptcha v3](https://developers.google.com/recaptcha/docs/v3). If you are self-hosting our booking engine, you need to create an API key with them and add it here.")
    @JsonProperty(value="recaptcha3Key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecaptcha3Key() {
        return this.recaptcha3Key;
    }

    @JsonProperty(value="recaptcha3Key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecaptcha3Key(String recaptcha3Key) {
        this.recaptcha3Key = recaptcha3Key;
    }

    public SaveEngineConfigurationRequest recaptcha3SecretKey(String recaptcha3SecretKey) {
        this.recaptcha3SecretKey = recaptcha3SecretKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="google-recaptcha-key-1", value="Our platform protects against fraud with [Google ReCaptcha v3](https://developers.google.com/recaptcha/docs/v3). If you are self-hosting our booking engine, you need to create an API key with them and add the secret key here.")
    @JsonProperty(value="recaptcha3SecretKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecaptcha3SecretKey() {
        return this.recaptcha3SecretKey;
    }

    @JsonProperty(value="recaptcha3SecretKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecaptcha3SecretKey(String recaptcha3SecretKey) {
        this.recaptcha3SecretKey = recaptcha3SecretKey;
    }

    public SaveEngineConfigurationRequest defaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Control which currency your users see prices in initially.")
    @JsonProperty(value="defaultCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @JsonProperty(value="defaultCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    public SaveEngineConfigurationRequest defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="en", value="Control which language your users see text in initially.")
    @JsonProperty(value="defaultLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @JsonProperty(value="defaultLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public SaveEngineConfigurationRequest logos(List<Multimedia> logos) {
        this.logos = logos;
        return this;
    }

    public SaveEngineConfigurationRequest addLogosItem(Multimedia logosItem) {
        if (this.logos == null) {
            this.logos = new ArrayList<Multimedia>();
        }
        this.logos.add(logosItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Customize booking confirmation emails by adding a custom logo to your configuration.")
    @JsonProperty(value="logos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Multimedia> getLogos() {
        return this.logos;
    }

    @JsonProperty(value="logos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogos(List<Multimedia> logos) {
        this.logos = logos;
    }

    public SaveEngineConfigurationRequest hostedBookingEngineUrl(String hostedBookingEngineUrl) {
        this.hostedBookingEngineUrl = hostedBookingEngineUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://my.customtravelsite.com/book", value="If you are self-hosting our booking engine, let us know where it is hosted. Note: This url needs to be secured with SSL.")
    @JsonProperty(value="hostedBookingEngineUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHostedBookingEngineUrl() {
        return this.hostedBookingEngineUrl;
    }

    @JsonProperty(value="hostedBookingEngineUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHostedBookingEngineUrl(String hostedBookingEngineUrl) {
        this.hostedBookingEngineUrl = hostedBookingEngineUrl;
    }

    public SaveEngineConfigurationRequest selfHosted(Boolean selfHosted) {
        this.selfHosted = selfHosted;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate you are self-hosting our booking engine and not using our default booking engine url.")
    @JsonProperty(value="selfHosted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSelfHosted() {
        return this.selfHosted;
    }

    @JsonProperty(value="selfHosted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelfHosted(Boolean selfHosted) {
        this.selfHosted = selfHosted;
    }

    public SaveEngineConfigurationRequest themeColors(EngineConfigurationTheme themeColors) {
        this.themeColors = themeColors;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="themeColors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EngineConfigurationTheme getThemeColors() {
        return this.themeColors;
    }

    @JsonProperty(value="themeColors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThemeColors(EngineConfigurationTheme themeColors) {
        this.themeColors = themeColors;
    }

    public SaveEngineConfigurationRequest numberOfAdvanceDays(Integer numberOfAdvanceDays) {
        this.numberOfAdvanceDays = numberOfAdvanceDays;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long and how many days in advance (this field), of today's date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don't use either of these options, the itinerary will default to today's date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave `startDate` and `endDate` empty.")
    @JsonProperty(value="numberOfAdvanceDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfAdvanceDays() {
        return this.numberOfAdvanceDays;
    }

    @JsonProperty(value="numberOfAdvanceDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfAdvanceDays(Integer numberOfAdvanceDays) {
        this.numberOfAdvanceDays = numberOfAdvanceDays;
    }

    public SaveEngineConfigurationRequest numberOfStayDays(Integer numberOfStayDays) {
        this.numberOfStayDays = numberOfStayDays;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long (this field) and how many days in advance, of today's date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don't use either of these options, the itinerary will default to today's date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave `startDate` and `endDate` empty.")
    @JsonProperty(value="numberOfStayDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfStayDays() {
        return this.numberOfStayDays;
    }

    @JsonProperty(value="numberOfStayDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfStayDays(Integer numberOfStayDays) {
        this.numberOfStayDays = numberOfStayDays;
    }

    public SaveEngineConfigurationRequest startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Fri Dec 24 07:00:00 ICT 2021", value="Set a fixed itinerary start date. ONLY populate this field if you want to fix the itinerary date. Also, leave `numberOfAdvanceDays` and `numberOfStayDays` empty.")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public SaveEngineConfigurationRequest endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Fri Dec 31 07:00:00 ICT 2021", value="Set a fixed itinerary end date ONLY populate this field if you want to fix the itinerary date. Also, leave `numberOfAdvanceDays` and `numberOfStayDays` empty.")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public SaveEngineConfigurationRequest roomConfigurations(List<RoomConfiguration> roomConfigurations) {
        this.roomConfigurations = roomConfigurations;
        return this;
    }

    public SaveEngineConfigurationRequest addRoomConfigurationsItem(RoomConfiguration roomConfigurationsItem) {
        if (this.roomConfigurations == null) {
            this.roomConfigurations = new ArrayList<RoomConfiguration>();
        }
        this.roomConfigurations.add(roomConfigurationsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Control how many adults / children will be staying and how many rooms. Defaults to: One room, two adults.")
    @JsonProperty(value="roomConfigurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RoomConfiguration> getRoomConfigurations() {
        return this.roomConfigurations;
    }

    @JsonProperty(value="roomConfigurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomConfigurations(List<RoomConfiguration> roomConfigurations) {
        this.roomConfigurations = roomConfigurations;
    }

    public SaveEngineConfigurationRequest useDays(Boolean useDays) {
        this.useDays = useDays;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="if true, we use numberOfAdvanceDays / numberOfStayDays properties - false, we use startDate / endDate")
    @JsonProperty(value="useDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUseDays() {
        return this.useDays;
    }

    @JsonProperty(value="useDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseDays(Boolean useDays) {
        this.useDays = useDays;
    }

    public SaveEngineConfigurationRequest promotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
        return this;
    }

    public SaveEngineConfigurationRequest addPromotionalCodesItem(String promotionalCodesItem) {
        if (this.promotionalCodes == null) {
            this.promotionalCodes = new ArrayList<String>();
        }
        this.promotionalCodes.add(promotionalCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"promo-1\"]", value="If you've received special promotional codes from suppliers to give to your audience, you can choose to bake these code directly into the price by entering them here.")
    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPromotionalCodes() {
        return this.promotionalCodes;
    }

    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
    }

    public SaveEngineConfigurationRequest sendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
        this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="An integrator can choose to disable outgoing emails to properties because they want to do that themselves.")
    @JsonProperty(value="sendBookingNotificationEmailsToProperty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendBookingNotificationEmailsToProperty() {
        return this.sendBookingNotificationEmailsToProperty;
    }

    @JsonProperty(value="sendBookingNotificationEmailsToProperty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
        this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
    }

    public SaveEngineConfigurationRequest sendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
        this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="An integrator can choose to disable outgoing emails to users because they want to do that themselves.")
    @JsonProperty(value="sendBookingNotificationEmailsToBooker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendBookingNotificationEmailsToBooker() {
        return this.sendBookingNotificationEmailsToBooker;
    }

    @JsonProperty(value="sendBookingNotificationEmailsToBooker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
        this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
    }

    public SaveEngineConfigurationRequest wcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
        this.wcBookClickAction = wcBookClickAction;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="IBE_MODAL", value="Action to complete once a user clicks on the CTA button on inventory.")
    @JsonProperty(value="wcBookClickAction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WcBookClickActionEnum getWcBookClickAction() {
        return this.wcBookClickAction;
    }

    @JsonProperty(value="wcBookClickAction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
        this.wcBookClickAction = wcBookClickAction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SaveEngineConfigurationRequest saveEngineConfigurationRequest = (SaveEngineConfigurationRequest)o;
        return Objects.equals(this.name, saveEngineConfigurationRequest.name) && Objects.equals(this.appendToPageTitle, saveEngineConfigurationRequest.appendToPageTitle) && Objects.equals(this.facebookApiToken, saveEngineConfigurationRequest.facebookApiToken) && Objects.equals(this.googleOauthToken, saveEngineConfigurationRequest.googleOauthToken) && Objects.equals(this.wcFacebookApiToken, saveEngineConfigurationRequest.wcFacebookApiToken) && Objects.equals(this.wcGoogleOauthToken, saveEngineConfigurationRequest.wcGoogleOauthToken) && Objects.equals(this.googleTagManagerKey, saveEngineConfigurationRequest.googleTagManagerKey) && Objects.equals(this.wcGoogleTagManagerKey, saveEngineConfigurationRequest.wcGoogleTagManagerKey) && Objects.equals(this.googleMapsAPIKey, saveEngineConfigurationRequest.googleMapsAPIKey) && Objects.equals(this.wcGoogleMapsAPIKey, saveEngineConfigurationRequest.wcGoogleMapsAPIKey) && Objects.equals(this.tawkToKey, saveEngineConfigurationRequest.tawkToKey) && Objects.equals(this.wcTawkToKey, saveEngineConfigurationRequest.wcTawkToKey) && Objects.equals(this.recaptcha3Key, saveEngineConfigurationRequest.recaptcha3Key) && Objects.equals(this.recaptcha3SecretKey, saveEngineConfigurationRequest.recaptcha3SecretKey) && Objects.equals(this.defaultCurrency, saveEngineConfigurationRequest.defaultCurrency) && Objects.equals(this.defaultLanguage, saveEngineConfigurationRequest.defaultLanguage) && Objects.equals(this.logos, saveEngineConfigurationRequest.logos) && Objects.equals(this.hostedBookingEngineUrl, saveEngineConfigurationRequest.hostedBookingEngineUrl) && Objects.equals(this.selfHosted, saveEngineConfigurationRequest.selfHosted) && Objects.equals(this.themeColors, saveEngineConfigurationRequest.themeColors) && Objects.equals(this.numberOfAdvanceDays, saveEngineConfigurationRequest.numberOfAdvanceDays) && Objects.equals(this.numberOfStayDays, saveEngineConfigurationRequest.numberOfStayDays) && Objects.equals(this.startDate, saveEngineConfigurationRequest.startDate) && Objects.equals(this.endDate, saveEngineConfigurationRequest.endDate) && Objects.equals(this.roomConfigurations, saveEngineConfigurationRequest.roomConfigurations) && Objects.equals(this.useDays, saveEngineConfigurationRequest.useDays) && Objects.equals(this.promotionalCodes, saveEngineConfigurationRequest.promotionalCodes) && Objects.equals(this.sendBookingNotificationEmailsToProperty, saveEngineConfigurationRequest.sendBookingNotificationEmailsToProperty) && Objects.equals(this.sendBookingNotificationEmailsToBooker, saveEngineConfigurationRequest.sendBookingNotificationEmailsToBooker) && Objects.equals((Object)this.wcBookClickAction, (Object)saveEngineConfigurationRequest.wcBookClickAction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.appendToPageTitle, this.facebookApiToken, this.googleOauthToken, this.wcFacebookApiToken, this.wcGoogleOauthToken, this.googleTagManagerKey, this.wcGoogleTagManagerKey, this.googleMapsAPIKey, this.wcGoogleMapsAPIKey, this.tawkToKey, this.wcTawkToKey, this.recaptcha3Key, this.recaptcha3SecretKey, this.defaultCurrency, this.defaultLanguage, this.logos, this.hostedBookingEngineUrl, this.selfHosted, this.themeColors, this.numberOfAdvanceDays, this.numberOfStayDays, this.startDate, this.endDate, this.roomConfigurations, this.useDays, this.promotionalCodes, this.sendBookingNotificationEmailsToProperty, this.sendBookingNotificationEmailsToBooker, this.wcBookClickAction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SaveEngineConfigurationRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    appendToPageTitle: ").append(this.toIndentedString(this.appendToPageTitle)).append("\n");
        sb.append("    facebookApiToken: ").append(this.toIndentedString(this.facebookApiToken)).append("\n");
        sb.append("    googleOauthToken: ").append(this.toIndentedString(this.googleOauthToken)).append("\n");
        sb.append("    wcFacebookApiToken: ").append(this.toIndentedString(this.wcFacebookApiToken)).append("\n");
        sb.append("    wcGoogleOauthToken: ").append(this.toIndentedString(this.wcGoogleOauthToken)).append("\n");
        sb.append("    googleTagManagerKey: ").append(this.toIndentedString(this.googleTagManagerKey)).append("\n");
        sb.append("    wcGoogleTagManagerKey: ").append(this.toIndentedString(this.wcGoogleTagManagerKey)).append("\n");
        sb.append("    googleMapsAPIKey: ").append(this.toIndentedString(this.googleMapsAPIKey)).append("\n");
        sb.append("    wcGoogleMapsAPIKey: ").append(this.toIndentedString(this.wcGoogleMapsAPIKey)).append("\n");
        sb.append("    tawkToKey: ").append(this.toIndentedString(this.tawkToKey)).append("\n");
        sb.append("    wcTawkToKey: ").append(this.toIndentedString(this.wcTawkToKey)).append("\n");
        sb.append("    recaptcha3Key: ").append(this.toIndentedString(this.recaptcha3Key)).append("\n");
        sb.append("    recaptcha3SecretKey: ").append(this.toIndentedString(this.recaptcha3SecretKey)).append("\n");
        sb.append("    defaultCurrency: ").append(this.toIndentedString(this.defaultCurrency)).append("\n");
        sb.append("    defaultLanguage: ").append(this.toIndentedString(this.defaultLanguage)).append("\n");
        sb.append("    logos: ").append(this.toIndentedString(this.logos)).append("\n");
        sb.append("    hostedBookingEngineUrl: ").append(this.toIndentedString(this.hostedBookingEngineUrl)).append("\n");
        sb.append("    selfHosted: ").append(this.toIndentedString(this.selfHosted)).append("\n");
        sb.append("    themeColors: ").append(this.toIndentedString(this.themeColors)).append("\n");
        sb.append("    numberOfAdvanceDays: ").append(this.toIndentedString(this.numberOfAdvanceDays)).append("\n");
        sb.append("    numberOfStayDays: ").append(this.toIndentedString(this.numberOfStayDays)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    roomConfigurations: ").append(this.toIndentedString(this.roomConfigurations)).append("\n");
        sb.append("    useDays: ").append(this.toIndentedString(this.useDays)).append("\n");
        sb.append("    promotionalCodes: ").append(this.toIndentedString(this.promotionalCodes)).append("\n");
        sb.append("    sendBookingNotificationEmailsToProperty: ").append(this.toIndentedString(this.sendBookingNotificationEmailsToProperty)).append("\n");
        sb.append("    sendBookingNotificationEmailsToBooker: ").append(this.toIndentedString(this.sendBookingNotificationEmailsToBooker)).append("\n");
        sb.append("    wcBookClickAction: ").append(this.toIndentedString((Object)this.wcBookClickAction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum WcBookClickActionEnum {
        FORWARD_TO_IBE("FORWARD_TO_IBE"),
        IBE_MODAL("IBE_MODAL");

        private String value;

        private WcBookClickActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WcBookClickActionEnum fromValue(String value) {
            for (WcBookClickActionEnum b : WcBookClickActionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

