/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import travel.wink.sdk.affiliate.model.AddressDto;
import travel.wink.sdk.affiliate.model.ContactDto;
import travel.wink.sdk.affiliate.model.LocalizedPrice;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Place reservation records.
 */
@ApiModel(description = "Place reservation records.")
@JsonPropertyOrder({
  ExtraBookingRequest.JSON_PROPERTY_HOTEL_IDENTIFIER,
  ExtraBookingRequest.JSON_PROPERTY_TYPE_IDENTIFIER,
  ExtraBookingRequest.JSON_PROPERTY_NAME,
  ExtraBookingRequest.JSON_PROPERTY_PRICING_TYPE,
  ExtraBookingRequest.JSON_PROPERTY_TYPE,
  ExtraBookingRequest.JSON_PROPERTY_PRICE,
  ExtraBookingRequest.JSON_PROPERTY_START_DATE,
  ExtraBookingRequest.JSON_PROPERTY_END_DATE,
  ExtraBookingRequest.JSON_PROPERTY_ALL_DAY,
  ExtraBookingRequest.JSON_PROPERTY_ATTENDEES,
  ExtraBookingRequest.JSON_PROPERTY_IMAGE_IDENTIFIER,
  ExtraBookingRequest.JSON_PROPERTY_IMAGE_URL,
  ExtraBookingRequest.JSON_PROPERTY_LOCALIZED_NAME,
  ExtraBookingRequest.JSON_PROPERTY_LOCALIZED_DESCRIPTION,
  ExtraBookingRequest.JSON_PROPERTY_CONTACT,
  ExtraBookingRequest.JSON_PROPERTY_ADDRESS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:36:46.750260+07:00[Asia/Bangkok]")
public class ExtraBookingRequest {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
  private String typeIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  /**
   * Pricing type
   */
  public enum PricingTypeEnum {
    PERSON_PER_USE("PER_PERSON_PER_USE"),
    
    USE("PER_USE"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    HOUR("PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  /**
   * Inventory type
   */
  public enum TypeEnum {
    MEETING_ROOM("MEETING_ROOM"),
    
    SPA("SPA"),
    
    RESTAURANT("RESTAURANT"),
    
    ACTIVITY("ACTIVITY"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_PRICE = "price";
  private LocalizedPrice price;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private OffsetDateTime startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private OffsetDateTime endDate;

  public static final String JSON_PROPERTY_ALL_DAY = "allDay";
  private Boolean allDay = false;

  public static final String JSON_PROPERTY_ATTENDEES = "attendees";
  private Integer attendees = 1;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_IMAGE_URL = "imageUrl";
  private String imageUrl;

  public static final String JSON_PROPERTY_LOCALIZED_NAME = "localizedName";
  private String localizedName;

  public static final String JSON_PROPERTY_LOCALIZED_DESCRIPTION = "localizedDescription";
  private String localizedDescription;

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private ContactDto contact;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressDto address;

  public ExtraBookingRequest() { 
  }

  public ExtraBookingRequest hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "hotel-1", value = "Hotel identifier")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public ExtraBookingRequest typeIdentifier(String typeIdentifier) {
    
    this.typeIdentifier = typeIdentifier;
    return this;
  }

   /**
   * Travel inventory identifier
   * @return typeIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "place-1", value = "Travel inventory identifier")
  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTypeIdentifier() {
    return typeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTypeIdentifier(String typeIdentifier) {
    this.typeIdentifier = typeIdentifier;
  }


  public ExtraBookingRequest name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of inventory
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Place 1", value = "Name of inventory")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public ExtraBookingRequest pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * Pricing type
   * @return pricingType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "PER_USE", value = "Pricing type")
  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public ExtraBookingRequest type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Inventory type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "PLACE", value = "Inventory type")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public ExtraBookingRequest price(LocalizedPrice price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalizedPrice getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(LocalizedPrice price) {
    this.price = price;
  }


  public ExtraBookingRequest startDate(OffsetDateTime startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Date start time when reservation was made for.
   * @return startDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Date start time when reservation was made for.")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(OffsetDateTime startDate) {
    this.startDate = startDate;
  }


  public ExtraBookingRequest endDate(OffsetDateTime endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Date end time when reservation was made for.
   * @return endDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Date end time when reservation was made for.")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(OffsetDateTime endDate) {
    this.endDate = endDate;
  }


  public ExtraBookingRequest allDay(Boolean allDay) {
    
    this.allDay = allDay;
    return this;
  }

   /**
   * Indicates if this reservation is for the whole day.
   * @return allDay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Indicates if this reservation is for the whole day.")
  @JsonProperty(JSON_PROPERTY_ALL_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllDay() {
    return allDay;
  }


  @JsonProperty(JSON_PROPERTY_ALL_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllDay(Boolean allDay) {
    this.allDay = allDay;
  }


  public ExtraBookingRequest attendees(Integer attendees) {
    
    this.attendees = attendees;
    return this;
  }

   /**
   * Number of guests that are part of this reservation.
   * @return attendees
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2", value = "Number of guests that are part of this reservation.")
  @JsonProperty(JSON_PROPERTY_ATTENDEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAttendees() {
    return attendees;
  }


  @JsonProperty(JSON_PROPERTY_ATTENDEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttendees(Integer attendees) {
    this.attendees = attendees;
  }


  public ExtraBookingRequest imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Cloudinary image identifier
   * @return imageIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "cloudinary-image-1", value = "Cloudinary image identifier")
  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public ExtraBookingRequest imageUrl(String imageUrl) {
    
    this.imageUrl = imageUrl;
    return this;
  }

   /**
   * Absolute URL to image of inventory
   * @return imageUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "https://path.to.image.com/this-is-me.jpg", value = "Absolute URL to image of inventory")
  @JsonProperty(JSON_PROPERTY_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageUrl() {
    return imageUrl;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
  }


  public ExtraBookingRequest localizedName(String localizedName) {
    
    this.localizedName = localizedName;
    return this;
  }

   /**
   * Name of travel inventory in traveler language (if available). Defaults to English.
   * @return localizedName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Plass 1", value = "Name of travel inventory in traveler language (if available). Defaults to English.")
  @JsonProperty(JSON_PROPERTY_LOCALIZED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocalizedName() {
    return localizedName;
  }


  @JsonProperty(JSON_PROPERTY_LOCALIZED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalizedName(String localizedName) {
    this.localizedName = localizedName;
  }


  public ExtraBookingRequest localizedDescription(String localizedDescription) {
    
    this.localizedDescription = localizedDescription;
    return this;
  }

   /**
   * Description of travel inventory in traveler language (if available). Defaults to English.
   * @return localizedDescription
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "place-1", value = "Description of travel inventory in traveler language (if available). Defaults to English.")
  @JsonProperty(JSON_PROPERTY_LOCALIZED_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocalizedDescription() {
    return localizedDescription;
  }


  @JsonProperty(JSON_PROPERTY_LOCALIZED_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalizedDescription(String localizedDescription) {
    this.localizedDescription = localizedDescription;
  }


  public ExtraBookingRequest contact(ContactDto contact) {
    
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContactDto getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContact(ContactDto contact) {
    this.contact = contact;
  }


  public ExtraBookingRequest address(AddressDto address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddressDto getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(AddressDto address) {
    this.address = address;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExtraBookingRequest extraBookingRequest = (ExtraBookingRequest) o;
    return Objects.equals(this.hotelIdentifier, extraBookingRequest.hotelIdentifier) &&
        Objects.equals(this.typeIdentifier, extraBookingRequest.typeIdentifier) &&
        Objects.equals(this.name, extraBookingRequest.name) &&
        Objects.equals(this.pricingType, extraBookingRequest.pricingType) &&
        Objects.equals(this.type, extraBookingRequest.type) &&
        Objects.equals(this.price, extraBookingRequest.price) &&
        Objects.equals(this.startDate, extraBookingRequest.startDate) &&
        Objects.equals(this.endDate, extraBookingRequest.endDate) &&
        Objects.equals(this.allDay, extraBookingRequest.allDay) &&
        Objects.equals(this.attendees, extraBookingRequest.attendees) &&
        Objects.equals(this.imageIdentifier, extraBookingRequest.imageIdentifier) &&
        Objects.equals(this.imageUrl, extraBookingRequest.imageUrl) &&
        Objects.equals(this.localizedName, extraBookingRequest.localizedName) &&
        Objects.equals(this.localizedDescription, extraBookingRequest.localizedDescription) &&
        Objects.equals(this.contact, extraBookingRequest.contact) &&
        Objects.equals(this.address, extraBookingRequest.address);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, typeIdentifier, name, pricingType, type, price, startDate, endDate, allDay, attendees, imageIdentifier, imageUrl, localizedName, localizedDescription, contact, address);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExtraBookingRequest {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    typeIdentifier: ").append(toIndentedString(typeIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    allDay: ").append(toIndentedString(allDay)).append("\n");
    sb.append("    attendees: ").append(toIndentedString(attendees)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    imageUrl: ").append(toIndentedString(imageUrl)).append("\n");
    sb.append("    localizedName: ").append(toIndentedString(localizedName)).append("\n");
    sb.append("    localizedDescription: ").append(toIndentedString(localizedDescription)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

