/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.affiliate.model.Bundle;
import travel.wink.sdk.affiliate.model.LocalizedPrice;
import travel.wink.sdk.affiliate.model.SimpleDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PackageOffer
 */
@JsonPropertyOrder({
  PackageOffer.JSON_PROPERTY_PRICE,
  PackageOffer.JSON_PROPERTY_UNIT_PRICE,
  PackageOffer.JSON_PROPERTY_PACKAGE_IMAGE_URL,
  PackageOffer.JSON_PROPERTY_BUNDLE,
  PackageOffer.JSON_PROPERTY_OFFER_DETAILS,
  PackageOffer.JSON_PROPERTY_PROMOTION,
  PackageOffer.JSON_PROPERTY_GUESTS,
  PackageOffer.JSON_PROPERTY_NIGHTS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:36:46.750260+07:00[Asia/Bangkok]")
public class PackageOffer {
  public static final String JSON_PROPERTY_PRICE = "price";
  private LocalizedPrice price;

  public static final String JSON_PROPERTY_UNIT_PRICE = "unitPrice";
  private LocalizedPrice unitPrice;

  public static final String JSON_PROPERTY_PACKAGE_IMAGE_URL = "packageImageUrl";
  private String packageImageUrl;

  public static final String JSON_PROPERTY_BUNDLE = "bundle";
  private Bundle bundle;

  public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
  private List<SimpleDescription> offerDetails = null;

  public static final String JSON_PROPERTY_PROMOTION = "promotion";
  private String promotion;

  public static final String JSON_PROPERTY_GUESTS = "guests";
  private Integer guests;

  public static final String JSON_PROPERTY_NIGHTS = "nights";
  private Integer nights;

  public PackageOffer() { 
  }

  public PackageOffer price(LocalizedPrice price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalizedPrice getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(LocalizedPrice price) {
    this.price = price;
  }


  public PackageOffer unitPrice(LocalizedPrice unitPrice) {
    
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * Get unitPrice
   * @return unitPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UNIT_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalizedPrice getUnitPrice() {
    return unitPrice;
  }


  @JsonProperty(JSON_PROPERTY_UNIT_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnitPrice(LocalizedPrice unitPrice) {
    this.unitPrice = unitPrice;
  }


  public PackageOffer packageImageUrl(String packageImageUrl) {
    
    this.packageImageUrl = packageImageUrl;
    return this;
  }

   /**
   * Populated for when we send out confirmation emails to travelers.
   * @return packageImageUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Populated for when we send out confirmation emails to travelers.")
  @JsonProperty(JSON_PROPERTY_PACKAGE_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPackageImageUrl() {
    return packageImageUrl;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGE_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageImageUrl(String packageImageUrl) {
    this.packageImageUrl = packageImageUrl;
  }


  public PackageOffer bundle(Bundle bundle) {
    
    this.bundle = bundle;
    return this;
  }

   /**
   * Get bundle
   * @return bundle
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BUNDLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Bundle getBundle() {
    return bundle;
  }


  @JsonProperty(JSON_PROPERTY_BUNDLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBundle(Bundle bundle) {
    this.bundle = bundle;
  }


  public PackageOffer offerDetails(List<SimpleDescription> offerDetails) {
    
    this.offerDetails = offerDetails;
    return this;
  }

  public PackageOffer addOfferDetailsItem(SimpleDescription offerDetailsItem) {
    if (this.offerDetails == null) {
      this.offerDetails = new ArrayList<>();
    }
    this.offerDetails.add(offerDetailsItem);
    return this;
  }

   /**
   * Localized offer details if any apply
   * @return offerDetails
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Localized offer details if any apply")
  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescription> getOfferDetails() {
    return offerDetails;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfferDetails(List<SimpleDescription> offerDetails) {
    this.offerDetails = offerDetails;
  }


  public PackageOffer promotion(String promotion) {
    
    this.promotion = promotion;
    return this;
  }

   /**
   * If a package is linked to a rate plan the user could be entitled to a promotional discount if she enters a code. When this field is populated, it means the discount was applied to the package.
   * @return promotion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If a package is linked to a rate plan the user could be entitled to a promotional discount if she enters a code. When this field is populated, it means the discount was applied to the package.")
  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPromotion() {
    return promotion;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotion(String promotion) {
    this.promotion = promotion;
  }


  public PackageOffer guests(Integer guests) {
    
    this.guests = guests;
    return this;
  }

   /**
   * Number of guests
   * @return guests
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Number of guests")
  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGuests() {
    return guests;
  }


  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuests(Integer guests) {
    this.guests = guests;
  }


  public PackageOffer nights(Integer nights) {
    
    this.nights = nights;
    return this;
  }

   /**
   * Number of nights
   * @return nights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Number of nights")
  @JsonProperty(JSON_PROPERTY_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNights() {
    return nights;
  }


  @JsonProperty(JSON_PROPERTY_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNights(Integer nights) {
    this.nights = nights;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PackageOffer packageOffer = (PackageOffer) o;
    return Objects.equals(this.price, packageOffer.price) &&
        Objects.equals(this.unitPrice, packageOffer.unitPrice) &&
        Objects.equals(this.packageImageUrl, packageOffer.packageImageUrl) &&
        Objects.equals(this.bundle, packageOffer.bundle) &&
        Objects.equals(this.offerDetails, packageOffer.offerDetails) &&
        Objects.equals(this.promotion, packageOffer.promotion) &&
        Objects.equals(this.guests, packageOffer.guests) &&
        Objects.equals(this.nights, packageOffer.nights);
  }

  @Override
  public int hashCode() {
    return Objects.hash(price, unitPrice, packageImageUrl, bundle, offerDetails, promotion, guests, nights);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PackageOffer {\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    packageImageUrl: ").append(toIndentedString(packageImageUrl)).append("\n");
    sb.append("    bundle: ").append(toIndentedString(bundle)).append("\n");
    sb.append("    offerDetails: ").append(toIndentedString(offerDetails)).append("\n");
    sb.append("    promotion: ").append(toIndentedString(promotion)).append("\n");
    sb.append("    guests: ").append(toIndentedString(guests)).append("\n");
    sb.append("    nights: ").append(toIndentedString(nights)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

