/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * StatusTransitions
 */
@JsonPropertyOrder({
  StatusTransitions.JSON_PROPERTY_FINALIZED_AT,
  StatusTransitions.JSON_PROPERTY_MARKED_UNCOLLECTIBLE_AT,
  StatusTransitions.JSON_PROPERTY_PAID_AT,
  StatusTransitions.JSON_PROPERTY_VOIDED_AT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:36:46.750260+07:00[Asia/Bangkok]")
public class StatusTransitions {
  public static final String JSON_PROPERTY_FINALIZED_AT = "finalizedAt";
  private Long finalizedAt;

  public static final String JSON_PROPERTY_MARKED_UNCOLLECTIBLE_AT = "markedUncollectibleAt";
  private Long markedUncollectibleAt;

  public static final String JSON_PROPERTY_PAID_AT = "paidAt";
  private Long paidAt;

  public static final String JSON_PROPERTY_VOIDED_AT = "voidedAt";
  private Long voidedAt;

  public StatusTransitions() { 
  }

  public StatusTransitions finalizedAt(Long finalizedAt) {
    
    this.finalizedAt = finalizedAt;
    return this;
  }

   /**
   * Get finalizedAt
   * @return finalizedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FINALIZED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getFinalizedAt() {
    return finalizedAt;
  }


  @JsonProperty(JSON_PROPERTY_FINALIZED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFinalizedAt(Long finalizedAt) {
    this.finalizedAt = finalizedAt;
  }


  public StatusTransitions markedUncollectibleAt(Long markedUncollectibleAt) {
    
    this.markedUncollectibleAt = markedUncollectibleAt;
    return this;
  }

   /**
   * Get markedUncollectibleAt
   * @return markedUncollectibleAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MARKED_UNCOLLECTIBLE_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMarkedUncollectibleAt() {
    return markedUncollectibleAt;
  }


  @JsonProperty(JSON_PROPERTY_MARKED_UNCOLLECTIBLE_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarkedUncollectibleAt(Long markedUncollectibleAt) {
    this.markedUncollectibleAt = markedUncollectibleAt;
  }


  public StatusTransitions paidAt(Long paidAt) {
    
    this.paidAt = paidAt;
    return this;
  }

   /**
   * Get paidAt
   * @return paidAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAID_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPaidAt() {
    return paidAt;
  }


  @JsonProperty(JSON_PROPERTY_PAID_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaidAt(Long paidAt) {
    this.paidAt = paidAt;
  }


  public StatusTransitions voidedAt(Long voidedAt) {
    
    this.voidedAt = voidedAt;
    return this;
  }

   /**
   * Get voidedAt
   * @return voidedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VOIDED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVoidedAt() {
    return voidedAt;
  }


  @JsonProperty(JSON_PROPERTY_VOIDED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVoidedAt(Long voidedAt) {
    this.voidedAt = voidedAt;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StatusTransitions statusTransitions = (StatusTransitions) o;
    return Objects.equals(this.finalizedAt, statusTransitions.finalizedAt) &&
        Objects.equals(this.markedUncollectibleAt, statusTransitions.markedUncollectibleAt) &&
        Objects.equals(this.paidAt, statusTransitions.paidAt) &&
        Objects.equals(this.voidedAt, statusTransitions.voidedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(finalizedAt, markedUncollectibleAt, paidAt, voidedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StatusTransitions {\n");
    sb.append("    finalizedAt: ").append(toIndentedString(finalizedAt)).append("\n");
    sb.append("    markedUncollectibleAt: ").append(toIndentedString(markedUncollectibleAt)).append("\n");
    sb.append("    paidAt: ").append(toIndentedString(paidAt)).append("\n");
    sb.append("    voidedAt: ").append(toIndentedString(voidedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

