/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.affiliate.model.CancellationPolicy;

@JsonPropertyOrder(value={"cancellationPolicyIdentifier", "cancellationPolicy", "startDate", "endDate"})
public class CancellationPolicyException {
    public static final String JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER = "cancellationPolicyIdentifier";
    private String cancellationPolicyIdentifier;
    public static final String JSON_PROPERTY_CANCELLATION_POLICY = "cancellationPolicy";
    private CancellationPolicy cancellationPolicy;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;

    public CancellationPolicyException cancellationPolicyIdentifier(String cancellationPolicyIdentifier) {
        this.cancellationPolicyIdentifier = cancellationPolicyIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Cancellation policy")
    @JsonProperty(value="cancellationPolicyIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCancellationPolicyIdentifier() {
        return this.cancellationPolicyIdentifier;
    }

    @JsonProperty(value="cancellationPolicyIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCancellationPolicyIdentifier(String cancellationPolicyIdentifier) {
        this.cancellationPolicyIdentifier = cancellationPolicyIdentifier;
    }

    public CancellationPolicyException cancellationPolicy(CancellationPolicy cancellationPolicy) {
        this.cancellationPolicy = cancellationPolicy;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="cancellationPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellationPolicy getCancellationPolicy() {
        return this.cancellationPolicy;
    }

    @JsonProperty(value="cancellationPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellationPolicy(CancellationPolicy cancellationPolicy) {
        this.cancellationPolicy = cancellationPolicy;
    }

    public CancellationPolicyException startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Start date for when this cancellation policy should start to override the default cancellation policy.")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public CancellationPolicyException endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="End date for when this cancellation policy should end overriding the default cancellation policy.")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancellationPolicyException cancellationPolicyException = (CancellationPolicyException)o;
        return Objects.equals(this.cancellationPolicyIdentifier, cancellationPolicyException.cancellationPolicyIdentifier) && Objects.equals(this.cancellationPolicy, cancellationPolicyException.cancellationPolicy) && Objects.equals(this.startDate, cancellationPolicyException.startDate) && Objects.equals(this.endDate, cancellationPolicyException.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.cancellationPolicyIdentifier, this.cancellationPolicy, this.startDate, this.endDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CancellationPolicyException {\n");
        sb.append("    cancellationPolicyIdentifier: ").append(this.toIndentedString(this.cancellationPolicyIdentifier)).append("\n");
        sb.append("    cancellationPolicy: ").append(this.toIndentedString(this.cancellationPolicy)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

