/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.affiliate.model.ReviewAnswerOption;

@JsonPropertyOrder(value={"identifier", "questionIdentifier", "category", "sort", "answer"})
public class ReviewAnswer {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_QUESTION_IDENTIFIER = "questionIdentifier";
    private String questionIdentifier;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort;
    public static final String JSON_PROPERTY_ANSWER = "answer";
    private ReviewAnswerOption answer;

    public ReviewAnswer identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Answer identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public ReviewAnswer questionIdentifier(String questionIdentifier) {
        this.questionIdentifier = questionIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Question identifier")
    @JsonProperty(value="questionIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuestionIdentifier() {
        return this.questionIdentifier;
    }

    @JsonProperty(value="questionIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuestionIdentifier(String questionIdentifier) {
        this.questionIdentifier = questionIdentifier;
    }

    public ReviewAnswer category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Question category")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public ReviewAnswer sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sort key")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public ReviewAnswer answer(ReviewAnswerOption answer) {
        this.answer = answer;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="answer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReviewAnswerOption getAnswer() {
        return this.answer;
    }

    @JsonProperty(value="answer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnswer(ReviewAnswerOption answer) {
        this.answer = answer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReviewAnswer reviewAnswer = (ReviewAnswer)o;
        return Objects.equals(this.identifier, reviewAnswer.identifier) && Objects.equals(this.questionIdentifier, reviewAnswer.questionIdentifier) && Objects.equals((Object)this.category, (Object)reviewAnswer.category) && Objects.equals(this.sort, reviewAnswer.sort) && Objects.equals(this.answer, reviewAnswer.answer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.questionIdentifier, this.category, this.sort, this.answer});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReviewAnswer {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    questionIdentifier: ").append(this.toIndentedString(this.questionIdentifier)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    answer: ").append(this.toIndentedString(this.answer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CategoryEnum {
        COMFORT("COMFORT"),
        CONDITION("CONDITION"),
        SERVICE("SERVICE"),
        ENVIRONMENT("ENVIRONMENT"),
        FACILITIES("FACILITIES"),
        LOCATION("LOCATION"),
        LIFESTYLE("LIFESTYLE"),
        VALUE("VALUE"),
        FOOD("FOOD");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

