/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.EngineView;
import travel.wink.sdk.affiliate.model.RemoveEntryResponse;
import travel.wink.sdk.affiliate.model.SaveEngineRequest;
import travel.wink.sdk.affiliate.model.UniqueRequest;
import travel.wink.sdk.affiliate.model.UniqueResult;

public class ApplicationApi {
    private ApiClient apiClient;

    public ApplicationApi() {
        this(new ApiClient());
    }

    @Autowired
    public ApplicationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec isEngineNameUniqueRequestCreation(UniqueRequest uniqueRequest) throws WebClientResponseException {
        UniqueRequest postBody = uniqueRequest;
        if (uniqueRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'uniqueRequest' when calling isEngineNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(){};
        return this.apiClient.invokeAPI("/api/application/unique", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UniqueResult> isEngineNameUnique(UniqueRequest uniqueRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(){};
        return this.isEngineNameUniqueRequestCreation(uniqueRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResult>> isEngineNameUniqueWithHttpInfo(UniqueRequest uniqueRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResult> localVarReturnType = new ParameterizedTypeReference<UniqueResult>(){};
        return this.isEngineNameUniqueRequestCreation(uniqueRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeApplicationRequestCreation(String companyIdentifier, String engineIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (engineIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineIdentifier' when calling removeApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineIdentifier", engineIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/application/{engineIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeApplication(String companyIdentifier, String engineIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeApplicationRequestCreation(companyIdentifier, engineIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeApplicationWithHttpInfo(String companyIdentifier, String engineIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeApplicationRequestCreation(companyIdentifier, engineIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec saveApplicationRequestCreation(String companyIdentifier, SaveEngineRequest saveEngineRequest) throws WebClientResponseException {
        SaveEngineRequest postBody = saveEngineRequest;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling saveApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (saveEngineRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'saveEngineRequest' when calling saveApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/application", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineView> saveApplication(String companyIdentifier, SaveEngineRequest saveEngineRequest) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.saveApplicationRequestCreation(companyIdentifier, saveEngineRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineView>> saveApplicationWithHttpInfo(String companyIdentifier, SaveEngineRequest saveEngineRequest) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.saveApplicationRequestCreation(companyIdentifier, saveEngineRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showAllApplicationsForUserRequestCreation(String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.apiClient.invokeAPI("/api/application/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<EngineView> showAllApplicationsForUser(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.showAllApplicationsForUserRequestCreation(accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<EngineView>>> showAllApplicationsForUserWithHttpInfo(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.showAllApplicationsForUserRequestCreation(accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showApplicationRequestCreation(String companyIdentifier, String engineIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (engineIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineIdentifier' when calling showApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineIdentifier", engineIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/application/{engineIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineView> showApplication(String companyIdentifier, String engineIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.showApplicationRequestCreation(companyIdentifier, engineIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineView>> showApplicationWithHttpInfo(String companyIdentifier, String engineIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.showApplicationRequestCreation(companyIdentifier, engineIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showApplicationsRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showApplications", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/application/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<EngineView> showApplications(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.showApplicationsRequestCreation(companyIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<EngineView>>> showApplicationsWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.showApplicationsRequestCreation(companyIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateApplicationRequestCreation(String companyIdentifier, String engineIdentifier, SaveEngineRequest saveEngineRequest) throws WebClientResponseException {
        SaveEngineRequest postBody = saveEngineRequest;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (engineIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineIdentifier' when calling updateApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (saveEngineRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'saveEngineRequest' when calling updateApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineIdentifier", engineIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/application/{engineIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineView> updateApplication(String companyIdentifier, String engineIdentifier, SaveEngineRequest saveEngineRequest) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.updateApplicationRequestCreation(companyIdentifier, engineIdentifier, saveEngineRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineView>> updateApplicationWithHttpInfo(String companyIdentifier, String engineIdentifier, SaveEngineRequest saveEngineRequest) throws WebClientResponseException {
        ParameterizedTypeReference<EngineView> localVarReturnType = new ParameterizedTypeReference<EngineView>(){};
        return this.updateApplicationRequestCreation(companyIdentifier, engineIdentifier, saveEngineRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

