/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.affiliate.model.Moneys;

@JsonPropertyOrder(value={"accountIdentifier", "type", "amountDueInSourceCurrency", "amountDueInDisplayCurrency", "amountDueInSupplierCurrency", "amountDueInInternalCurrency", "amountDueInCaptureCurrency"})
public class Beneficiary {
    public static final String JSON_PROPERTY_ACCOUNT_IDENTIFIER = "accountIdentifier";
    private String accountIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SOURCE_CURRENCY = "amountDueInSourceCurrency";
    private Moneys amountDueInSourceCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_DISPLAY_CURRENCY = "amountDueInDisplayCurrency";
    private Moneys amountDueInDisplayCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_SUPPLIER_CURRENCY = "amountDueInSupplierCurrency";
    private Moneys amountDueInSupplierCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_INTERNAL_CURRENCY = "amountDueInInternalCurrency";
    private Moneys amountDueInInternalCurrency;
    public static final String JSON_PROPERTY_AMOUNT_DUE_IN_CAPTURE_CURRENCY = "amountDueInCaptureCurrency";
    private Moneys amountDueInCaptureCurrency;

    public Beneficiary accountIdentifier(String accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="external-account-1", required=true, value="accountIdentifier of beneficiary from payment")
    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @JsonProperty(value="accountIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountIdentifier(String accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
    }

    public Beneficiary type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="The type of beneficiary payment.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Beneficiary amountDueInSourceCurrency(Moneys amountDueInSourceCurrency) {
        this.amountDueInSourceCurrency = amountDueInSourceCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInSourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInSourceCurrency() {
        return this.amountDueInSourceCurrency;
    }

    @JsonProperty(value="amountDueInSourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInSourceCurrency(Moneys amountDueInSourceCurrency) {
        this.amountDueInSourceCurrency = amountDueInSourceCurrency;
    }

    public Beneficiary amountDueInDisplayCurrency(Moneys amountDueInDisplayCurrency) {
        this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInDisplayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInDisplayCurrency() {
        return this.amountDueInDisplayCurrency;
    }

    @JsonProperty(value="amountDueInDisplayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInDisplayCurrency(Moneys amountDueInDisplayCurrency) {
        this.amountDueInDisplayCurrency = amountDueInDisplayCurrency;
    }

    public Beneficiary amountDueInSupplierCurrency(Moneys amountDueInSupplierCurrency) {
        this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInSupplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInSupplierCurrency() {
        return this.amountDueInSupplierCurrency;
    }

    @JsonProperty(value="amountDueInSupplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInSupplierCurrency(Moneys amountDueInSupplierCurrency) {
        this.amountDueInSupplierCurrency = amountDueInSupplierCurrency;
    }

    public Beneficiary amountDueInInternalCurrency(Moneys amountDueInInternalCurrency) {
        this.amountDueInInternalCurrency = amountDueInInternalCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInInternalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInInternalCurrency() {
        return this.amountDueInInternalCurrency;
    }

    @JsonProperty(value="amountDueInInternalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInInternalCurrency(Moneys amountDueInInternalCurrency) {
        this.amountDueInInternalCurrency = amountDueInInternalCurrency;
    }

    public Beneficiary amountDueInCaptureCurrency(Moneys amountDueInCaptureCurrency) {
        this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amountDueInCaptureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getAmountDueInCaptureCurrency() {
        return this.amountDueInCaptureCurrency;
    }

    @JsonProperty(value="amountDueInCaptureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmountDueInCaptureCurrency(Moneys amountDueInCaptureCurrency) {
        this.amountDueInCaptureCurrency = amountDueInCaptureCurrency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Beneficiary beneficiary = (Beneficiary)o;
        return Objects.equals(this.accountIdentifier, beneficiary.accountIdentifier) && Objects.equals((Object)this.type, (Object)beneficiary.type) && Objects.equals(this.amountDueInSourceCurrency, beneficiary.amountDueInSourceCurrency) && Objects.equals(this.amountDueInDisplayCurrency, beneficiary.amountDueInDisplayCurrency) && Objects.equals(this.amountDueInSupplierCurrency, beneficiary.amountDueInSupplierCurrency) && Objects.equals(this.amountDueInInternalCurrency, beneficiary.amountDueInInternalCurrency) && Objects.equals(this.amountDueInCaptureCurrency, beneficiary.amountDueInCaptureCurrency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountIdentifier, this.type, this.amountDueInSourceCurrency, this.amountDueInDisplayCurrency, this.amountDueInSupplierCurrency, this.amountDueInInternalCurrency, this.amountDueInCaptureCurrency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Beneficiary {\n");
        sb.append("    accountIdentifier: ").append(this.toIndentedString(this.accountIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    amountDueInSourceCurrency: ").append(this.toIndentedString(this.amountDueInSourceCurrency)).append("\n");
        sb.append("    amountDueInDisplayCurrency: ").append(this.toIndentedString(this.amountDueInDisplayCurrency)).append("\n");
        sb.append("    amountDueInSupplierCurrency: ").append(this.toIndentedString(this.amountDueInSupplierCurrency)).append("\n");
        sb.append("    amountDueInInternalCurrency: ").append(this.toIndentedString(this.amountDueInInternalCurrency)).append("\n");
        sb.append("    amountDueInCaptureCurrency: ").append(this.toIndentedString(this.amountDueInCaptureCurrency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        COMMISSION("COMMISSION"),
        PLATFORM_FEE("PLATFORM_FEE"),
        SALE("SALE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

