/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.affiliate.model.RateModifier;
import travel.wink.sdk.affiliate.model.RateModifierBundle;

@ApiModel(description="Parent sales channel")
@JsonPropertyOrder(value={"identifier", "supplierIdentifier", "supplierName", "supplierAvailable", "subType", "ownerIdentifier", "ownerName", "enabled", "channelDisabled", "blacklisted", "percentDiscount", "commission", "rateModifiers", "rateModifierBundles"})
public class SalesChannel {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private String supplierIdentifier;
    public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
    private String supplierName;
    public static final String JSON_PROPERTY_SUPPLIER_AVAILABLE = "supplierAvailable";
    private Boolean supplierAvailable = true;
    public static final String JSON_PROPERTY_SUB_TYPE = "subType";
    private SubTypeEnum subType;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    private String ownerIdentifier;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    private String ownerName;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_CHANNEL_DISABLED = "channelDisabled";
    private Boolean channelDisabled;
    public static final String JSON_PROPERTY_BLACKLISTED = "blacklisted";
    private Boolean blacklisted;
    public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
    private Float percentDiscount;
    public static final String JSON_PROPERTY_COMMISSION = "commission";
    private Float commission;
    public static final String JSON_PROPERTY_RATE_MODIFIERS = "rateModifiers";
    private List<RateModifier> rateModifiers = null;
    public static final String JSON_PROPERTY_RATE_MODIFIER_BUNDLES = "rateModifierBundles";
    private List<RateModifierBundle> rateModifierBundles = null;

    public SalesChannel() {
    }

    @JsonCreator
    public SalesChannel(@JsonProperty(value="supplierName") String supplierName) {
        this();
        this.supplierName = supplierName;
    }

    public SalesChannel identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="segment-1", value="Unique record identifier of this segment / account")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public SalesChannel supplierIdentifier(String supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="hotel-1", value="Channel is owned by this supplier identifier.")
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupplierIdentifier(String supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    @Nullable
    @ApiModelProperty(example="Hotel 1", value="Name of property / supplier that owns this channel")
    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSupplierName() {
        return this.supplierName;
    }

    public SalesChannel supplierAvailable(Boolean supplierAvailable) {
        this.supplierAvailable = supplierAvailable;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag when supplier not available. E.g. Hotel disables property")
    @JsonProperty(value="supplierAvailable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSupplierAvailable() {
        return this.supplierAvailable;
    }

    @JsonProperty(value="supplierAvailable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupplierAvailable(Boolean supplierAvailable) {
        this.supplierAvailable = supplierAvailable;
    }

    public SalesChannel subType(SubTypeEnum subType) {
        this.subType = subType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="DIRECT", required=true, value="What type of segment of channel is this.")
    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SubTypeEnum getSubType() {
        return this.subType;
    }

    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubType(SubTypeEnum subType) {
        this.subType = subType;
    }

    public SalesChannel ownerIdentifier(String ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="owner-1", required=true, value="A specific identifier for the company / corporation / travel agency that is retrieving the rates")
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerIdentifier(String ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public SalesChannel ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Owner 1", required=true, value="Name of the owner / affiliate. `Hotel booking engine` when it's the booking engine.")
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public SalesChannel enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Flag the supplier can use to enable / disable this channel")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public SalesChannel channelDisabled(Boolean channelDisabled) {
        this.channelDisabled = channelDisabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="System override by payment to disable. E.g. Platform disables supplier.")
    @JsonProperty(value="channelDisabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getChannelDisabled() {
        return this.channelDisabled;
    }

    @JsonProperty(value="channelDisabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannelDisabled(Boolean channelDisabled) {
        this.channelDisabled = channelDisabled;
    }

    public SalesChannel blacklisted(Boolean blacklisted) {
        this.blacklisted = blacklisted;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="A way to blacklist a specific channel a property doesn't want to send inventory to.")
    @JsonProperty(value="blacklisted")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBlacklisted() {
        return this.blacklisted;
    }

    @JsonProperty(value="blacklisted")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBlacklisted(Boolean blacklisted) {
        this.blacklisted = blacklisted;
    }

    public SalesChannel percentDiscount(Float percentDiscount) {
        this.percentDiscount = percentDiscount;
        return this;
    }

    @Nullable
    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    @ApiModelProperty(example="0.15", value="Percent discount on this channel and all its children [unless configured at the child level].")
    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0.0") @DecimalMax(value="1.0") Float getPercentDiscount() {
        return this.percentDiscount;
    }

    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPercentDiscount(Float percentDiscount) {
        this.percentDiscount = percentDiscount;
    }

    public SalesChannel commission(Float commission) {
        this.commission = commission;
        return this;
    }

    @Nullable
    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    @ApiModelProperty(example="0.2", value="Amount of sales commission earned through this channel and all its children [unless configured at the child level].")
    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0.0") @DecimalMax(value="1.0") Float getCommission() {
        return this.commission;
    }

    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommission(Float commission) {
        this.commission = commission;
    }

    public SalesChannel rateModifiers(List<RateModifier> rateModifiers) {
        this.rateModifiers = rateModifiers;
        return this;
    }

    public SalesChannel addRateModifiersItem(RateModifier rateModifiersItem) {
        if (this.rateModifiers == null) {
            this.rateModifiers = new ArrayList<RateModifier>();
        }
        this.rateModifiers.add(rateModifiersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Promotions for this channel")
    @JsonProperty(value="rateModifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RateModifier> getRateModifiers() {
        return this.rateModifiers;
    }

    @JsonProperty(value="rateModifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateModifiers(List<RateModifier> rateModifiers) {
        this.rateModifiers = rateModifiers;
    }

    public SalesChannel rateModifierBundles(List<RateModifierBundle> rateModifierBundles) {
        this.rateModifierBundles = rateModifierBundles;
        return this;
    }

    public SalesChannel addRateModifierBundlesItem(RateModifierBundle rateModifierBundlesItem) {
        if (this.rateModifierBundles == null) {
            this.rateModifierBundles = new ArrayList<RateModifierBundle>();
        }
        this.rateModifierBundles.add(rateModifierBundlesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Promotion bundles for this channel")
    @JsonProperty(value="rateModifierBundles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RateModifierBundle> getRateModifierBundles() {
        return this.rateModifierBundles;
    }

    @JsonProperty(value="rateModifierBundles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateModifierBundles(List<RateModifierBundle> rateModifierBundles) {
        this.rateModifierBundles = rateModifierBundles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SalesChannel salesChannel = (SalesChannel)o;
        return Objects.equals(this.identifier, salesChannel.identifier) && Objects.equals(this.supplierIdentifier, salesChannel.supplierIdentifier) && Objects.equals(this.supplierName, salesChannel.supplierName) && Objects.equals(this.supplierAvailable, salesChannel.supplierAvailable) && Objects.equals((Object)this.subType, (Object)salesChannel.subType) && Objects.equals(this.ownerIdentifier, salesChannel.ownerIdentifier) && Objects.equals(this.ownerName, salesChannel.ownerName) && Objects.equals(this.enabled, salesChannel.enabled) && Objects.equals(this.channelDisabled, salesChannel.channelDisabled) && Objects.equals(this.blacklisted, salesChannel.blacklisted) && Objects.equals(this.percentDiscount, salesChannel.percentDiscount) && Objects.equals(this.commission, salesChannel.commission) && Objects.equals(this.rateModifiers, salesChannel.rateModifiers) && Objects.equals(this.rateModifierBundles, salesChannel.rateModifierBundles);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.supplierIdentifier, this.supplierName, this.supplierAvailable, this.subType, this.ownerIdentifier, this.ownerName, this.enabled, this.channelDisabled, this.blacklisted, this.percentDiscount, this.commission, this.rateModifiers, this.rateModifierBundles});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SalesChannel {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    supplierName: ").append(this.toIndentedString(this.supplierName)).append("\n");
        sb.append("    supplierAvailable: ").append(this.toIndentedString(this.supplierAvailable)).append("\n");
        sb.append("    subType: ").append(this.toIndentedString((Object)this.subType)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    channelDisabled: ").append(this.toIndentedString(this.channelDisabled)).append("\n");
        sb.append("    blacklisted: ").append(this.toIndentedString(this.blacklisted)).append("\n");
        sb.append("    percentDiscount: ").append(this.toIndentedString(this.percentDiscount)).append("\n");
        sb.append("    commission: ").append(this.toIndentedString(this.commission)).append("\n");
        sb.append("    rateModifiers: ").append(this.toIndentedString(this.rateModifiers)).append("\n");
        sb.append("    rateModifierBundles: ").append(this.toIndentedString(this.rateModifierBundles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SubTypeEnum {
        DIRECT("DIRECT"),
        APPLICATION("APPLICATION"),
        HOTEL("HOTEL"),
        TRAVELIKO("TRAVELIKO"),
        CORPORATE("CORPORATE"),
        TRAVEL_AGENT("TRAVEL_AGENT"),
        INFLUENCER("INFLUENCER"),
        BLOGGER("BLOGGER"),
        DESTINATION("DESTINATION"),
        HOTEL_BOOKING_ENGINE("HOTEL_BOOKING_ENGINE");

        private String value;

        private SubTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubTypeEnum fromValue(String value) {
            for (SubTypeEnum b : SubTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

