/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="How user likes to have results displayed")
@JsonPropertyOrder(value={"maxDistance", "lifestyle", "starRating"})
public class SearchFilters {
    public static final String JSON_PROPERTY_MAX_DISTANCE = "maxDistance";
    private Double maxDistance;
    public static final String JSON_PROPERTY_LIFESTYLE = "lifestyle";
    private LifestyleEnum lifestyle;
    public static final String JSON_PROPERTY_STAR_RATING = "starRating";
    private Integer starRating;

    public SearchFilters maxDistance(Double maxDistance) {
        this.maxDistance = maxDistance;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="A user can query for hotels that are close to UserSession.location")
    @JsonProperty(value="maxDistance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getMaxDistance() {
        return this.maxDistance;
    }

    @JsonProperty(value="maxDistance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxDistance(Double maxDistance) {
        this.maxDistance = maxDistance;
    }

    public SearchFilters lifestyle(LifestyleEnum lifestyle) {
        this.lifestyle = lifestyle;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="LIFESTYLE_RELAX", value="A user can filter inventory on a lifestyle")
    @JsonProperty(value="lifestyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleEnum getLifestyle() {
        return this.lifestyle;
    }

    @JsonProperty(value="lifestyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyle(LifestyleEnum lifestyle) {
        this.lifestyle = lifestyle;
    }

    public SearchFilters starRating(Integer starRating) {
        this.starRating = starRating;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4", value="A user can filter on number of hotel stars")
    @JsonProperty(value="starRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getStarRating() {
        return this.starRating;
    }

    @JsonProperty(value="starRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStarRating(Integer starRating) {
        this.starRating = starRating;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchFilters searchFilters = (SearchFilters)o;
        return Objects.equals(this.maxDistance, searchFilters.maxDistance) && Objects.equals((Object)this.lifestyle, (Object)searchFilters.lifestyle) && Objects.equals(this.starRating, searchFilters.starRating);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxDistance, this.lifestyle, this.starRating});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchFilters {\n");
        sb.append("    maxDistance: ").append(this.toIndentedString(this.maxDistance)).append("\n");
        sb.append("    lifestyle: ").append(this.toIndentedString((Object)this.lifestyle)).append("\n");
        sb.append("    starRating: ").append(this.toIndentedString(this.starRating)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LifestyleEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleEnum fromValue(String value) {
            for (LifestyleEnum b : LifestyleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

