/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SupplierContractItemPolicy
 */
@JsonPropertyOrder({
  SupplierContractItemPolicy.JSON_PROPERTY_REFUNDABLE,
  SupplierContractItemPolicy.JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE,
  SupplierContractItemPolicy.JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE,
  SupplierContractItemPolicy.JSON_PROPERTY_NO_SHOW_CHARGE,
  SupplierContractItemPolicy.JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE,
  SupplierContractItemPolicy.JSON_PROPERTY_NON_REFUNDABLE_DEADLINE,
  SupplierContractItemPolicy.JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE,
  SupplierContractItemPolicy.JSON_PROPERTY_EXTERNAL_IDENTIFIER
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-31T13:45:50.218033+07:00[Asia/Bangkok]")
public class SupplierContractItemPolicy {
  public static final String JSON_PROPERTY_REFUNDABLE = "refundable";
  private Boolean refundable;

  /**
   * When the cancellation policy is refundable, this flag can be set and indicates there is more rules involved than just a no-questions-asked refundable.
   */
  public enum AdvanceCancellationFreeOfChargeEnum {
    UNTIL_EIGHTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL("UNTIL_EIGHTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL"),
    
    UNTIL_FOURTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL("UNTIL_FOURTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL"),
    
    ONE_DAY_BEFORE_ARRIVAL("ONE_DAY_BEFORE_ARRIVAL"),
    
    TWO_DAYS_BEFORE_ARRIVAL("TWO_DAYS_BEFORE_ARRIVAL"),
    
    THREE_DAYS_BEFORE_ARRIVAL("THREE_DAYS_BEFORE_ARRIVAL"),
    
    FIVE_DAYS_BEFORE_ARRIVAL("FIVE_DAYS_BEFORE_ARRIVAL"),
    
    SEVEN_DAYS_BEFORE_ARRIVAL("SEVEN_DAYS_BEFORE_ARRIVAL"),
    
    FOURTEEN_DAYS_BEFORE_ARRIVAL("FOURTEEN_DAYS_BEFORE_ARRIVAL"),
    
    TWENTYONE_DAYS_BEFORE_ARRIVAL("TWENTYONE_DAYS_BEFORE_ARRIVAL"),
    
    THIRTY_DAYS_BEFORE_ARRIVAL("THIRTY_DAYS_BEFORE_ARRIVAL"),
    
    FOURTY_TWO_DAYS_BEFORE_ARRIVAL("FOURTY_TWO_DAYS_BEFORE_ARRIVAL"),
    
    SIXTY_DAYS_BEFORE_ARRIVAL("SIXTY_DAYS_BEFORE_ARRIVAL");

    private String value;

    AdvanceCancellationFreeOfChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AdvanceCancellationFreeOfChargeEnum fromValue(String value) {
      for (AdvanceCancellationFreeOfChargeEnum b : AdvanceCancellationFreeOfChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE = "advanceCancellationFreeOfCharge";
  private AdvanceCancellationFreeOfChargeEnum advanceCancellationFreeOfCharge;

  /**
   * If advanceCancellationFreeOfCharge rules is not honored, this property explains what the guest will be charged.
   */
  public enum RefundableCancellationChargeEnum {
    FIRST_NIGHT("FIRST_NIGHT"),
    
    THIRTY_PERCENT("THIRTY_PERCENT"),
    
    FIFTY_PERCENT("FIFTY_PERCENT"),
    
    SIXTY_PERCENT("SIXTY_PERCENT"),
    
    SEVENTY_PERCENT("SEVENTY_PERCENT"),
    
    NINENTY_PERCENT("NINENTY_PERCENT"),
    
    ONE_HUNDRED_PERCENT("ONE_HUNDRED_PERCENT");

    private String value;

    RefundableCancellationChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RefundableCancellationChargeEnum fromValue(String value) {
      for (RefundableCancellationChargeEnum b : RefundableCancellationChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE = "refundableCancellationCharge";
  private RefundableCancellationChargeEnum refundableCancellationCharge;

  /**
   * In case the &#39;Refundable cancellation charge&#39; is set, a different no show charge can be applied.
   */
  public enum NoShowChargeEnum {
    SAME_AS_CANCELLATION_FEE("SAME_AS_CANCELLATION_FEE"),
    
    ONE_HUNDRED_PERCENT_OF_TOTAL_CHARGE("ONE_HUNDRED_PERCENT_OF_TOTAL_CHARGE");

    private String value;

    NoShowChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NoShowChargeEnum fromValue(String value) {
      for (NoShowChargeEnum b : NoShowChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NO_SHOW_CHARGE = "noShowCharge";
  private NoShowChargeEnum noShowCharge;

  /**
   * When the cancellation policy is non-refundable, this flag can be set and indicates there is more rules involved to calculate what the guest will owe in case of a cancellation.
   */
  public enum NonRefundableCancellationChargeEnum {
    FIRST_NIGHT("FIRST_NIGHT"),
    
    TEN_PERCENT("TEN_PERCENT"),
    
    THIRTY_PERCENT("THIRTY_PERCENT"),
    
    FIFTY_PERCENT("FIFTY_PERCENT"),
    
    SEVENTY_PERCENT("SEVENTY_PERCENT");

    private String value;

    NonRefundableCancellationChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NonRefundableCancellationChargeEnum fromValue(String value) {
      for (NonRefundableCancellationChargeEnum b : NonRefundableCancellationChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE = "nonRefundableCancellationCharge";
  private NonRefundableCancellationChargeEnum nonRefundableCancellationCharge;

  /**
   * The non-refundable charge might can have a deadline. If that deadline passes, the guest might be charged more.
   */
  public enum NonRefundableDeadlineEnum {
    ONE_DAY_BEFORE_ARRIVAL("ONE_DAY_BEFORE_ARRIVAL"),
    
    TWO_DAYS_BEFORE_ARRIVAL("TWO_DAYS_BEFORE_ARRIVAL"),
    
    THREE_DAYS_BEFORE_ARRIVAL("THREE_DAYS_BEFORE_ARRIVAL"),
    
    FIVE_DAYS_BEFORE_ARRIVAL("FIVE_DAYS_BEFORE_ARRIVAL"),
    
    SEVEN_DAYS_BEFORE_ARRIVAL("SEVEN_DAYS_BEFORE_ARRIVAL"),
    
    FOURTEEN_DAYS_BEFORE_ARRIVAL("FOURTEEN_DAYS_BEFORE_ARRIVAL"),
    
    TWENTYONE_DAYS_BEFORE_ARRIVAL("TWENTYONE_DAYS_BEFORE_ARRIVAL"),
    
    THIRTY_DAYS_BEFORE_ARRIVAL("THIRTY_DAYS_BEFORE_ARRIVAL"),
    
    FOURTY_TWO_DAYS_BEFORE_ARRIVAL("FOURTY_TWO_DAYS_BEFORE_ARRIVAL"),
    
    SIXTY_DAYS_BEFORE_ARRIVAL("SIXTY_DAYS_BEFORE_ARRIVAL");

    private String value;

    NonRefundableDeadlineEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NonRefundableDeadlineEnum fromValue(String value) {
      for (NonRefundableDeadlineEnum b : NonRefundableDeadlineEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NON_REFUNDABLE_DEADLINE = "nonRefundableDeadline";
  private NonRefundableDeadlineEnum nonRefundableDeadline;

  /**
   * If the guest does not honor the non-refundable deadline rule, this charge dictates what she owes after the deadline passes.
   */
  public enum NonRefundableAfterDeadlineCancellationChargeEnum {
    FIRST_NIGHT("FIRST_NIGHT"),
    
    TEN_PERCENT("TEN_PERCENT"),
    
    THIRTY_PERCENT("THIRTY_PERCENT"),
    
    FIFTY_PERCENT("FIFTY_PERCENT"),
    
    SEVENTY_PERCENT("SEVENTY_PERCENT"),
    
    ONE_HUNDRED_PERCENT("ONE_HUNDRED_PERCENT");

    private String value;

    NonRefundableAfterDeadlineCancellationChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NonRefundableAfterDeadlineCancellationChargeEnum fromValue(String value) {
      for (NonRefundableAfterDeadlineCancellationChargeEnum b : NonRefundableAfterDeadlineCancellationChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE = "nonRefundableAfterDeadlineCancellationCharge";
  private NonRefundableAfterDeadlineCancellationChargeEnum nonRefundableAfterDeadlineCancellationCharge;

  public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
  private String externalIdentifier;

  public SupplierContractItemPolicy() { 
  }

  public SupplierContractItemPolicy refundable(Boolean refundable) {
    
    this.refundable = refundable;
    return this;
  }

   /**
   * Whether this booking is refundable or not.
   * @return refundable
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Whether this booking is refundable or not.")
  @JsonProperty(JSON_PROPERTY_REFUNDABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getRefundable() {
    return refundable;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRefundable(Boolean refundable) {
    this.refundable = refundable;
  }


  public SupplierContractItemPolicy advanceCancellationFreeOfCharge(AdvanceCancellationFreeOfChargeEnum advanceCancellationFreeOfCharge) {
    
    this.advanceCancellationFreeOfCharge = advanceCancellationFreeOfCharge;
    return this;
  }

   /**
   * When the cancellation policy is refundable, this flag can be set and indicates there is more rules involved than just a no-questions-asked refundable.
   * @return advanceCancellationFreeOfCharge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "UNTIL_EIGHTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL", value = "When the cancellation policy is refundable, this flag can be set and indicates there is more rules involved than just a no-questions-asked refundable.")
  @JsonProperty(JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdvanceCancellationFreeOfChargeEnum getAdvanceCancellationFreeOfCharge() {
    return advanceCancellationFreeOfCharge;
  }


  @JsonProperty(JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdvanceCancellationFreeOfCharge(AdvanceCancellationFreeOfChargeEnum advanceCancellationFreeOfCharge) {
    this.advanceCancellationFreeOfCharge = advanceCancellationFreeOfCharge;
  }


  public SupplierContractItemPolicy refundableCancellationCharge(RefundableCancellationChargeEnum refundableCancellationCharge) {
    
    this.refundableCancellationCharge = refundableCancellationCharge;
    return this;
  }

   /**
   * If advanceCancellationFreeOfCharge rules is not honored, this property explains what the guest will be charged.
   * @return refundableCancellationCharge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "FIFTY_PERCENT", value = "If advanceCancellationFreeOfCharge rules is not honored, this property explains what the guest will be charged.")
  @JsonProperty(JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RefundableCancellationChargeEnum getRefundableCancellationCharge() {
    return refundableCancellationCharge;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundableCancellationCharge(RefundableCancellationChargeEnum refundableCancellationCharge) {
    this.refundableCancellationCharge = refundableCancellationCharge;
  }


  public SupplierContractItemPolicy noShowCharge(NoShowChargeEnum noShowCharge) {
    
    this.noShowCharge = noShowCharge;
    return this;
  }

   /**
   * In case the &#39;Refundable cancellation charge&#39; is set, a different no show charge can be applied.
   * @return noShowCharge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "SAME_AS_CANCELLATION_FEE", value = "In case the 'Refundable cancellation charge' is set, a different no show charge can be applied.")
  @JsonProperty(JSON_PROPERTY_NO_SHOW_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NoShowChargeEnum getNoShowCharge() {
    return noShowCharge;
  }


  @JsonProperty(JSON_PROPERTY_NO_SHOW_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNoShowCharge(NoShowChargeEnum noShowCharge) {
    this.noShowCharge = noShowCharge;
  }


  public SupplierContractItemPolicy nonRefundableCancellationCharge(NonRefundableCancellationChargeEnum nonRefundableCancellationCharge) {
    
    this.nonRefundableCancellationCharge = nonRefundableCancellationCharge;
    return this;
  }

   /**
   * When the cancellation policy is non-refundable, this flag can be set and indicates there is more rules involved to calculate what the guest will owe in case of a cancellation.
   * @return nonRefundableCancellationCharge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "SEVENTY_PERCENT", value = "When the cancellation policy is non-refundable, this flag can be set and indicates there is more rules involved to calculate what the guest will owe in case of a cancellation.")
  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NonRefundableCancellationChargeEnum getNonRefundableCancellationCharge() {
    return nonRefundableCancellationCharge;
  }


  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonRefundableCancellationCharge(NonRefundableCancellationChargeEnum nonRefundableCancellationCharge) {
    this.nonRefundableCancellationCharge = nonRefundableCancellationCharge;
  }


  public SupplierContractItemPolicy nonRefundableDeadline(NonRefundableDeadlineEnum nonRefundableDeadline) {
    
    this.nonRefundableDeadline = nonRefundableDeadline;
    return this;
  }

   /**
   * The non-refundable charge might can have a deadline. If that deadline passes, the guest might be charged more.
   * @return nonRefundableDeadline
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "SEVEN_DAYS_BEFORE_ARRIVAL", value = "The non-refundable charge might can have a deadline. If that deadline passes, the guest might be charged more.")
  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NonRefundableDeadlineEnum getNonRefundableDeadline() {
    return nonRefundableDeadline;
  }


  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonRefundableDeadline(NonRefundableDeadlineEnum nonRefundableDeadline) {
    this.nonRefundableDeadline = nonRefundableDeadline;
  }


  public SupplierContractItemPolicy nonRefundableAfterDeadlineCancellationCharge(NonRefundableAfterDeadlineCancellationChargeEnum nonRefundableAfterDeadlineCancellationCharge) {
    
    this.nonRefundableAfterDeadlineCancellationCharge = nonRefundableAfterDeadlineCancellationCharge;
    return this;
  }

   /**
   * If the guest does not honor the non-refundable deadline rule, this charge dictates what she owes after the deadline passes.
   * @return nonRefundableAfterDeadlineCancellationCharge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ONE_HUNDRED_PERCENT", value = "If the guest does not honor the non-refundable deadline rule, this charge dictates what she owes after the deadline passes.")
  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NonRefundableAfterDeadlineCancellationChargeEnum getNonRefundableAfterDeadlineCancellationCharge() {
    return nonRefundableAfterDeadlineCancellationCharge;
  }


  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonRefundableAfterDeadlineCancellationCharge(NonRefundableAfterDeadlineCancellationChargeEnum nonRefundableAfterDeadlineCancellationCharge) {
    this.nonRefundableAfterDeadlineCancellationCharge = nonRefundableAfterDeadlineCancellationCharge;
  }


  public SupplierContractItemPolicy externalIdentifier(String externalIdentifier) {
    
    this.externalIdentifier = externalIdentifier;
    return this;
  }

   /**
   * Optional reference externalIdentifier to remote policy.
   * @return externalIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "policy-1", value = "Optional reference externalIdentifier to remote policy.")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalIdentifier() {
    return externalIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalIdentifier(String externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SupplierContractItemPolicy supplierContractItemPolicy = (SupplierContractItemPolicy) o;
    return Objects.equals(this.refundable, supplierContractItemPolicy.refundable) &&
        Objects.equals(this.advanceCancellationFreeOfCharge, supplierContractItemPolicy.advanceCancellationFreeOfCharge) &&
        Objects.equals(this.refundableCancellationCharge, supplierContractItemPolicy.refundableCancellationCharge) &&
        Objects.equals(this.noShowCharge, supplierContractItemPolicy.noShowCharge) &&
        Objects.equals(this.nonRefundableCancellationCharge, supplierContractItemPolicy.nonRefundableCancellationCharge) &&
        Objects.equals(this.nonRefundableDeadline, supplierContractItemPolicy.nonRefundableDeadline) &&
        Objects.equals(this.nonRefundableAfterDeadlineCancellationCharge, supplierContractItemPolicy.nonRefundableAfterDeadlineCancellationCharge) &&
        Objects.equals(this.externalIdentifier, supplierContractItemPolicy.externalIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(refundable, advanceCancellationFreeOfCharge, refundableCancellationCharge, noShowCharge, nonRefundableCancellationCharge, nonRefundableDeadline, nonRefundableAfterDeadlineCancellationCharge, externalIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SupplierContractItemPolicy {\n");
    sb.append("    refundable: ").append(toIndentedString(refundable)).append("\n");
    sb.append("    advanceCancellationFreeOfCharge: ").append(toIndentedString(advanceCancellationFreeOfCharge)).append("\n");
    sb.append("    refundableCancellationCharge: ").append(toIndentedString(refundableCancellationCharge)).append("\n");
    sb.append("    noShowCharge: ").append(toIndentedString(noShowCharge)).append("\n");
    sb.append("    nonRefundableCancellationCharge: ").append(toIndentedString(nonRefundableCancellationCharge)).append("\n");
    sb.append("    nonRefundableDeadline: ").append(toIndentedString(nonRefundableDeadline)).append("\n");
    sb.append("    nonRefundableAfterDeadlineCancellationCharge: ").append(toIndentedString(nonRefundableAfterDeadlineCancellationCharge)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

