package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.Multimedia;
import travel.wink.sdk.affiliate.model.RemoveEntryResponse;
import travel.wink.sdk.affiliate.model.SellerInventoryItem;
import travel.wink.sdk.affiliate.model.SellerInventoryItemView;
import travel.wink.sdk.affiliate.model.ShowSellerUrl400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-03T12:24:54.734760+07:00[Asia/Bangkok]")
public class InventoryCardsApi {
    private ApiClient apiClient;

    public InventoryCardsApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryCardsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Card
     * Create a new inventory card
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param sellerInventoryItem The sellerInventoryItem parameter
     * @return SellerInventoryItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSellerInventoryItemRequestCreation(String companyIdentifier, SellerInventoryItem sellerInventoryItem) throws WebClientResponseException {
        Object postBody = sellerInventoryItem;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerInventoryItem' is set
        if (sellerInventoryItem == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerInventoryItem' when calling createSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryItemView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Card
     * Create a new inventory card
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param sellerInventoryItem The sellerInventoryItem parameter
     * @return SellerInventoryItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryItemView> createSellerInventoryItem(String companyIdentifier, SellerInventoryItem sellerInventoryItem) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemView>() {};
        return createSellerInventoryItemRequestCreation(companyIdentifier, sellerInventoryItem).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryItemView>> createSellerInventoryItemWithHttpInfo(String companyIdentifier, SellerInventoryItem sellerInventoryItem) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemView>() {};
        return createSellerInventoryItemRequestCreation(companyIdentifier, sellerInventoryItem).toEntity(localVarReturnType);
    }
    /**
     * Delete Card
     * Remove a unique inventory item
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Company identifier to delete item from
     * @param inventoryIdentifier Delete inventory with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSellerInventoryItemRequestCreation(String companyIdentifier, String inventoryIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryIdentifier' is set
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling removeSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/{inventoryIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Card
     * Remove a unique inventory item
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Company identifier to delete item from
     * @param inventoryIdentifier Delete inventory with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeSellerInventoryItem(String companyIdentifier, String inventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeSellerInventoryItemWithHttpInfo(String companyIdentifier, String inventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Card Media
     * Retrieve list of all media associated with this channel inventory identifier.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve items for
     * @param channelInventoryIdentifier Retrieve media for this channel inventory identifier.
     * @param accept The accept parameter
     * @return List&lt;Multimedia&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showInventoryMedia1RequestCreation(String companyIdentifier, String channelInventoryIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showInventoryMedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'channelInventoryIdentifier' is set
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showInventoryMedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Multimedia> localVarReturnType = new ParameterizedTypeReference<Multimedia>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/inventory/{channelInventoryIdentifier}/media/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Card Media
     * Retrieve list of all media associated with this channel inventory identifier.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve items for
     * @param channelInventoryIdentifier Retrieve media for this channel inventory identifier.
     * @param accept The accept parameter
     * @return List&lt;Multimedia&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Multimedia> showInventoryMedia1(String companyIdentifier, String channelInventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Multimedia> localVarReturnType = new ParameterizedTypeReference<Multimedia>() {};
        return showInventoryMedia1RequestCreation(companyIdentifier, channelInventoryIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<Multimedia>>> showInventoryMedia1WithHttpInfo(String companyIdentifier, String channelInventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Multimedia> localVarReturnType = new ParameterizedTypeReference<Multimedia>() {};
        return showInventoryMedia1RequestCreation(companyIdentifier, channelInventoryIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Card
     * Retrieve a single inventory card.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve item for
     * @param inventoryIdentifier Retrieve inventory with this identifier.
     * @param accept The accept parameter
     * @return SellerInventoryItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerInventoryItemRequestCreation(String companyIdentifier, String inventoryIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryIdentifier' is set
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling showSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryItemView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/{inventoryIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Card
     * Retrieve a single inventory card.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve item for
     * @param inventoryIdentifier Retrieve inventory with this identifier.
     * @param accept The accept parameter
     * @return SellerInventoryItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryItemView> showSellerInventoryItem(String companyIdentifier, String inventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemView>() {};
        return showSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryItemView>> showSellerInventoryItemWithHttpInfo(String companyIdentifier, String inventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemView>() {};
        return showSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Inventory Cards
     * Retrieve a list of all inventory cards for company.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve items for
     * @param accept The accept parameter
     * @return List&lt;SellerInventoryItemView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerInventoryItemsForCompanyRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryItemsForCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryItemView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Cards
     * Retrieve a list of all inventory cards for company.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve items for
     * @param accept The accept parameter
     * @return List&lt;SellerInventoryItemView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SellerInventoryItemView> showSellerInventoryItemsForCompany(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemView>() {};
        return showSellerInventoryItemsForCompanyRequestCreation(companyIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellerInventoryItemView>>> showSellerInventoryItemsForCompanyWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemView>() {};
        return showSellerInventoryItemsForCompanyRequestCreation(companyIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Card
     * Update an existing card
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to update item for
     * @param inventoryIdentifier Update inventory with this identifier.
     * @param sellerInventoryItem The sellerInventoryItem parameter
     * @return SellerInventoryItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSellerInventoryItemRequestCreation(String companyIdentifier, String inventoryIdentifier, SellerInventoryItem sellerInventoryItem) throws WebClientResponseException {
        Object postBody = sellerInventoryItem;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryIdentifier' is set
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling updateSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerInventoryItem' is set
        if (sellerInventoryItem == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerInventoryItem' when calling updateSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryItemView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/{inventoryIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Card
     * Update an existing card
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to update item for
     * @param inventoryIdentifier Update inventory with this identifier.
     * @param sellerInventoryItem The sellerInventoryItem parameter
     * @return SellerInventoryItemView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryItemView> updateSellerInventoryItem(String companyIdentifier, String inventoryIdentifier, SellerInventoryItem sellerInventoryItem) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemView>() {};
        return updateSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, sellerInventoryItem).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryItemView>> updateSellerInventoryItemWithHttpInfo(String companyIdentifier, String inventoryIdentifier, SellerInventoryItem sellerInventoryItem) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemView> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemView>() {};
        return updateSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, sellerInventoryItem).toEntity(localVarReturnType);
    }
}
