package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.Invoice;
import travel.wink.sdk.affiliate.model.InvoiceCollection;
import travel.wink.sdk.affiliate.model.InvoiceLineItemCollection;
import travel.wink.sdk.affiliate.model.ShowSellerUrl400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-03T12:24:54.734760+07:00[Asia/Bangkok]")
public class InvoiceApi {
    private ApiClient apiClient;

    public InvoiceApi() {
        this(new ApiClient());
    }

    @Autowired
    public InvoiceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Invoices
     * Retrieve all invoices for a specific company
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param accept The accept parameter
     * @return InvoiceCollection
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showInvoicesForCompanyCustomerRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showInvoicesForCompanyCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/marketplace/customer/invoice/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Invoices
     * Retrieve all invoices for a specific company
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param accept The accept parameter
     * @return InvoiceCollection
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InvoiceCollection> showInvoicesForCompanyCustomer(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return showInvoicesForCompanyCustomerRequestCreation(companyIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceCollection>> showInvoicesForCompanyCustomerWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceCollection>() {};
        return showInvoicesForCompanyCustomerRequestCreation(companyIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Upcoming Invoice
     * Retrieve upcoming invoice. A company might want to know how many API calls have been done for the current month.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param accept The accept parameter
     * @return Invoice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showUpcomingInvoiceForCompanyCustomerRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUpcomingInvoiceForCompanyCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Invoice> localVarReturnType = new ParameterizedTypeReference<Invoice>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/marketplace/customer/invoice/upcoming", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Upcoming Invoice
     * Retrieve upcoming invoice. A company might want to know how many API calls have been done for the current month.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param accept The accept parameter
     * @return Invoice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Invoice> showUpcomingInvoiceForCompanyCustomer(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Invoice> localVarReturnType = new ParameterizedTypeReference<Invoice>() {};
        return showUpcomingInvoiceForCompanyCustomerRequestCreation(companyIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Invoice>> showUpcomingInvoiceForCompanyCustomerWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Invoice> localVarReturnType = new ParameterizedTypeReference<Invoice>() {};
        return showUpcomingInvoiceForCompanyCustomerRequestCreation(companyIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Upcoming Invoices
     * Retrieve all upcoming invoice for a company.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param accept The accept parameter
     * @return InvoiceLineItemCollection
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showUpcomingInvoiceLineItemsForCompanyCustomerRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUpcomingInvoiceLineItemsForCompanyCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<InvoiceLineItemCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceLineItemCollection>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/marketplace/customer/invoice/upcoming/items", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Upcoming Invoices
     * Retrieve all upcoming invoice for a company.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param accept The accept parameter
     * @return InvoiceLineItemCollection
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InvoiceLineItemCollection> showUpcomingInvoiceLineItemsForCompanyCustomer(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceLineItemCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceLineItemCollection>() {};
        return showUpcomingInvoiceLineItemsForCompanyCustomerRequestCreation(companyIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceLineItemCollection>> showUpcomingInvoiceLineItemsForCompanyCustomerWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceLineItemCollection> localVarReturnType = new ParameterizedTypeReference<InvoiceLineItemCollection>() {};
        return showUpcomingInvoiceLineItemsForCompanyCustomerRequestCreation(companyIdentifier, accept).toEntity(localVarReturnType);
    }
}
