package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.CampaignInventory;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.ShowSellerUrl400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-05T13:53:52.403806+07:00[Asia/Bangkok]")
public class CampaignApi {
    private ApiClient apiClient;

    public CampaignApi() {
        this(new ApiClient());
    }

    @Autowired
    public CampaignApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show campaign inventory
     * Show array of campaign inventory
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Show campaigns for this company
     * @param accept The accept parameter
     * @return List&lt;CampaignInventory&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCampaignInventoryRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCampaignInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<CampaignInventory> localVarReturnType = new ParameterizedTypeReference<CampaignInventory>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/campaign/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show campaign inventory
     * Show array of campaign inventory
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Show campaigns for this company
     * @param accept The accept parameter
     * @return List&lt;CampaignInventory&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<CampaignInventory> showCampaignInventory(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CampaignInventory> localVarReturnType = new ParameterizedTypeReference<CampaignInventory>() {};
        return showCampaignInventoryRequestCreation(companyIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<CampaignInventory>>> showCampaignInventoryWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CampaignInventory> localVarReturnType = new ParameterizedTypeReference<CampaignInventory>() {};
        return showCampaignInventoryRequestCreation(companyIdentifier, accept).toEntityList(localVarReturnType);
    }
}
