/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import travel.wink.sdk.affiliate.model.PriceTier;
import travel.wink.sdk.affiliate.model.Recurring;
import travel.wink.sdk.affiliate.model.TransformQuantity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Price
 */
@JsonPropertyOrder({
  Price.JSON_PROPERTY_ACTIVE,
  Price.JSON_PROPERTY_BILLING_SCHEME,
  Price.JSON_PROPERTY_CREATED,
  Price.JSON_PROPERTY_CURRENCY,
  Price.JSON_PROPERTY_DELETED,
  Price.JSON_PROPERTY_ID,
  Price.JSON_PROPERTY_LIVEMODE,
  Price.JSON_PROPERTY_LOOKUP_KEY,
  Price.JSON_PROPERTY_METADATA,
  Price.JSON_PROPERTY_NICKNAME,
  Price.JSON_PROPERTY_OBJECT,
  Price.JSON_PROPERTY_RECURRING,
  Price.JSON_PROPERTY_TIERS,
  Price.JSON_PROPERTY_TIERS_MODE,
  Price.JSON_PROPERTY_TRANSFORM_QUANTITY,
  Price.JSON_PROPERTY_TYPE,
  Price.JSON_PROPERTY_UNIT_AMOUNT,
  Price.JSON_PROPERTY_UNIT_AMOUNT_DECIMAL,
  Price.JSON_PROPERTY_SORT,
  Price.JSON_PROPERTY_PRICE_TYPE,
  Price.JSON_PROPERTY_METERED
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-05T13:53:52.403806+07:00[Asia/Bangkok]")
public class Price {
  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_BILLING_SCHEME = "billingScheme";
  private String billingScheme;

  public static final String JSON_PROPERTY_CREATED = "created";
  private Long created;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_DELETED = "deleted";
  private Boolean deleted;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVEMODE = "livemode";
  private Boolean livemode;

  public static final String JSON_PROPERTY_LOOKUP_KEY = "lookupKey";
  private String lookupKey;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = null;

  public static final String JSON_PROPERTY_NICKNAME = "nickname";
  private String nickname;

  public static final String JSON_PROPERTY_OBJECT = "object";
  private String _object;

  public static final String JSON_PROPERTY_RECURRING = "recurring";
  private Recurring recurring;

  public static final String JSON_PROPERTY_TIERS = "tiers";
  private List<PriceTier> tiers = null;

  public static final String JSON_PROPERTY_TIERS_MODE = "tiersMode";
  private String tiersMode;

  public static final String JSON_PROPERTY_TRANSFORM_QUANTITY = "transformQuantity";
  private TransformQuantity transformQuantity;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_UNIT_AMOUNT = "unitAmount";
  private Long unitAmount;

  public static final String JSON_PROPERTY_UNIT_AMOUNT_DECIMAL = "unitAmountDecimal";
  private BigDecimal unitAmountDecimal;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  /**
   * Gets or Sets priceType
   */
  public enum PriceTypeEnum {
    STARTUP("STARTUP"),
    
    PRO("PRO"),
    
    AGENT("AGENT"),
    
    OTA("OTA");

    private String value;

    PriceTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PriceTypeEnum fromValue(String value) {
      for (PriceTypeEnum b : PriceTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_TYPE = "priceType";
  private PriceTypeEnum priceType;

  public static final String JSON_PROPERTY_METERED = "metered";
  private Boolean metered;

  public Price() { 
  }

  public Price active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Get active
   * @return active
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public Price billingScheme(String billingScheme) {
    
    this.billingScheme = billingScheme;
    return this;
  }

   /**
   * Get billingScheme
   * @return billingScheme
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BILLING_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBillingScheme() {
    return billingScheme;
  }


  @JsonProperty(JSON_PROPERTY_BILLING_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingScheme(String billingScheme) {
    this.billingScheme = billingScheme;
  }


  public Price created(Long created) {
    
    this.created = created;
    return this;
  }

   /**
   * Get created
   * @return created
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreated(Long created) {
    this.created = created;
  }


  public Price currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public Price deleted(Boolean deleted) {
    
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeleted() {
    return deleted;
  }


  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }


  public Price id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Price livemode(Boolean livemode) {
    
    this.livemode = livemode;
    return this;
  }

   /**
   * Get livemode
   * @return livemode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLivemode() {
    return livemode;
  }


  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLivemode(Boolean livemode) {
    this.livemode = livemode;
  }


  public Price lookupKey(String lookupKey) {
    
    this.lookupKey = lookupKey;
    return this;
  }

   /**
   * Get lookupKey
   * @return lookupKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LOOKUP_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLookupKey() {
    return lookupKey;
  }


  @JsonProperty(JSON_PROPERTY_LOOKUP_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLookupKey(String lookupKey) {
    this.lookupKey = lookupKey;
  }


  public Price metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public Price putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public Price nickname(String nickname) {
    
    this.nickname = nickname;
    return this;
  }

   /**
   * Get nickname
   * @return nickname
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NICKNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNickname() {
    return nickname;
  }


  @JsonProperty(JSON_PROPERTY_NICKNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNickname(String nickname) {
    this.nickname = nickname;
  }


  public Price _object(String _object) {
    
    this._object = _object;
    return this;
  }

   /**
   * Get _object
   * @return _object
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObject() {
    return _object;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObject(String _object) {
    this._object = _object;
  }


  public Price recurring(Recurring recurring) {
    
    this.recurring = recurring;
    return this;
  }

   /**
   * Get recurring
   * @return recurring
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RECURRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Recurring getRecurring() {
    return recurring;
  }


  @JsonProperty(JSON_PROPERTY_RECURRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurring(Recurring recurring) {
    this.recurring = recurring;
  }


  public Price tiers(List<PriceTier> tiers) {
    
    this.tiers = tiers;
    return this;
  }

  public Price addTiersItem(PriceTier tiersItem) {
    if (this.tiers == null) {
      this.tiers = new ArrayList<>();
    }
    this.tiers.add(tiersItem);
    return this;
  }

   /**
   * Get tiers
   * @return tiers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PriceTier> getTiers() {
    return tiers;
  }


  @JsonProperty(JSON_PROPERTY_TIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTiers(List<PriceTier> tiers) {
    this.tiers = tiers;
  }


  public Price tiersMode(String tiersMode) {
    
    this.tiersMode = tiersMode;
    return this;
  }

   /**
   * Get tiersMode
   * @return tiersMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TIERS_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTiersMode() {
    return tiersMode;
  }


  @JsonProperty(JSON_PROPERTY_TIERS_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTiersMode(String tiersMode) {
    this.tiersMode = tiersMode;
  }


  public Price transformQuantity(TransformQuantity transformQuantity) {
    
    this.transformQuantity = transformQuantity;
    return this;
  }

   /**
   * Get transformQuantity
   * @return transformQuantity
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TRANSFORM_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TransformQuantity getTransformQuantity() {
    return transformQuantity;
  }


  @JsonProperty(JSON_PROPERTY_TRANSFORM_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransformQuantity(TransformQuantity transformQuantity) {
    this.transformQuantity = transformQuantity;
  }


  public Price type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }


  public Price unitAmount(Long unitAmount) {
    
    this.unitAmount = unitAmount;
    return this;
  }

   /**
   * Get unitAmount
   * @return unitAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UNIT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getUnitAmount() {
    return unitAmount;
  }


  @JsonProperty(JSON_PROPERTY_UNIT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnitAmount(Long unitAmount) {
    this.unitAmount = unitAmount;
  }


  public Price unitAmountDecimal(BigDecimal unitAmountDecimal) {
    
    this.unitAmountDecimal = unitAmountDecimal;
    return this;
  }

   /**
   * Get unitAmountDecimal
   * @return unitAmountDecimal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UNIT_AMOUNT_DECIMAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUnitAmountDecimal() {
    return unitAmountDecimal;
  }


  @JsonProperty(JSON_PROPERTY_UNIT_AMOUNT_DECIMAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
    this.unitAmountDecimal = unitAmountDecimal;
  }


  public Price sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Get sort
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public Price priceType(PriceTypeEnum priceType) {
    
    this.priceType = priceType;
    return this;
  }

   /**
   * Get priceType
   * @return priceType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRICE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PriceTypeEnum getPriceType() {
    return priceType;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceType(PriceTypeEnum priceType) {
    this.priceType = priceType;
  }


  public Price metered(Boolean metered) {
    
    this.metered = metered;
    return this;
  }

   /**
   * Get metered
   * @return metered
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_METERED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMetered() {
    return metered;
  }


  @JsonProperty(JSON_PROPERTY_METERED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetered(Boolean metered) {
    this.metered = metered;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Price price = (Price) o;
    return Objects.equals(this.active, price.active) &&
        Objects.equals(this.billingScheme, price.billingScheme) &&
        Objects.equals(this.created, price.created) &&
        Objects.equals(this.currency, price.currency) &&
        Objects.equals(this.deleted, price.deleted) &&
        Objects.equals(this.id, price.id) &&
        Objects.equals(this.livemode, price.livemode) &&
        Objects.equals(this.lookupKey, price.lookupKey) &&
        Objects.equals(this.metadata, price.metadata) &&
        Objects.equals(this.nickname, price.nickname) &&
        Objects.equals(this._object, price._object) &&
        Objects.equals(this.recurring, price.recurring) &&
        Objects.equals(this.tiers, price.tiers) &&
        Objects.equals(this.tiersMode, price.tiersMode) &&
        Objects.equals(this.transformQuantity, price.transformQuantity) &&
        Objects.equals(this.type, price.type) &&
        Objects.equals(this.unitAmount, price.unitAmount) &&
        Objects.equals(this.unitAmountDecimal, price.unitAmountDecimal) &&
        Objects.equals(this.sort, price.sort) &&
        Objects.equals(this.priceType, price.priceType) &&
        Objects.equals(this.metered, price.metered);
  }

  @Override
  public int hashCode() {
    return Objects.hash(active, billingScheme, created, currency, deleted, id, livemode, lookupKey, metadata, nickname, _object, recurring, tiers, tiersMode, transformQuantity, type, unitAmount, unitAmountDecimal, sort, priceType, metered);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Price {\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    billingScheme: ").append(toIndentedString(billingScheme)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    livemode: ").append(toIndentedString(livemode)).append("\n");
    sb.append("    lookupKey: ").append(toIndentedString(lookupKey)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    nickname: ").append(toIndentedString(nickname)).append("\n");
    sb.append("    _object: ").append(toIndentedString(_object)).append("\n");
    sb.append("    recurring: ").append(toIndentedString(recurring)).append("\n");
    sb.append("    tiers: ").append(toIndentedString(tiers)).append("\n");
    sb.append("    tiersMode: ").append(toIndentedString(tiersMode)).append("\n");
    sb.append("    transformQuantity: ").append(toIndentedString(transformQuantity)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    unitAmount: ").append(toIndentedString(unitAmount)).append("\n");
    sb.append("    unitAmountDecimal: ").append(toIndentedString(unitAmountDecimal)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    priceType: ").append(toIndentedString(priceType)).append("\n");
    sb.append("    metered: ").append(toIndentedString(metered)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

