/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.affiliate.model.ConfigurableGeoJsonCircle;
import travel.wink.sdk.affiliate.model.ConfigurableGeoJsonPoint;
import travel.wink.sdk.affiliate.model.ConfigurableGeoJsonPolygon;
import travel.wink.sdk.affiliate.model.ConfigurableGeoJsonRectangle;
import travel.wink.sdk.affiliate.model.HotelOnMapLocation;

@ApiModel(description="Advanced map configuration")
@JsonPropertyOrder(value={"identifier", "ownerIdentifier", "name", "typeIdentifier", "type", "center", "draggable", "zoomable", "initialZoomLevel", "mapStyle", "mapMarkerColor", "mapHeight", "displayType", "circles", "rectangles", "markers", "polygons"})
public class AdvancedMapConfiguration {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    private String ownerIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
    private String typeIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_CENTER = "center";
    private HotelOnMapLocation center;
    public static final String JSON_PROPERTY_DRAGGABLE = "draggable";
    private Boolean draggable = true;
    public static final String JSON_PROPERTY_ZOOMABLE = "zoomable";
    private Boolean zoomable = true;
    public static final String JSON_PROPERTY_INITIAL_ZOOM_LEVEL = "initialZoomLevel";
    private Integer initialZoomLevel;
    public static final String JSON_PROPERTY_MAP_STYLE = "mapStyle";
    private MapStyleEnum mapStyle;
    public static final String JSON_PROPERTY_MAP_MARKER_COLOR = "mapMarkerColor";
    private MapMarkerColorEnum mapMarkerColor;
    public static final String JSON_PROPERTY_MAP_HEIGHT = "mapHeight";
    private Integer mapHeight;
    public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
    private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;
    public static final String JSON_PROPERTY_CIRCLES = "circles";
    private List<ConfigurableGeoJsonCircle> circles = null;
    public static final String JSON_PROPERTY_RECTANGLES = "rectangles";
    private List<ConfigurableGeoJsonRectangle> rectangles = null;
    public static final String JSON_PROPERTY_MARKERS = "markers";
    private List<ConfigurableGeoJsonPoint> markers = null;
    public static final String JSON_PROPERTY_POLYGONS = "polygons";
    private List<ConfigurableGeoJsonPolygon> polygons = null;

    public AdvancedMapConfiguration identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="map-1", value="Unique map identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public AdvancedMapConfiguration ownerIdentifier(String ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="company-1", value="Map owner identifier")
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerIdentifier(String ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public AdvancedMapConfiguration name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="My lovely map", required=true, value="Name of map")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public AdvancedMapConfiguration typeIdentifier(String typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="list-1", required=true, value="Inventory type identifier. Either a single channel inventory identifier, a list identifier or a dynamic search identifier.")
    @JsonProperty(value="typeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTypeIdentifier() {
        return this.typeIdentifier;
    }

    @JsonProperty(value="typeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTypeIdentifier(String typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
    }

    public AdvancedMapConfiguration type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="LIST", required=true, value="Type of inventory")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AdvancedMapConfiguration center(HotelOnMapLocation center) {
        this.center = center;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="center")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public HotelOnMapLocation getCenter() {
        return this.center;
    }

    @JsonProperty(value="center")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCenter(HotelOnMapLocation center) {
        this.center = center;
    }

    public AdvancedMapConfiguration draggable(Boolean draggable) {
        this.draggable = draggable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="User can move around / pan the map")
    @JsonProperty(value="draggable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getDraggable() {
        return this.draggable;
    }

    @JsonProperty(value="draggable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDraggable(Boolean draggable) {
        this.draggable = draggable;
    }

    public AdvancedMapConfiguration zoomable(Boolean zoomable) {
        this.zoomable = zoomable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="User can zoom in/out of the map")
    @JsonProperty(value="zoomable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getZoomable() {
        return this.zoomable;
    }

    @JsonProperty(value="zoomable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setZoomable(Boolean zoomable) {
        this.zoomable = zoomable;
    }

    public AdvancedMapConfiguration initialZoomLevel(Integer initialZoomLevel) {
        this.initialZoomLevel = initialZoomLevel;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @Max(value=21L)
    @ApiModelProperty(example="15", required=true, value="Valid Google maps zoom level")
    @JsonProperty(value="initialZoomLevel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) @Max(value=21L) Integer getInitialZoomLevel() {
        return this.initialZoomLevel;
    }

    @JsonProperty(value="initialZoomLevel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInitialZoomLevel(Integer initialZoomLevel) {
        this.initialZoomLevel = initialZoomLevel;
    }

    public AdvancedMapConfiguration mapStyle(MapStyleEnum mapStyle) {
        this.mapStyle = mapStyle;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="normal", required=true, value="Map style")
    @JsonProperty(value="mapStyle")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MapStyleEnum getMapStyle() {
        return this.mapStyle;
    }

    @JsonProperty(value="mapStyle")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMapStyle(MapStyleEnum mapStyle) {
        this.mapStyle = mapStyle;
    }

    public AdvancedMapConfiguration mapMarkerColor(MapMarkerColorEnum mapMarkerColor) {
        this.mapMarkerColor = mapMarkerColor;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="cc2138", required=true, value="Map marker color")
    @JsonProperty(value="mapMarkerColor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MapMarkerColorEnum getMapMarkerColor() {
        return this.mapMarkerColor;
    }

    @JsonProperty(value="mapMarkerColor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMapMarkerColor(MapMarkerColorEnum mapMarkerColor) {
        this.mapMarkerColor = mapMarkerColor;
    }

    public AdvancedMapConfiguration mapHeight(Integer mapHeight) {
        this.mapHeight = mapHeight;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="500", required=true, value="Map height in pixels")
    @JsonProperty(value="mapHeight")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getMapHeight() {
        return this.mapHeight;
    }

    @JsonProperty(value="mapHeight")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMapHeight(Integer mapHeight) {
        this.mapHeight = mapHeight;
    }

    public AdvancedMapConfiguration displayType(DisplayTypeEnum displayType) {
        this.displayType = displayType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="NATIVE", required=true, value="Indicate which initial values to display first on the front-facing card")
    @JsonProperty(value="displayType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DisplayTypeEnum getDisplayType() {
        return this.displayType;
    }

    @JsonProperty(value="displayType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayType(DisplayTypeEnum displayType) {
        this.displayType = displayType;
    }

    public AdvancedMapConfiguration circles(List<ConfigurableGeoJsonCircle> circles) {
        this.circles = circles;
        return this;
    }

    public AdvancedMapConfiguration addCirclesItem(ConfigurableGeoJsonCircle circlesItem) {
        if (this.circles == null) {
            this.circles = new ArrayList<ConfigurableGeoJsonCircle>();
        }
        this.circles.add(circlesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="circles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ConfigurableGeoJsonCircle> getCircles() {
        return this.circles;
    }

    @JsonProperty(value="circles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCircles(List<ConfigurableGeoJsonCircle> circles) {
        this.circles = circles;
    }

    public AdvancedMapConfiguration rectangles(List<ConfigurableGeoJsonRectangle> rectangles) {
        this.rectangles = rectangles;
        return this;
    }

    public AdvancedMapConfiguration addRectanglesItem(ConfigurableGeoJsonRectangle rectanglesItem) {
        if (this.rectangles == null) {
            this.rectangles = new ArrayList<ConfigurableGeoJsonRectangle>();
        }
        this.rectangles.add(rectanglesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="rectangles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ConfigurableGeoJsonRectangle> getRectangles() {
        return this.rectangles;
    }

    @JsonProperty(value="rectangles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRectangles(List<ConfigurableGeoJsonRectangle> rectangles) {
        this.rectangles = rectangles;
    }

    public AdvancedMapConfiguration markers(List<ConfigurableGeoJsonPoint> markers) {
        this.markers = markers;
        return this;
    }

    public AdvancedMapConfiguration addMarkersItem(ConfigurableGeoJsonPoint markersItem) {
        if (this.markers == null) {
            this.markers = new ArrayList<ConfigurableGeoJsonPoint>();
        }
        this.markers.add(markersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="markers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ConfigurableGeoJsonPoint> getMarkers() {
        return this.markers;
    }

    @JsonProperty(value="markers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMarkers(List<ConfigurableGeoJsonPoint> markers) {
        this.markers = markers;
    }

    public AdvancedMapConfiguration polygons(List<ConfigurableGeoJsonPolygon> polygons) {
        this.polygons = polygons;
        return this;
    }

    public AdvancedMapConfiguration addPolygonsItem(ConfigurableGeoJsonPolygon polygonsItem) {
        if (this.polygons == null) {
            this.polygons = new ArrayList<ConfigurableGeoJsonPolygon>();
        }
        this.polygons.add(polygonsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="polygons")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ConfigurableGeoJsonPolygon> getPolygons() {
        return this.polygons;
    }

    @JsonProperty(value="polygons")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolygons(List<ConfigurableGeoJsonPolygon> polygons) {
        this.polygons = polygons;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdvancedMapConfiguration advancedMapConfiguration = (AdvancedMapConfiguration)o;
        return Objects.equals(this.identifier, advancedMapConfiguration.identifier) && Objects.equals(this.ownerIdentifier, advancedMapConfiguration.ownerIdentifier) && Objects.equals(this.name, advancedMapConfiguration.name) && Objects.equals(this.typeIdentifier, advancedMapConfiguration.typeIdentifier) && Objects.equals((Object)this.type, (Object)advancedMapConfiguration.type) && Objects.equals(this.center, advancedMapConfiguration.center) && Objects.equals(this.draggable, advancedMapConfiguration.draggable) && Objects.equals(this.zoomable, advancedMapConfiguration.zoomable) && Objects.equals(this.initialZoomLevel, advancedMapConfiguration.initialZoomLevel) && Objects.equals((Object)this.mapStyle, (Object)advancedMapConfiguration.mapStyle) && Objects.equals((Object)this.mapMarkerColor, (Object)advancedMapConfiguration.mapMarkerColor) && Objects.equals(this.mapHeight, advancedMapConfiguration.mapHeight) && Objects.equals((Object)this.displayType, (Object)advancedMapConfiguration.displayType) && Objects.equals(this.circles, advancedMapConfiguration.circles) && Objects.equals(this.rectangles, advancedMapConfiguration.rectangles) && Objects.equals(this.markers, advancedMapConfiguration.markers) && Objects.equals(this.polygons, advancedMapConfiguration.polygons);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.ownerIdentifier, this.name, this.typeIdentifier, this.type, this.center, this.draggable, this.zoomable, this.initialZoomLevel, this.mapStyle, this.mapMarkerColor, this.mapHeight, this.displayType, this.circles, this.rectangles, this.markers, this.polygons});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdvancedMapConfiguration {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    typeIdentifier: ").append(this.toIndentedString(this.typeIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    center: ").append(this.toIndentedString(this.center)).append("\n");
        sb.append("    draggable: ").append(this.toIndentedString(this.draggable)).append("\n");
        sb.append("    zoomable: ").append(this.toIndentedString(this.zoomable)).append("\n");
        sb.append("    initialZoomLevel: ").append(this.toIndentedString(this.initialZoomLevel)).append("\n");
        sb.append("    mapStyle: ").append(this.toIndentedString((Object)this.mapStyle)).append("\n");
        sb.append("    mapMarkerColor: ").append(this.toIndentedString((Object)this.mapMarkerColor)).append("\n");
        sb.append("    mapHeight: ").append(this.toIndentedString(this.mapHeight)).append("\n");
        sb.append("    displayType: ").append(this.toIndentedString((Object)this.displayType)).append("\n");
        sb.append("    circles: ").append(this.toIndentedString(this.circles)).append("\n");
        sb.append("    rectangles: ").append(this.toIndentedString(this.rectangles)).append("\n");
        sb.append("    markers: ").append(this.toIndentedString(this.markers)).append("\n");
        sb.append("    polygons: ").append(this.toIndentedString(this.polygons)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DisplayTypeEnum {
        NATIVE("NATIVE"),
        HOTEL("HOTEL"),
        ROOM("ROOM");

        private String value;

        private DisplayTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DisplayTypeEnum fromValue(String value) {
            for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        SINGLE("SINGLE"),
        LIST("LIST"),
        SEARCH("SEARCH");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MapStyleEnum {
        NORMAL("normal"),
        CLEAN("clean"),
        BLUISH("bluish");

        private String value;

        private MapStyleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MapStyleEnum fromValue(String value) {
            for (MapStyleEnum b : MapStyleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MapMarkerColorEnum {
        CC2138("cc2138");

        private String value;

        private MapMarkerColorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MapMarkerColorEnum fromValue(String value) {
            for (MapMarkerColorEnum b : MapMarkerColorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

