/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.affiliate.model.HotelOnMapLocation;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Inventory map marker
 */
@ApiModel(description = "Inventory map marker")
@JsonPropertyOrder({
  InventoryMapMarker.JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER,
  InventoryMapMarker.JSON_PROPERTY_POINT,
  InventoryMapMarker.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  InventoryMapMarker.JSON_PROPERTY_SUPPLIER_NAME,
  InventoryMapMarker.JSON_PROPERTY_SUPPLIER_URL_NAME,
  InventoryMapMarker.JSON_PROPERTY_INVENTORY_IDENTIFIER,
  InventoryMapMarker.JSON_PROPERTY_INVENTORY_TYPE,
  InventoryMapMarker.JSON_PROPERTY_INVENTORY_NAME
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-16T12:46:59.376568+07:00[Asia/Bangkok]")
public class InventoryMapMarker {
  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
  private String channelInventoryIdentifier;

  public static final String JSON_PROPERTY_POINT = "point";
  private HotelOnMapLocation point;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private String supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  private String supplierName;

  public static final String JSON_PROPERTY_SUPPLIER_URL_NAME = "supplierUrlName";
  private String supplierUrlName;

  public static final String JSON_PROPERTY_INVENTORY_IDENTIFIER = "inventoryIdentifier";
  private String inventoryIdentifier;

  /**
   * Type of inventory
   */
  public enum InventoryTypeEnum {
    GUEST_ROOM("GUEST_ROOM"),
    
    PACKAGE("PACKAGE"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE"),
    
    ACTIVITY("ACTIVITY");

    private String value;

    InventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryTypeEnum fromValue(String value) {
      for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
  private InventoryTypeEnum inventoryType;

  public static final String JSON_PROPERTY_INVENTORY_NAME = "inventoryName";
  private String inventoryName;

  public InventoryMapMarker() { 
  }

  public InventoryMapMarker channelInventoryIdentifier(String channelInventoryIdentifier) {
    
    this.channelInventoryIdentifier = channelInventoryIdentifier;
    return this;
  }

   /**
   * Identifier of the list, channel inventory or search
   * @return channelInventoryIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "channel-inventory-1", value = "Identifier of the list, channel inventory or search")
  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChannelInventoryIdentifier() {
    return channelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelInventoryIdentifier(String channelInventoryIdentifier) {
    this.channelInventoryIdentifier = channelInventoryIdentifier;
  }


  public InventoryMapMarker point(HotelOnMapLocation point) {
    
    this.point = point;
    return this;
  }

   /**
   * Get point
   * @return point
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_POINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HotelOnMapLocation getPoint() {
    return point;
  }


  @JsonProperty(JSON_PROPERTY_POINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPoint(HotelOnMapLocation point) {
    this.point = point;
  }


  public InventoryMapMarker supplierIdentifier(String supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Hotel identifier
   * @return supplierIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "hotel-1", value = "Hotel identifier")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierIdentifier(String supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public InventoryMapMarker supplierName(String supplierName) {
    
    this.supplierName = supplierName;
    return this;
  }

   /**
   * Hotel name
   * @return supplierName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Sheraton", value = "Hotel name")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierName() {
    return supplierName;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }


  public InventoryMapMarker supplierUrlName(String supplierUrlName) {
    
    this.supplierUrlName = supplierUrlName;
    return this;
  }

   /**
   * Hotel url name
   * @return supplierUrlName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "sheraton-hotel-bangkok", value = "Hotel url name")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierUrlName() {
    return supplierUrlName;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierUrlName(String supplierUrlName) {
    this.supplierUrlName = supplierUrlName;
  }


  public InventoryMapMarker inventoryIdentifier(String inventoryIdentifier) {
    
    this.inventoryIdentifier = inventoryIdentifier;
    return this;
  }

   /**
   * Actual inventory identifier
   * @return inventoryIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "guest-room-1", value = "Actual inventory identifier")
  @JsonProperty(JSON_PROPERTY_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInventoryIdentifier() {
    return inventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInventoryIdentifier(String inventoryIdentifier) {
    this.inventoryIdentifier = inventoryIdentifier;
  }


  public InventoryMapMarker inventoryType(InventoryTypeEnum inventoryType) {
    
    this.inventoryType = inventoryType;
    return this;
  }

   /**
   * Type of inventory
   * @return inventoryType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "GUEST_ROOM", value = "Type of inventory")
  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InventoryTypeEnum getInventoryType() {
    return inventoryType;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInventoryType(InventoryTypeEnum inventoryType) {
    this.inventoryType = inventoryType;
  }


  public InventoryMapMarker inventoryName(String inventoryName) {
    
    this.inventoryName = inventoryName;
    return this;
  }

   /**
   * Name of inventory
   * @return inventoryName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Supreme King", value = "Name of inventory")
  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInventoryName() {
    return inventoryName;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInventoryName(String inventoryName) {
    this.inventoryName = inventoryName;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InventoryMapMarker inventoryMapMarker = (InventoryMapMarker) o;
    return Objects.equals(this.channelInventoryIdentifier, inventoryMapMarker.channelInventoryIdentifier) &&
        Objects.equals(this.point, inventoryMapMarker.point) &&
        Objects.equals(this.supplierIdentifier, inventoryMapMarker.supplierIdentifier) &&
        Objects.equals(this.supplierName, inventoryMapMarker.supplierName) &&
        Objects.equals(this.supplierUrlName, inventoryMapMarker.supplierUrlName) &&
        Objects.equals(this.inventoryIdentifier, inventoryMapMarker.inventoryIdentifier) &&
        Objects.equals(this.inventoryType, inventoryMapMarker.inventoryType) &&
        Objects.equals(this.inventoryName, inventoryMapMarker.inventoryName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(channelInventoryIdentifier, point, supplierIdentifier, supplierName, supplierUrlName, inventoryIdentifier, inventoryType, inventoryName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InventoryMapMarker {\n");
    sb.append("    channelInventoryIdentifier: ").append(toIndentedString(channelInventoryIdentifier)).append("\n");
    sb.append("    point: ").append(toIndentedString(point)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    supplierUrlName: ").append(toIndentedString(supplierUrlName)).append("\n");
    sb.append("    inventoryIdentifier: ").append(toIndentedString(inventoryIdentifier)).append("\n");
    sb.append("    inventoryType: ").append(toIndentedString(inventoryType)).append("\n");
    sb.append("    inventoryName: ").append(toIndentedString(inventoryName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

