/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.affiliate.model.ChartCategoryAxis;
import travel.wink.sdk.affiliate.model.ChartLegend;
import travel.wink.sdk.affiliate.model.ChartSeries;
import travel.wink.sdk.affiliate.model.ChartSeriesDefaults;
import travel.wink.sdk.affiliate.model.ChartTitle;
import travel.wink.sdk.affiliate.model.ChartTooltip;
import travel.wink.sdk.affiliate.model.ChartValueAxis;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * LineChart
 */
@JsonPropertyOrder({
  LineChart.JSON_PROPERTY_IDENTIFIER,
  LineChart.JSON_PROPERTY_TITLE,
  LineChart.JSON_PROPERTY_LEGEND,
  LineChart.JSON_PROPERTY_SERIES_DEFAULTS,
  LineChart.JSON_PROPERTY_SERIES,
  LineChart.JSON_PROPERTY_VALUE_AXIS,
  LineChart.JSON_PROPERTY_CATEGORY_AXIS,
  LineChart.JSON_PROPERTY_TOOLTIP,
  LineChart.JSON_PROPERTY_RENDER_AS,
  LineChart.JSON_PROPERTY_TRANSITIONS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-16T12:46:59.376568+07:00[Asia/Bangkok]")
public class LineChart {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_TITLE = "title";
  private ChartTitle title;

  public static final String JSON_PROPERTY_LEGEND = "legend";
  private ChartLegend legend;

  public static final String JSON_PROPERTY_SERIES_DEFAULTS = "seriesDefaults";
  private ChartSeriesDefaults seriesDefaults;

  public static final String JSON_PROPERTY_SERIES = "series";
  private List<ChartSeries> series = null;

  public static final String JSON_PROPERTY_VALUE_AXIS = "valueAxis";
  private ChartValueAxis valueAxis;

  public static final String JSON_PROPERTY_CATEGORY_AXIS = "categoryAxis";
  private ChartCategoryAxis categoryAxis;

  public static final String JSON_PROPERTY_TOOLTIP = "tooltip";
  private ChartTooltip tooltip;

  public static final String JSON_PROPERTY_RENDER_AS = "renderAs";
  private String renderAs;

  public static final String JSON_PROPERTY_TRANSITIONS = "transitions";
  private Boolean transitions;

  public LineChart() { 
  }

  public LineChart identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique line chart identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "line-chart-1", value = "Unique line chart identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public LineChart title(ChartTitle title) {
    
    this.title = title;
    return this;
  }

   /**
   * Get title
   * @return title
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartTitle getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(ChartTitle title) {
    this.title = title;
  }


  public LineChart legend(ChartLegend legend) {
    
    this.legend = legend;
    return this;
  }

   /**
   * Get legend
   * @return legend
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LEGEND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartLegend getLegend() {
    return legend;
  }


  @JsonProperty(JSON_PROPERTY_LEGEND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegend(ChartLegend legend) {
    this.legend = legend;
  }


  public LineChart seriesDefaults(ChartSeriesDefaults seriesDefaults) {
    
    this.seriesDefaults = seriesDefaults;
    return this;
  }

   /**
   * Get seriesDefaults
   * @return seriesDefaults
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SERIES_DEFAULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartSeriesDefaults getSeriesDefaults() {
    return seriesDefaults;
  }


  @JsonProperty(JSON_PROPERTY_SERIES_DEFAULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSeriesDefaults(ChartSeriesDefaults seriesDefaults) {
    this.seriesDefaults = seriesDefaults;
  }


  public LineChart series(List<ChartSeries> series) {
    
    this.series = series;
    return this;
  }

  public LineChart addSeriesItem(ChartSeries seriesItem) {
    if (this.series == null) {
      this.series = new ArrayList<>();
    }
    this.series.add(seriesItem);
    return this;
  }

   /**
   * The configuration of the chart series. The series type is determined by the value of the type field. If a type value is missing, the chart renders the type that is specified in &#x60;seriesDefaults&#x60;. Some options accept functions as arguments. These arguments are evaluated for each point which is supplied as a parameter. If no value is returned, the chart uses the &#x60;theme&#x60; or &#x60;seriesDefaults&#x60; values.
   * @return series
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The configuration of the chart series. The series type is determined by the value of the type field. If a type value is missing, the chart renders the type that is specified in `seriesDefaults`. Some options accept functions as arguments. These arguments are evaluated for each point which is supplied as a parameter. If no value is returned, the chart uses the `theme` or `seriesDefaults` values.")
  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ChartSeries> getSeries() {
    return series;
  }


  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSeries(List<ChartSeries> series) {
    this.series = series;
  }


  public LineChart valueAxis(ChartValueAxis valueAxis) {
    
    this.valueAxis = valueAxis;
    return this;
  }

   /**
   * Get valueAxis
   * @return valueAxis
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VALUE_AXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartValueAxis getValueAxis() {
    return valueAxis;
  }


  @JsonProperty(JSON_PROPERTY_VALUE_AXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValueAxis(ChartValueAxis valueAxis) {
    this.valueAxis = valueAxis;
  }


  public LineChart categoryAxis(ChartCategoryAxis categoryAxis) {
    
    this.categoryAxis = categoryAxis;
    return this;
  }

   /**
   * Get categoryAxis
   * @return categoryAxis
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CATEGORY_AXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartCategoryAxis getCategoryAxis() {
    return categoryAxis;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY_AXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategoryAxis(ChartCategoryAxis categoryAxis) {
    this.categoryAxis = categoryAxis;
  }


  public LineChart tooltip(ChartTooltip tooltip) {
    
    this.tooltip = tooltip;
    return this;
  }

   /**
   * Get tooltip
   * @return tooltip
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOOLTIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartTooltip getTooltip() {
    return tooltip;
  }


  @JsonProperty(JSON_PROPERTY_TOOLTIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTooltip(ChartTooltip tooltip) {
    this.tooltip = tooltip;
  }


  public LineChart renderAs(String renderAs) {
    
    this.renderAs = renderAs;
    return this;
  }

   /**
   * Sets the preferred rendering engine. If not supported by the browser, the Chart switches to the first available mode.  The supported values are:  - svg (If available, renders the component as an inline .svg file.)- canvas (If available, renders the component as a canvas element.)
   * @return renderAs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Sets the preferred rendering engine. If not supported by the browser, the Chart switches to the first available mode.  The supported values are:  - svg (If available, renders the component as an inline .svg file.)- canvas (If available, renders the component as a canvas element.)")
  @JsonProperty(JSON_PROPERTY_RENDER_AS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRenderAs() {
    return renderAs;
  }


  @JsonProperty(JSON_PROPERTY_RENDER_AS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRenderAs(String renderAs) {
    this.renderAs = renderAs;
  }


  public LineChart transitions(Boolean transitions) {
    
    this.transitions = transitions;
    return this;
  }

   /**
   * If set to &#x60;true&#x60;, the Chart plays animations when it displays the series. By default, animations are enabled.
   * @return transitions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If set to `true`, the Chart plays animations when it displays the series. By default, animations are enabled.")
  @JsonProperty(JSON_PROPERTY_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTransitions() {
    return transitions;
  }


  @JsonProperty(JSON_PROPERTY_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransitions(Boolean transitions) {
    this.transitions = transitions;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LineChart lineChart = (LineChart) o;
    return Objects.equals(this.identifier, lineChart.identifier) &&
        Objects.equals(this.title, lineChart.title) &&
        Objects.equals(this.legend, lineChart.legend) &&
        Objects.equals(this.seriesDefaults, lineChart.seriesDefaults) &&
        Objects.equals(this.series, lineChart.series) &&
        Objects.equals(this.valueAxis, lineChart.valueAxis) &&
        Objects.equals(this.categoryAxis, lineChart.categoryAxis) &&
        Objects.equals(this.tooltip, lineChart.tooltip) &&
        Objects.equals(this.renderAs, lineChart.renderAs) &&
        Objects.equals(this.transitions, lineChart.transitions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, title, legend, seriesDefaults, series, valueAxis, categoryAxis, tooltip, renderAs, transitions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LineChart {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    legend: ").append(toIndentedString(legend)).append("\n");
    sb.append("    seriesDefaults: ").append(toIndentedString(seriesDefaults)).append("\n");
    sb.append("    series: ").append(toIndentedString(series)).append("\n");
    sb.append("    valueAxis: ").append(toIndentedString(valueAxis)).append("\n");
    sb.append("    categoryAxis: ").append(toIndentedString(categoryAxis)).append("\n");
    sb.append("    tooltip: ").append(toIndentedString(tooltip)).append("\n");
    sb.append("    renderAs: ").append(toIndentedString(renderAs)).append("\n");
    sb.append("    transitions: ").append(toIndentedString(transitions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

