/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.affiliate.model.ChartRequest;

@JsonPropertyOrder(value={"identifier", "ownerIdentifier", "name", "sort", "request"})
public class ChartRequestWrapper {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    private String ownerIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort = -1;
    public static final String JSON_PROPERTY_REQUEST = "request";
    private ChartRequest request;

    public ChartRequestWrapper() {
    }

    @JsonCreator
    public ChartRequestWrapper(@JsonProperty(value="ownerIdentifier") String ownerIdentifier) {
        this();
        this.ownerIdentifier = ownerIdentifier;
    }

    public ChartRequestWrapper identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="chart-request-1", value="Unique record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Nullable
    @ApiModelProperty(example="owner-1", value="Owner of this chart")
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    public ChartRequestWrapper name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="My First Chart", required=true, value="Chart name as named by creator")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public ChartRequestWrapper sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Sort a list of charts by this sort value.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public ChartRequestWrapper request(ChartRequest request) {
        this.request = request;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ChartRequest getRequest() {
        return this.request;
    }

    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRequest(ChartRequest request) {
        this.request = request;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChartRequestWrapper chartRequestWrapper = (ChartRequestWrapper)o;
        return Objects.equals(this.identifier, chartRequestWrapper.identifier) && Objects.equals(this.ownerIdentifier, chartRequestWrapper.ownerIdentifier) && Objects.equals(this.name, chartRequestWrapper.name) && Objects.equals(this.sort, chartRequestWrapper.sort) && Objects.equals(this.request, chartRequestWrapper.request);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.ownerIdentifier, this.name, this.sort, this.request);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChartRequestWrapper {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

