/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.affiliate.model.EngineConfigurationTheme;
import travel.wink.sdk.affiliate.model.Multimedia;
import travel.wink.sdk.affiliate.model.RoomConfiguration;

@JsonPropertyOrder(value={"identifier", "name", "appendToPageTitle", "ownerIdentifier", "ownerName", "subType", "primary", "googleTagManagerKey", "wcGoogleTagManagerKey", "googleMapsAPIKey", "wcGoogleMapsAPIKey", "tawkToKey", "wcTawkToKey", "defaultCurrency", "defaultLanguage", "logos", "hostedBookingEngineUrl", "selfHosted", "themeColors", "numberOfAdvanceDays", "numberOfStayDays", "startDate", "endDate", "roomConfigurations", "useDays", "promotionalCodes", "sendBookingNotificationEmailsToProperty", "sendBookingNotificationEmailsToBooker", "wcBookClickAction"})
public class EngineConfiguration {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_APPEND_TO_PAGE_TITLE = "appendToPageTitle";
    private String appendToPageTitle;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    private String ownerIdentifier;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    private String ownerName;
    public static final String JSON_PROPERTY_SUB_TYPE = "subType";
    private SubTypeEnum subType;
    public static final String JSON_PROPERTY_PRIMARY = "primary";
    private Boolean primary = false;
    public static final String JSON_PROPERTY_GOOGLE_TAG_MANAGER_KEY = "googleTagManagerKey";
    private String googleTagManagerKey;
    public static final String JSON_PROPERTY_WC_GOOGLE_TAG_MANAGER_KEY = "wcGoogleTagManagerKey";
    private String wcGoogleTagManagerKey;
    public static final String JSON_PROPERTY_GOOGLE_MAPS_A_P_I_KEY = "googleMapsAPIKey";
    private String googleMapsAPIKey;
    public static final String JSON_PROPERTY_WC_GOOGLE_MAPS_A_P_I_KEY = "wcGoogleMapsAPIKey";
    private String wcGoogleMapsAPIKey;
    public static final String JSON_PROPERTY_TAWK_TO_KEY = "tawkToKey";
    private String tawkToKey;
    public static final String JSON_PROPERTY_WC_TAWK_TO_KEY = "wcTawkToKey";
    private String wcTawkToKey;
    public static final String JSON_PROPERTY_DEFAULT_CURRENCY = "defaultCurrency";
    private String defaultCurrency = "USD";
    public static final String JSON_PROPERTY_DEFAULT_LANGUAGE = "defaultLanguage";
    private String defaultLanguage = "en";
    public static final String JSON_PROPERTY_LOGOS = "logos";
    private List<Multimedia> logos = null;
    public static final String JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL = "hostedBookingEngineUrl";
    private String hostedBookingEngineUrl = "https://ota.wink.travel";
    public static final String JSON_PROPERTY_SELF_HOSTED = "selfHosted";
    private Boolean selfHosted = false;
    public static final String JSON_PROPERTY_THEME_COLORS = "themeColors";
    private EngineConfigurationTheme themeColors;
    public static final String JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS = "numberOfAdvanceDays";
    private Integer numberOfAdvanceDays;
    public static final String JSON_PROPERTY_NUMBER_OF_STAY_DAYS = "numberOfStayDays";
    private Integer numberOfStayDays;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_ROOM_CONFIGURATIONS = "roomConfigurations";
    private List<RoomConfiguration> roomConfigurations = null;
    public static final String JSON_PROPERTY_USE_DAYS = "useDays";
    private Boolean useDays;
    public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
    private List<String> promotionalCodes = null;
    public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY = "sendBookingNotificationEmailsToProperty";
    private Boolean sendBookingNotificationEmailsToProperty = true;
    public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER = "sendBookingNotificationEmailsToBooker";
    private Boolean sendBookingNotificationEmailsToBooker = true;
    public static final String JSON_PROPERTY_WC_BOOK_CLICK_ACTION = "wcBookClickAction";
    private WcBookClickActionEnum wcBookClickAction;

    public EngineConfiguration() {
    }

    @JsonCreator
    public EngineConfiguration(@JsonProperty(value="ownerName") String ownerName) {
        this();
        this.ownerName = ownerName;
    }

    public EngineConfiguration identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="engine-configuration-1", value="Unique engine configuration identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public EngineConfiguration name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Engine Configuration 1", required=true, value="Engine configuration name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public EngineConfiguration appendToPageTitle(String appendToPageTitle) {
        this.appendToPageTitle = appendToPageTitle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to append text to the existing booking engine page title.")
    @JsonProperty(value="appendToPageTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppendToPageTitle() {
        return this.appendToPageTitle;
    }

    @JsonProperty(value="appendToPageTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppendToPageTitle(String appendToPageTitle) {
        this.appendToPageTitle = appendToPageTitle;
    }

    public EngineConfiguration ownerIdentifier(String ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="company-1", value="Engine configuration record creator identifier")
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerIdentifier(String ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    @Nullable
    @ApiModelProperty(example="Travel Tech 1", value="Name of company owner.")
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwnerName() {
        return this.ownerName;
    }

    public EngineConfiguration subType(SubTypeEnum subType) {
        this.subType = subType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="APPLICATION", value="Sales channel sub-type.")
    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubTypeEnum getSubType() {
        return this.subType;
    }

    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubType(SubTypeEnum subType) {
        this.subType = subType;
    }

    public EngineConfiguration primary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Indicates whether this configuration is primary. A primary configuration cannot be removed.")
    @JsonProperty(value="primary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPrimary() {
        return this.primary;
    }

    @JsonProperty(value="primary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    public EngineConfiguration googleTagManagerKey(String googleTagManagerKey) {
        this.googleTagManagerKey = googleTagManagerKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If you want to track analytics with Google Analytics and GTM for your self-hosted booking engine, you need to import our [GTM profile](https://www.dropbox.com/s/o6rwluclvsgydma/gtm-template-2020-2.json?dl=0) into your GTM container and link it with your Google Analytics account. [More about that here](https://bearchoke.atlassian.net/wiki/spaces/TC/pages/2941648897/Linking+your+Google+Tag+Manager+account) ")
    @JsonProperty(value="googleTagManagerKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGoogleTagManagerKey() {
        return this.googleTagManagerKey;
    }

    @JsonProperty(value="googleTagManagerKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGoogleTagManagerKey(String googleTagManagerKey) {
        this.googleTagManagerKey = googleTagManagerKey;
    }

    public EngineConfiguration wcGoogleTagManagerKey(String wcGoogleTagManagerKey) {
        this.wcGoogleTagManagerKey = wcGoogleTagManagerKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If you want to track analytics with Google Analytics and GTM for the Web Components you've embedded, you need to import our [GTM profile](https://www.dropbox.com/s/o6rwluclvsgydma/gtm-template-2020-2.json?dl=0) into your GTM container and link it with your Google Analytics account. [More about that here](https://bearchoke.atlassian.net/wiki/spaces/TC/pages/2941648897/Linking+your+Google+Tag+Manager+account) ")
    @JsonProperty(value="wcGoogleTagManagerKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWcGoogleTagManagerKey() {
        return this.wcGoogleTagManagerKey;
    }

    @JsonProperty(value="wcGoogleTagManagerKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWcGoogleTagManagerKey(String wcGoogleTagManagerKey) {
        this.wcGoogleTagManagerKey = wcGoogleTagManagerKey;
    }

    public EngineConfiguration googleMapsAPIKey(String googleMapsAPIKey) {
        this.googleMapsAPIKey = googleMapsAPIKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="google-maps-api-123", value="If you want your users to see Google Maps in your hosted booking engine, go to [Google Maps](https://console.developers.google.com/projectselector2/apis/credentials?supportedpurview=project) and create an API key for your site.")
    @JsonProperty(value="googleMapsAPIKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGoogleMapsAPIKey() {
        return this.googleMapsAPIKey;
    }

    @JsonProperty(value="googleMapsAPIKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGoogleMapsAPIKey(String googleMapsAPIKey) {
        this.googleMapsAPIKey = googleMapsAPIKey;
    }

    public EngineConfiguration wcGoogleMapsAPIKey(String wcGoogleMapsAPIKey) {
        this.wcGoogleMapsAPIKey = wcGoogleMapsAPIKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="google-maps-api-321", value="If you want your users to see Google Maps in any of our Web Components, go to [Google Maps](https://console.developers.google.com/projectselector2/apis/credentials?supportedpurview=project) and create an API key for your site.")
    @JsonProperty(value="wcGoogleMapsAPIKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWcGoogleMapsAPIKey() {
        return this.wcGoogleMapsAPIKey;
    }

    @JsonProperty(value="wcGoogleMapsAPIKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWcGoogleMapsAPIKey(String wcGoogleMapsAPIKey) {
        this.wcGoogleMapsAPIKey = wcGoogleMapsAPIKey;
    }

    public EngineConfiguration tawkToKey(String tawkToKey) {
        this.tawkToKey = tawkToKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="tawk-to-1", value="If you want your users to be able to chat with you on your hosted booking engine, set yourself up with a [tawk.to account](https://dashboard.tawk.to/signup) and add your API key here.")
    @JsonProperty(value="tawkToKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTawkToKey() {
        return this.tawkToKey;
    }

    @JsonProperty(value="tawkToKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTawkToKey(String tawkToKey) {
        this.tawkToKey = tawkToKey;
    }

    public EngineConfiguration wcTawkToKey(String wcTawkToKey) {
        this.wcTawkToKey = wcTawkToKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="tawk-to-2", value="If you want your users to be able to chat with in any of our Web Components, set yourself up with a [tawk.to account](https://dashboard.tawk.to/signup) and add your API key here.")
    @JsonProperty(value="wcTawkToKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWcTawkToKey() {
        return this.wcTawkToKey;
    }

    @JsonProperty(value="wcTawkToKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWcTawkToKey(String wcTawkToKey) {
        this.wcTawkToKey = wcTawkToKey;
    }

    public EngineConfiguration defaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Control which currency your users see prices in initially.")
    @JsonProperty(value="defaultCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @JsonProperty(value="defaultCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    public EngineConfiguration defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="en", value="Control which language your users see text in initially.")
    @JsonProperty(value="defaultLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @JsonProperty(value="defaultLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public EngineConfiguration logos(List<Multimedia> logos) {
        this.logos = logos;
        return this;
    }

    public EngineConfiguration addLogosItem(Multimedia logosItem) {
        if (this.logos == null) {
            this.logos = new ArrayList<Multimedia>();
        }
        this.logos.add(logosItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Customize booking confirmation emails by adding a custom logo to your configuration.")
    @JsonProperty(value="logos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Multimedia> getLogos() {
        return this.logos;
    }

    @JsonProperty(value="logos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogos(List<Multimedia> logos) {
        this.logos = logos;
    }

    public EngineConfiguration hostedBookingEngineUrl(String hostedBookingEngineUrl) {
        this.hostedBookingEngineUrl = hostedBookingEngineUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://my.customtravelsite.com/book", value="If you are self-hosting our booking engine, let us know where it is hosted. Note: This url needs to be secured with SSL.")
    @JsonProperty(value="hostedBookingEngineUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHostedBookingEngineUrl() {
        return this.hostedBookingEngineUrl;
    }

    @JsonProperty(value="hostedBookingEngineUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHostedBookingEngineUrl(String hostedBookingEngineUrl) {
        this.hostedBookingEngineUrl = hostedBookingEngineUrl;
    }

    public EngineConfiguration selfHosted(Boolean selfHosted) {
        this.selfHosted = selfHosted;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate you are self-hosting our booking engine and not using our default booking engine url.")
    @JsonProperty(value="selfHosted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSelfHosted() {
        return this.selfHosted;
    }

    @JsonProperty(value="selfHosted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelfHosted(Boolean selfHosted) {
        this.selfHosted = selfHosted;
    }

    public EngineConfiguration themeColors(EngineConfigurationTheme themeColors) {
        this.themeColors = themeColors;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="themeColors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EngineConfigurationTheme getThemeColors() {
        return this.themeColors;
    }

    @JsonProperty(value="themeColors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThemeColors(EngineConfigurationTheme themeColors) {
        this.themeColors = themeColors;
    }

    public EngineConfiguration numberOfAdvanceDays(Integer numberOfAdvanceDays) {
        this.numberOfAdvanceDays = numberOfAdvanceDays;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long and how many days in advance (this field), of today's date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don't use either of these options, the itinerary will default to today's date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave `startDate` and `endDate` empty.")
    @JsonProperty(value="numberOfAdvanceDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfAdvanceDays() {
        return this.numberOfAdvanceDays;
    }

    @JsonProperty(value="numberOfAdvanceDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfAdvanceDays(Integer numberOfAdvanceDays) {
        this.numberOfAdvanceDays = numberOfAdvanceDays;
    }

    public EngineConfiguration numberOfStayDays(Integer numberOfStayDays) {
        this.numberOfStayDays = numberOfStayDays;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long (this field) and how many days in advance, of today's date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don't use either of these options, the itinerary will default to today's date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave `startDate` and `endDate` empty.")
    @JsonProperty(value="numberOfStayDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfStayDays() {
        return this.numberOfStayDays;
    }

    @JsonProperty(value="numberOfStayDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfStayDays(Integer numberOfStayDays) {
        this.numberOfStayDays = numberOfStayDays;
    }

    public EngineConfiguration startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Fri Dec 24 07:00:00 ICT 2021", value="Set a fixed itinerary start date. ONLY populate this field if you want to fix the itinerary date. Also, leave `numberOfAdvanceDays` and `numberOfStayDays` empty.")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public EngineConfiguration endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Fri Dec 31 07:00:00 ICT 2021", value="Set a fixed itinerary end date ONLY populate this field if you want to fix the itinerary date. Also, leave `numberOfAdvanceDays` and `numberOfStayDays` empty.")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public EngineConfiguration roomConfigurations(List<RoomConfiguration> roomConfigurations) {
        this.roomConfigurations = roomConfigurations;
        return this;
    }

    public EngineConfiguration addRoomConfigurationsItem(RoomConfiguration roomConfigurationsItem) {
        if (this.roomConfigurations == null) {
            this.roomConfigurations = new ArrayList<RoomConfiguration>();
        }
        this.roomConfigurations.add(roomConfigurationsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Control how many adults / children will be staying and how many rooms. Defaults to: One room, two adults.")
    @JsonProperty(value="roomConfigurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RoomConfiguration> getRoomConfigurations() {
        return this.roomConfigurations;
    }

    @JsonProperty(value="roomConfigurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomConfigurations(List<RoomConfiguration> roomConfigurations) {
        this.roomConfigurations = roomConfigurations;
    }

    public EngineConfiguration useDays(Boolean useDays) {
        this.useDays = useDays;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="if true, we use numberOfAdvanceDays / numberOfStayDays properties - false, we use startDate / endDate")
    @JsonProperty(value="useDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUseDays() {
        return this.useDays;
    }

    @JsonProperty(value="useDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseDays(Boolean useDays) {
        this.useDays = useDays;
    }

    public EngineConfiguration promotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
        return this;
    }

    public EngineConfiguration addPromotionalCodesItem(String promotionalCodesItem) {
        if (this.promotionalCodes == null) {
            this.promotionalCodes = new ArrayList<String>();
        }
        this.promotionalCodes.add(promotionalCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"promo-1\"]", value="If you've received special promotional codes from suppliers to give to your audience, you can choose to bake these code directly into the price by entering them here.")
    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPromotionalCodes() {
        return this.promotionalCodes;
    }

    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
    }

    public EngineConfiguration sendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
        this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="An integrator can choose to disable outgoing emails to properties because they want to do that themselves.")
    @JsonProperty(value="sendBookingNotificationEmailsToProperty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendBookingNotificationEmailsToProperty() {
        return this.sendBookingNotificationEmailsToProperty;
    }

    @JsonProperty(value="sendBookingNotificationEmailsToProperty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
        this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
    }

    public EngineConfiguration sendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
        this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="An integrator can choose to disable outgoing emails to users because they want to do that themselves.")
    @JsonProperty(value="sendBookingNotificationEmailsToBooker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendBookingNotificationEmailsToBooker() {
        return this.sendBookingNotificationEmailsToBooker;
    }

    @JsonProperty(value="sendBookingNotificationEmailsToBooker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
        this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
    }

    public EngineConfiguration wcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
        this.wcBookClickAction = wcBookClickAction;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="IBE_MODAL", value="Action to complete once a user clicks on the CTA button on inventory.")
    @JsonProperty(value="wcBookClickAction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WcBookClickActionEnum getWcBookClickAction() {
        return this.wcBookClickAction;
    }

    @JsonProperty(value="wcBookClickAction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
        this.wcBookClickAction = wcBookClickAction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EngineConfiguration engineConfiguration = (EngineConfiguration)o;
        return Objects.equals(this.identifier, engineConfiguration.identifier) && Objects.equals(this.name, engineConfiguration.name) && Objects.equals(this.appendToPageTitle, engineConfiguration.appendToPageTitle) && Objects.equals(this.ownerIdentifier, engineConfiguration.ownerIdentifier) && Objects.equals(this.ownerName, engineConfiguration.ownerName) && Objects.equals((Object)this.subType, (Object)engineConfiguration.subType) && Objects.equals(this.primary, engineConfiguration.primary) && Objects.equals(this.googleTagManagerKey, engineConfiguration.googleTagManagerKey) && Objects.equals(this.wcGoogleTagManagerKey, engineConfiguration.wcGoogleTagManagerKey) && Objects.equals(this.googleMapsAPIKey, engineConfiguration.googleMapsAPIKey) && Objects.equals(this.wcGoogleMapsAPIKey, engineConfiguration.wcGoogleMapsAPIKey) && Objects.equals(this.tawkToKey, engineConfiguration.tawkToKey) && Objects.equals(this.wcTawkToKey, engineConfiguration.wcTawkToKey) && Objects.equals(this.defaultCurrency, engineConfiguration.defaultCurrency) && Objects.equals(this.defaultLanguage, engineConfiguration.defaultLanguage) && Objects.equals(this.logos, engineConfiguration.logos) && Objects.equals(this.hostedBookingEngineUrl, engineConfiguration.hostedBookingEngineUrl) && Objects.equals(this.selfHosted, engineConfiguration.selfHosted) && Objects.equals(this.themeColors, engineConfiguration.themeColors) && Objects.equals(this.numberOfAdvanceDays, engineConfiguration.numberOfAdvanceDays) && Objects.equals(this.numberOfStayDays, engineConfiguration.numberOfStayDays) && Objects.equals(this.startDate, engineConfiguration.startDate) && Objects.equals(this.endDate, engineConfiguration.endDate) && Objects.equals(this.roomConfigurations, engineConfiguration.roomConfigurations) && Objects.equals(this.useDays, engineConfiguration.useDays) && Objects.equals(this.promotionalCodes, engineConfiguration.promotionalCodes) && Objects.equals(this.sendBookingNotificationEmailsToProperty, engineConfiguration.sendBookingNotificationEmailsToProperty) && Objects.equals(this.sendBookingNotificationEmailsToBooker, engineConfiguration.sendBookingNotificationEmailsToBooker) && Objects.equals((Object)this.wcBookClickAction, (Object)engineConfiguration.wcBookClickAction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.name, this.appendToPageTitle, this.ownerIdentifier, this.ownerName, this.subType, this.primary, this.googleTagManagerKey, this.wcGoogleTagManagerKey, this.googleMapsAPIKey, this.wcGoogleMapsAPIKey, this.tawkToKey, this.wcTawkToKey, this.defaultCurrency, this.defaultLanguage, this.logos, this.hostedBookingEngineUrl, this.selfHosted, this.themeColors, this.numberOfAdvanceDays, this.numberOfStayDays, this.startDate, this.endDate, this.roomConfigurations, this.useDays, this.promotionalCodes, this.sendBookingNotificationEmailsToProperty, this.sendBookingNotificationEmailsToBooker, this.wcBookClickAction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EngineConfiguration {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    appendToPageTitle: ").append(this.toIndentedString(this.appendToPageTitle)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    subType: ").append(this.toIndentedString((Object)this.subType)).append("\n");
        sb.append("    primary: ").append(this.toIndentedString(this.primary)).append("\n");
        sb.append("    googleTagManagerKey: ").append(this.toIndentedString(this.googleTagManagerKey)).append("\n");
        sb.append("    wcGoogleTagManagerKey: ").append(this.toIndentedString(this.wcGoogleTagManagerKey)).append("\n");
        sb.append("    googleMapsAPIKey: ").append(this.toIndentedString(this.googleMapsAPIKey)).append("\n");
        sb.append("    wcGoogleMapsAPIKey: ").append(this.toIndentedString(this.wcGoogleMapsAPIKey)).append("\n");
        sb.append("    tawkToKey: ").append(this.toIndentedString(this.tawkToKey)).append("\n");
        sb.append("    wcTawkToKey: ").append(this.toIndentedString(this.wcTawkToKey)).append("\n");
        sb.append("    defaultCurrency: ").append(this.toIndentedString(this.defaultCurrency)).append("\n");
        sb.append("    defaultLanguage: ").append(this.toIndentedString(this.defaultLanguage)).append("\n");
        sb.append("    logos: ").append(this.toIndentedString(this.logos)).append("\n");
        sb.append("    hostedBookingEngineUrl: ").append(this.toIndentedString(this.hostedBookingEngineUrl)).append("\n");
        sb.append("    selfHosted: ").append(this.toIndentedString(this.selfHosted)).append("\n");
        sb.append("    themeColors: ").append(this.toIndentedString(this.themeColors)).append("\n");
        sb.append("    numberOfAdvanceDays: ").append(this.toIndentedString(this.numberOfAdvanceDays)).append("\n");
        sb.append("    numberOfStayDays: ").append(this.toIndentedString(this.numberOfStayDays)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    roomConfigurations: ").append(this.toIndentedString(this.roomConfigurations)).append("\n");
        sb.append("    useDays: ").append(this.toIndentedString(this.useDays)).append("\n");
        sb.append("    promotionalCodes: ").append(this.toIndentedString(this.promotionalCodes)).append("\n");
        sb.append("    sendBookingNotificationEmailsToProperty: ").append(this.toIndentedString(this.sendBookingNotificationEmailsToProperty)).append("\n");
        sb.append("    sendBookingNotificationEmailsToBooker: ").append(this.toIndentedString(this.sendBookingNotificationEmailsToBooker)).append("\n");
        sb.append("    wcBookClickAction: ").append(this.toIndentedString((Object)this.wcBookClickAction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SubTypeEnum {
        DIRECT("DIRECT"),
        APPLICATION("APPLICATION"),
        HOTEL("HOTEL"),
        TRAVELIKO("TRAVELIKO"),
        CORPORATE("CORPORATE"),
        TRAVEL_AGENT("TRAVEL_AGENT"),
        INFLUENCER("INFLUENCER"),
        BLOGGER("BLOGGER"),
        DESTINATION("DESTINATION"),
        HOTEL_BOOKING_ENGINE("HOTEL_BOOKING_ENGINE");

        private String value;

        private SubTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubTypeEnum fromValue(String value) {
            for (SubTypeEnum b : SubTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum WcBookClickActionEnum {
        FORWARD_TO_IBE("FORWARD_TO_IBE"),
        IBE_MODAL("IBE_MODAL");

        private String value;

        private WcBookClickActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WcBookClickActionEnum fromValue(String value) {
            for (WcBookClickActionEnum b : WcBookClickActionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

