/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

@ApiModel(description="Light-weight Address object")
@JsonPropertyOrder(value={"address1", "address2", "cityGeoNameId", "state", "postalCode", "county"})
public class UpsertAddressRequest {
    public static final String JSON_PROPERTY_ADDRESS1 = "address1";
    private String address1;
    public static final String JSON_PROPERTY_ADDRESS2 = "address2";
    private String address2;
    public static final String JSON_PROPERTY_CITY_GEO_NAME_ID = "cityGeoNameId";
    private String cityGeoNameId;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_COUNTY = "county";
    private String county;

    public UpsertAddressRequest address1(String address1) {
        this.address1 = address1;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="234 Near da beach", required=true, value="Address line 1")
    @JsonProperty(value="address1")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAddress1() {
        return this.address1;
    }

    @JsonProperty(value="address1")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public UpsertAddressRequest address2(String address2) {
        this.address2 = address2;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Pebble #5001", value="Address line 2")
    @JsonProperty(value="address2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress2() {
        return this.address2;
    }

    @JsonProperty(value="address2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public UpsertAddressRequest cityGeoNameId(String cityGeoNameId) {
        this.cityGeoNameId = cityGeoNameId;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="897654", required=true, value="City geo name ID")
    @JsonProperty(value="cityGeoNameId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCityGeoNameId() {
        return this.cityGeoNameId;
    }

    @JsonProperty(value="cityGeoNameId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCityGeoNameId(String cityGeoNameId) {
        this.cityGeoNameId = cityGeoNameId;
    }

    public UpsertAddressRequest state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CA", value="State")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public UpsertAddressRequest postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="90210", required=true, value="Postal / zip code")
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public UpsertAddressRequest county(String county) {
        this.county = county;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Alameda county", value="County")
    @JsonProperty(value="county")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCounty() {
        return this.county;
    }

    @JsonProperty(value="county")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounty(String county) {
        this.county = county;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertAddressRequest upsertAddressRequest = (UpsertAddressRequest)o;
        return Objects.equals(this.address1, upsertAddressRequest.address1) && Objects.equals(this.address2, upsertAddressRequest.address2) && Objects.equals(this.cityGeoNameId, upsertAddressRequest.cityGeoNameId) && Objects.equals(this.state, upsertAddressRequest.state) && Objects.equals(this.postalCode, upsertAddressRequest.postalCode) && Objects.equals(this.county, upsertAddressRequest.county);
    }

    public int hashCode() {
        return Objects.hash(this.address1, this.address2, this.cityGeoNameId, this.state, this.postalCode, this.county);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertAddressRequest {\n");
        sb.append("    address1: ").append(this.toIndentedString(this.address1)).append("\n");
        sb.append("    address2: ").append(this.toIndentedString(this.address2)).append("\n");
        sb.append("    cityGeoNameId: ").append(this.toIndentedString(this.cityGeoNameId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    county: ").append(this.toIndentedString(this.county)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

