/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Country
 */
@ApiModel(description = "Country")
@JsonPropertyOrder({
  Country.JSON_PROPERTY_ISO,
  Country.JSON_PROPERTY_NAME,
  Country.JSON_PROPERTY_CAPITAL,
  Country.JSON_PROPERTY_CONTINENT,
  Country.JSON_PROPERTY_CURRENCY_CODE,
  Country.JSON_PROPERTY_CURRENCY_NAME,
  Country.JSON_PROPERTY_GEO_NAME_ID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-20T21:55:47.213727+07:00[Asia/Bangkok]")
public class Country {
  public static final String JSON_PROPERTY_ISO = "iso";
  private String iso;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_CAPITAL = "capital";
  private String capital;

  public static final String JSON_PROPERTY_CONTINENT = "continent";
  private String continent;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_CURRENCY_NAME = "currencyName";
  private String currencyName;

  public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
  private String geoNameId;

  public Country() { 
  }

  public Country iso(String iso) {
    
    this.iso = iso;
    return this;
  }

   /**
   * ISO code
   * @return iso
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "US", value = "ISO code")
  @JsonProperty(JSON_PROPERTY_ISO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIso() {
    return iso;
  }


  @JsonProperty(JSON_PROPERTY_ISO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIso(String iso) {
    this.iso = iso;
  }


  public Country name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Country name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "United States", value = "Country name")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public Country capital(String capital) {
    
    this.capital = capital;
    return this;
  }

   /**
   * Country capital
   * @return capital
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Washington", value = "Country capital")
  @JsonProperty(JSON_PROPERTY_CAPITAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCapital() {
    return capital;
  }


  @JsonProperty(JSON_PROPERTY_CAPITAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCapital(String capital) {
    this.capital = capital;
  }


  public Country continent(String continent) {
    
    this.continent = continent;
    return this;
  }

   /**
   * Continent code
   * @return continent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "NA", value = "Continent code")
  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinent() {
    return continent;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinent(String continent) {
    this.continent = continent;
  }


  public Country currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Currency code
   * @return currencyCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "USD", value = "Currency code")
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public Country currencyName(String currencyName) {
    
    this.currencyName = currencyName;
    return this;
  }

   /**
   * Currency name
   * @return currencyName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Dollar", value = "Currency name")
  @JsonProperty(JSON_PROPERTY_CURRENCY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyName() {
    return currencyName;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyName(String currencyName) {
    this.currencyName = currencyName;
  }


  public Country geoNameId(String geoNameId) {
    
    this.geoNameId = geoNameId;
    return this;
  }

   /**
   * Country GeoNames identifier
   * @return geoNameId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "6252001", value = "Country GeoNames identifier")
  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGeoNameId() {
    return geoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeoNameId(String geoNameId) {
    this.geoNameId = geoNameId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Country country = (Country) o;
    return Objects.equals(this.iso, country.iso) &&
        Objects.equals(this.name, country.name) &&
        Objects.equals(this.capital, country.capital) &&
        Objects.equals(this.continent, country.continent) &&
        Objects.equals(this.currencyCode, country.currencyCode) &&
        Objects.equals(this.currencyName, country.currencyName) &&
        Objects.equals(this.geoNameId, country.geoNameId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(iso, name, capital, continent, currencyCode, currencyName, geoNameId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Country {\n");
    sb.append("    iso: ").append(toIndentedString(iso)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    capital: ").append(toIndentedString(capital)).append("\n");
    sb.append("    continent: ").append(toIndentedString(continent)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    currencyName: ").append(toIndentedString(currencyName)).append("\n");
    sb.append("    geoNameId: ").append(toIndentedString(geoNameId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

