/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.affiliate.model.Beneficiary;
import travel.wink.sdk.affiliate.model.BookingUser;
import travel.wink.sdk.affiliate.model.DailyRate;
import travel.wink.sdk.affiliate.model.Itinerary;
import travel.wink.sdk.affiliate.model.Moneys;
import travel.wink.sdk.affiliate.model.SupplierContractItemPolicy;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Holds one booking line item for a specific supplier.
 */
@ApiModel(description = "Holds one booking line item for a specific supplier.")
@JsonPropertyOrder({
  BookingContractItem.JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE,
  BookingContractItem.JSON_PROPERTY_USER,
  BookingContractItem.JSON_PROPERTY_NAME_IN_ENGLISH,
  BookingContractItem.JSON_PROPERTY_DESCRIPTION_IN_ENGLISH,
  BookingContractItem.JSON_PROPERTY_TOTAL_SOURCE_PRICE,
  BookingContractItem.JSON_PROPERTY_TOTAL_DISPLAY_PRICE,
  BookingContractItem.JSON_PROPERTY_TOTAL_SUPPLIER_PRICE,
  BookingContractItem.JSON_PROPERTY_TOTAL_INTERNAL_PRICE,
  BookingContractItem.JSON_PROPERTY_TOTAL_CAPTURE_PRICE,
  BookingContractItem.JSON_PROPERTY_ITINERARY,
  BookingContractItem.JSON_PROPERTY_PRICING_TYPE,
  BookingContractItem.JSON_PROPERTY_TYPE,
  BookingContractItem.JSON_PROPERTY_BENEFICIARY_LIST,
  BookingContractItem.JSON_PROPERTY_PAYABLE,
  BookingContractItem.JSON_PROPERTY_POLICY,
  BookingContractItem.JSON_PROPERTY_EXTERNAL_IDENTIFIER,
  BookingContractItem.JSON_PROPERTY_TOKENS_EARNED,
  BookingContractItem.JSON_PROPERTY_DAILY_RATE_LIST,
  BookingContractItem.JSON_PROPERTY_CANCELLED,
  BookingContractItem.JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_CANCELLATION,
  BookingContractItem.JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_CANCELLATION,
  BookingContractItem.JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_CANCELLATION,
  BookingContractItem.JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_CANCELLATION,
  BookingContractItem.JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_CANCELLATION,
  BookingContractItem.JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES,
  BookingContractItem.JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES,
  BookingContractItem.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER,
  BookingContractItem.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-20T22:26:10.016072+07:00[Asia/Bangkok]")
public class BookingContractItem {
  public static final String JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE = "supplierItemBookingCode";
  private String supplierItemBookingCode;

  public static final String JSON_PROPERTY_USER = "user";
  private BookingUser user;

  public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
  private String nameInEnglish;

  public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
  private String descriptionInEnglish;

  public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE = "totalSourcePrice";
  private Moneys totalSourcePrice;

  public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
  private Moneys totalDisplayPrice;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
  private Moneys totalSupplierPrice;

  public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
  private Moneys totalInternalPrice;

  public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
  private Moneys totalCapturePrice;

  public static final String JSON_PROPERTY_ITINERARY = "itinerary";
  private Itinerary itinerary;

  /**
   * How to calculate the total amount.
   */
  public enum PricingTypeEnum {
    HOUR("PER_HOUR"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    STAY("PER_STAY"),
    
    PERSON("PER_PERSON"),
    
    NIGHT("PER_NIGHT"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_STAY("PER_PERSON_PER_STAY"),
    
    USE("PER_USE");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  /**
   * Type of item this is.
   */
  public enum TypeEnum {
    LODGING("LODGING"),
    
    RAIL("RAIL"),
    
    AIR("AIR"),
    
    CAR("CAR"),
    
    CRUISE("CRUISE"),
    
    PACKAGE("PACKAGE"),
    
    ADD_ON("ADD_ON"),
    
    RENTAL("RENTAL"),
    
    EXPERIENCE("EXPERIENCE"),
    
    ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
    
    ANCILLARY_FEE("ANCILLARY_FEE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
  private List<Beneficiary> beneficiaryList = new ArrayList<>();

  /**
   * When to charge for this item.
   */
  public enum PayableEnum {
    IMMEDIATE("IMMEDIATE"),
    
    ARRIVAL("ARRIVAL"),
    
    DEPARTURE("DEPARTURE"),
    
    AGENT("AGENT");

    private String value;

    PayableEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayableEnum fromValue(String value) {
      for (PayableEnum b : PayableEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYABLE = "payable";
  private PayableEnum payable;

  public static final String JSON_PROPERTY_POLICY = "policy";
  private SupplierContractItemPolicy policy;

  public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
  private String externalIdentifier;

  public static final String JSON_PROPERTY_TOKENS_EARNED = "tokensEarned";
  private Long tokensEarned;

  public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
  private List<DailyRate> dailyRateList = null;

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  private Boolean cancelled;

  public static final String JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_CANCELLATION = "totalSourcePriceAfterCancellation";
  private Moneys totalSourcePriceAfterCancellation;

  public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_CANCELLATION = "totalDisplayPriceAfterCancellation";
  private Moneys totalDisplayPriceAfterCancellation;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_CANCELLATION = "totalSupplierPriceAfterCancellation";
  private Moneys totalSupplierPriceAfterCancellation;

  public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_CANCELLATION = "totalInternalPriceAfterCancellation";
  private Moneys totalInternalPriceAfterCancellation;

  public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_CANCELLATION = "totalCapturePriceAfterCancellation";
  private Moneys totalCapturePriceAfterCancellation;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES = "cancellableWithPotentialCharges";
  private Boolean cancellableWithPotentialCharges;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
  private Boolean cancellableWithNoCharges;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  private Boolean cancellableBySupplier;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  private Boolean cancellableByTraveler;

  public BookingContractItem() { 
  }

  @JsonCreator
  public BookingContractItem(
    @JsonProperty(JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE) String supplierItemBookingCode, 
    @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH) String nameInEnglish, 
    @JsonProperty(JSON_PROPERTY_DESCRIPTION_IN_ENGLISH) String descriptionInEnglish, 
    @JsonProperty(JSON_PROPERTY_PRICING_TYPE) PricingTypeEnum pricingType, 
    @JsonProperty(JSON_PROPERTY_TYPE) TypeEnum type, 
    @JsonProperty(JSON_PROPERTY_PAYABLE) PayableEnum payable, 
    @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER) String externalIdentifier, 
    @JsonProperty(JSON_PROPERTY_TOKENS_EARNED) Long tokensEarned
  ) {
    this();
    this.supplierItemBookingCode = supplierItemBookingCode;
    this.nameInEnglish = nameInEnglish;
    this.descriptionInEnglish = descriptionInEnglish;
    this.pricingType = pricingType;
    this.type = type;
    this.payable = payable;
    this.externalIdentifier = externalIdentifier;
    this.tokensEarned = tokensEarned;
  }

   /**
   * Booking code identifying the supplier line item.
   * @return supplierItemBookingCode
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "TP-ASDFG1234", required = true, value = "Booking code identifying the supplier line item.")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierItemBookingCode() {
    return supplierItemBookingCode;
  }




  public BookingContractItem user(BookingUser user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUser getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(BookingUser user) {
    this.user = user;
  }


   /**
   * Name of item in English included in booking.
   * @return nameInEnglish
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "Deluxe King", required = true, value = "Name of item in English included in booking.")
  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getNameInEnglish() {
    return nameInEnglish;
  }




   /**
   * Short description in English of item included in booking.
   * @return descriptionInEnglish
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "This is the best deluxe king that money can buy.", required = true, value = "Short description in English of item included in booking.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescriptionInEnglish() {
    return descriptionInEnglish;
  }




  public BookingContractItem totalSourcePrice(Moneys totalSourcePrice) {
    
    this.totalSourcePrice = totalSourcePrice;
    return this;
  }

   /**
   * Get totalSourcePrice
   * @return totalSourcePrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getTotalSourcePrice() {
    return totalSourcePrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalSourcePrice(Moneys totalSourcePrice) {
    this.totalSourcePrice = totalSourcePrice;
  }


  public BookingContractItem totalDisplayPrice(Moneys totalDisplayPrice) {
    
    this.totalDisplayPrice = totalDisplayPrice;
    return this;
  }

   /**
   * Get totalDisplayPrice
   * @return totalDisplayPrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getTotalDisplayPrice() {
    return totalDisplayPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalDisplayPrice(Moneys totalDisplayPrice) {
    this.totalDisplayPrice = totalDisplayPrice;
  }


  public BookingContractItem totalSupplierPrice(Moneys totalSupplierPrice) {
    
    this.totalSupplierPrice = totalSupplierPrice;
    return this;
  }

   /**
   * Get totalSupplierPrice
   * @return totalSupplierPrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getTotalSupplierPrice() {
    return totalSupplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalSupplierPrice(Moneys totalSupplierPrice) {
    this.totalSupplierPrice = totalSupplierPrice;
  }


  public BookingContractItem totalInternalPrice(Moneys totalInternalPrice) {
    
    this.totalInternalPrice = totalInternalPrice;
    return this;
  }

   /**
   * Get totalInternalPrice
   * @return totalInternalPrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getTotalInternalPrice() {
    return totalInternalPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalInternalPrice(Moneys totalInternalPrice) {
    this.totalInternalPrice = totalInternalPrice;
  }


  public BookingContractItem totalCapturePrice(Moneys totalCapturePrice) {
    
    this.totalCapturePrice = totalCapturePrice;
    return this;
  }

   /**
   * Get totalCapturePrice
   * @return totalCapturePrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Moneys getTotalCapturePrice() {
    return totalCapturePrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalCapturePrice(Moneys totalCapturePrice) {
    this.totalCapturePrice = totalCapturePrice;
  }


  public BookingContractItem itinerary(Itinerary itinerary) {
    
    this.itinerary = itinerary;
    return this;
  }

   /**
   * Get itinerary
   * @return itinerary
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Itinerary getItinerary() {
    return itinerary;
  }


  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItinerary(Itinerary itinerary) {
    this.itinerary = itinerary;
  }


   /**
   * How to calculate the total amount.
   * @return pricingType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "How to calculate the total amount.")
  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }




   /**
   * Type of item this is.
   * @return type
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "LODGING", required = true, value = "Type of item this is.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }




  public BookingContractItem beneficiaryList(List<Beneficiary> beneficiaryList) {
    
    this.beneficiaryList = beneficiaryList;
    return this;
  }

  public BookingContractItem addBeneficiaryListItem(Beneficiary beneficiaryListItem) {
    this.beneficiaryList.add(beneficiaryListItem);
    return this;
  }

   /**
   * Get beneficiaryList
   * @return beneficiaryList
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_BENEFICIARY_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<Beneficiary> getBeneficiaryList() {
    return beneficiaryList;
  }


  @JsonProperty(JSON_PROPERTY_BENEFICIARY_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBeneficiaryList(List<Beneficiary> beneficiaryList) {
    this.beneficiaryList = beneficiaryList;
  }


   /**
   * When to charge for this item.
   * @return payable
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "PREPAY", required = true, value = "When to charge for this item.")
  @JsonProperty(JSON_PROPERTY_PAYABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PayableEnum getPayable() {
    return payable;
  }




  public BookingContractItem policy(SupplierContractItemPolicy policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SupplierContractItemPolicy getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(SupplierContractItemPolicy policy) {
    this.policy = policy;
  }


   /**
   * Optional geoname externalIdentifier to remote inventory.
   * @return externalIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "room-type-1", value = "Optional geoname externalIdentifier to remote inventory.")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalIdentifier() {
    return externalIdentifier;
  }




   /**
   * Tokens earned for this item
   * @return tokensEarned
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "12", value = "Tokens earned for this item")
  @JsonProperty(JSON_PROPERTY_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTokensEarned() {
    return tokensEarned;
  }




  public BookingContractItem dailyRateList(List<DailyRate> dailyRateList) {
    
    this.dailyRateList = dailyRateList;
    return this;
  }

  public BookingContractItem addDailyRateListItem(DailyRate dailyRateListItem) {
    if (this.dailyRateList == null) {
      this.dailyRateList = new ArrayList<>();
    }
    this.dailyRateList.add(dailyRateListItem);
    return this;
  }

   /**
   * Get dailyRateList
   * @return dailyRateList
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DailyRate> getDailyRateList() {
    return dailyRateList;
  }


  @JsonProperty(JSON_PROPERTY_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDailyRateList(List<DailyRate> dailyRateList) {
    this.dailyRateList = dailyRateList;
  }


  public BookingContractItem cancelled(Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

   /**
   * Optional geoname externalIdentifier to remote inventory.
   * @return cancelled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional geoname externalIdentifier to remote inventory.")
  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelled(Boolean cancelled) {
    this.cancelled = cancelled;
  }


  public BookingContractItem totalSourcePriceAfterCancellation(Moneys totalSourcePriceAfterCancellation) {
    
    this.totalSourcePriceAfterCancellation = totalSourcePriceAfterCancellation;
    return this;
  }

   /**
   * Get totalSourcePriceAfterCancellation
   * @return totalSourcePriceAfterCancellation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalSourcePriceAfterCancellation() {
    return totalSourcePriceAfterCancellation;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSourcePriceAfterCancellation(Moneys totalSourcePriceAfterCancellation) {
    this.totalSourcePriceAfterCancellation = totalSourcePriceAfterCancellation;
  }


  public BookingContractItem totalDisplayPriceAfterCancellation(Moneys totalDisplayPriceAfterCancellation) {
    
    this.totalDisplayPriceAfterCancellation = totalDisplayPriceAfterCancellation;
    return this;
  }

   /**
   * Get totalDisplayPriceAfterCancellation
   * @return totalDisplayPriceAfterCancellation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalDisplayPriceAfterCancellation() {
    return totalDisplayPriceAfterCancellation;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDisplayPriceAfterCancellation(Moneys totalDisplayPriceAfterCancellation) {
    this.totalDisplayPriceAfterCancellation = totalDisplayPriceAfterCancellation;
  }


  public BookingContractItem totalSupplierPriceAfterCancellation(Moneys totalSupplierPriceAfterCancellation) {
    
    this.totalSupplierPriceAfterCancellation = totalSupplierPriceAfterCancellation;
    return this;
  }

   /**
   * Get totalSupplierPriceAfterCancellation
   * @return totalSupplierPriceAfterCancellation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalSupplierPriceAfterCancellation() {
    return totalSupplierPriceAfterCancellation;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierPriceAfterCancellation(Moneys totalSupplierPriceAfterCancellation) {
    this.totalSupplierPriceAfterCancellation = totalSupplierPriceAfterCancellation;
  }


  public BookingContractItem totalInternalPriceAfterCancellation(Moneys totalInternalPriceAfterCancellation) {
    
    this.totalInternalPriceAfterCancellation = totalInternalPriceAfterCancellation;
    return this;
  }

   /**
   * Get totalInternalPriceAfterCancellation
   * @return totalInternalPriceAfterCancellation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalInternalPriceAfterCancellation() {
    return totalInternalPriceAfterCancellation;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalInternalPriceAfterCancellation(Moneys totalInternalPriceAfterCancellation) {
    this.totalInternalPriceAfterCancellation = totalInternalPriceAfterCancellation;
  }


  public BookingContractItem totalCapturePriceAfterCancellation(Moneys totalCapturePriceAfterCancellation) {
    
    this.totalCapturePriceAfterCancellation = totalCapturePriceAfterCancellation;
    return this;
  }

   /**
   * Get totalCapturePriceAfterCancellation
   * @return totalCapturePriceAfterCancellation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalCapturePriceAfterCancellation() {
    return totalCapturePriceAfterCancellation;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE_AFTER_CANCELLATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCapturePriceAfterCancellation(Moneys totalCapturePriceAfterCancellation) {
    this.totalCapturePriceAfterCancellation = totalCapturePriceAfterCancellation;
  }


  public BookingContractItem cancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
    
    this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
    return this;
  }

   /**
   * Whether the booking can still be cancelled and whether cancellation charges might still occur.
   * @return cancellableWithPotentialCharges
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the booking can still be cancelled and whether cancellation charges might still occur.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithPotentialCharges() {
    return cancellableWithPotentialCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
    this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
  }


  public BookingContractItem cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    
    this.cancellableWithNoCharges = cancellableWithNoCharges;
    return this;
  }

   /**
   * Whether the booking can still be cancelled and whether cancellation charges might still occur.
   * @return cancellableWithNoCharges
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the booking can still be cancelled and whether cancellation charges might still occur.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithNoCharges() {
    return cancellableWithNoCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    this.cancellableWithNoCharges = cancellableWithNoCharges;
  }


  public BookingContractItem cancellableBySupplier(Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

   /**
   * Whether the booking can still be cancelled by the supplier. A supplier cancellation overrides the refundable
   * @return cancellableBySupplier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the booking can still be cancelled by the supplier. A supplier cancellation overrides the refundable")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }


  public BookingContractItem cancellableByTraveler(Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

   /**
   * Whether the booking can still be cancelled by the traveller.
   * @return cancellableByTraveler
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the booking can still be cancelled by the traveller.")
  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractItem bookingContractItem = (BookingContractItem) o;
    return Objects.equals(this.supplierItemBookingCode, bookingContractItem.supplierItemBookingCode) &&
        Objects.equals(this.user, bookingContractItem.user) &&
        Objects.equals(this.nameInEnglish, bookingContractItem.nameInEnglish) &&
        Objects.equals(this.descriptionInEnglish, bookingContractItem.descriptionInEnglish) &&
        Objects.equals(this.totalSourcePrice, bookingContractItem.totalSourcePrice) &&
        Objects.equals(this.totalDisplayPrice, bookingContractItem.totalDisplayPrice) &&
        Objects.equals(this.totalSupplierPrice, bookingContractItem.totalSupplierPrice) &&
        Objects.equals(this.totalInternalPrice, bookingContractItem.totalInternalPrice) &&
        Objects.equals(this.totalCapturePrice, bookingContractItem.totalCapturePrice) &&
        Objects.equals(this.itinerary, bookingContractItem.itinerary) &&
        Objects.equals(this.pricingType, bookingContractItem.pricingType) &&
        Objects.equals(this.type, bookingContractItem.type) &&
        Objects.equals(this.beneficiaryList, bookingContractItem.beneficiaryList) &&
        Objects.equals(this.payable, bookingContractItem.payable) &&
        Objects.equals(this.policy, bookingContractItem.policy) &&
        Objects.equals(this.externalIdentifier, bookingContractItem.externalIdentifier) &&
        Objects.equals(this.tokensEarned, bookingContractItem.tokensEarned) &&
        Objects.equals(this.dailyRateList, bookingContractItem.dailyRateList) &&
        Objects.equals(this.cancelled, bookingContractItem.cancelled) &&
        Objects.equals(this.totalSourcePriceAfterCancellation, bookingContractItem.totalSourcePriceAfterCancellation) &&
        Objects.equals(this.totalDisplayPriceAfterCancellation, bookingContractItem.totalDisplayPriceAfterCancellation) &&
        Objects.equals(this.totalSupplierPriceAfterCancellation, bookingContractItem.totalSupplierPriceAfterCancellation) &&
        Objects.equals(this.totalInternalPriceAfterCancellation, bookingContractItem.totalInternalPriceAfterCancellation) &&
        Objects.equals(this.totalCapturePriceAfterCancellation, bookingContractItem.totalCapturePriceAfterCancellation) &&
        Objects.equals(this.cancellableWithPotentialCharges, bookingContractItem.cancellableWithPotentialCharges) &&
        Objects.equals(this.cancellableWithNoCharges, bookingContractItem.cancellableWithNoCharges) &&
        Objects.equals(this.cancellableBySupplier, bookingContractItem.cancellableBySupplier) &&
        Objects.equals(this.cancellableByTraveler, bookingContractItem.cancellableByTraveler);
  }

  @Override
  public int hashCode() {
    return Objects.hash(supplierItemBookingCode, user, nameInEnglish, descriptionInEnglish, totalSourcePrice, totalDisplayPrice, totalSupplierPrice, totalInternalPrice, totalCapturePrice, itinerary, pricingType, type, beneficiaryList, payable, policy, externalIdentifier, tokensEarned, dailyRateList, cancelled, totalSourcePriceAfterCancellation, totalDisplayPriceAfterCancellation, totalSupplierPriceAfterCancellation, totalInternalPriceAfterCancellation, totalCapturePriceAfterCancellation, cancellableWithPotentialCharges, cancellableWithNoCharges, cancellableBySupplier, cancellableByTraveler);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractItem {\n");
    sb.append("    supplierItemBookingCode: ").append(toIndentedString(supplierItemBookingCode)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    nameInEnglish: ").append(toIndentedString(nameInEnglish)).append("\n");
    sb.append("    descriptionInEnglish: ").append(toIndentedString(descriptionInEnglish)).append("\n");
    sb.append("    totalSourcePrice: ").append(toIndentedString(totalSourcePrice)).append("\n");
    sb.append("    totalDisplayPrice: ").append(toIndentedString(totalDisplayPrice)).append("\n");
    sb.append("    totalSupplierPrice: ").append(toIndentedString(totalSupplierPrice)).append("\n");
    sb.append("    totalInternalPrice: ").append(toIndentedString(totalInternalPrice)).append("\n");
    sb.append("    totalCapturePrice: ").append(toIndentedString(totalCapturePrice)).append("\n");
    sb.append("    itinerary: ").append(toIndentedString(itinerary)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    beneficiaryList: ").append(toIndentedString(beneficiaryList)).append("\n");
    sb.append("    payable: ").append(toIndentedString(payable)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("    tokensEarned: ").append(toIndentedString(tokensEarned)).append("\n");
    sb.append("    dailyRateList: ").append(toIndentedString(dailyRateList)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    totalSourcePriceAfterCancellation: ").append(toIndentedString(totalSourcePriceAfterCancellation)).append("\n");
    sb.append("    totalDisplayPriceAfterCancellation: ").append(toIndentedString(totalDisplayPriceAfterCancellation)).append("\n");
    sb.append("    totalSupplierPriceAfterCancellation: ").append(toIndentedString(totalSupplierPriceAfterCancellation)).append("\n");
    sb.append("    totalInternalPriceAfterCancellation: ").append(toIndentedString(totalInternalPriceAfterCancellation)).append("\n");
    sb.append("    totalCapturePriceAfterCancellation: ").append(toIndentedString(totalCapturePriceAfterCancellation)).append("\n");
    sb.append("    cancellableWithPotentialCharges: ").append(toIndentedString(cancellableWithPotentialCharges)).append("\n");
    sb.append("    cancellableWithNoCharges: ").append(toIndentedString(cancellableWithNoCharges)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

