/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.affiliate.model.Country;
import travel.wink.sdk.affiliate.model.HotelOnMapLocation;
import travel.wink.sdk.affiliate.model.SubCountry;
import travel.wink.sdk.affiliate.model.SubSubCountry;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * GeoNames have been created at [https://geonames.org](https://geonames.org) and contain geographical destinations we use as geoname data to associate travel inventory with a location.
 */
@ApiModel(description = "GeoNames have been created at [https://geonames.org](https://geonames.org) and contain geographical destinations we use as geoname data to associate travel inventory with a location.")
@JsonPropertyOrder({
  GeoName.JSON_PROPERTY_GEO_NAME_ID,
  GeoName.JSON_PROPERTY_TYPE,
  GeoName.JSON_PROPERTY_NAME,
  GeoName.JSON_PROPERTY_URL_NAME,
  GeoName.JSON_PROPERTY_ASCII_NAME,
  GeoName.JSON_PROPERTY_LOCATION,
  GeoName.JSON_PROPERTY_FEATURE_CODE,
  GeoName.JSON_PROPERTY_COUNTRY_CODE,
  GeoName.JSON_PROPERTY_TIMEZONE,
  GeoName.JSON_PROPERTY_COUNTRY,
  GeoName.JSON_PROPERTY_SUB_COUNTRY,
  GeoName.JSON_PROPERTY_SUB_SUB_COUNTRY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-20T22:26:10.016072+07:00[Asia/Bangkok]")
public class GeoName {
  public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
  private String geoNameId;

  /**
   * GeoName type
   */
  public enum TypeEnum {
    CITY("CITY"),
    
    ISLAND("ISLAND"),
    
    OTHER("OTHER");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_ASCII_NAME = "asciiName";
  private String asciiName;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private HotelOnMapLocation location;

  public static final String JSON_PROPERTY_FEATURE_CODE = "featureCode";
  private String featureCode;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private Country country;

  public static final String JSON_PROPERTY_SUB_COUNTRY = "subCountry";
  private SubCountry subCountry;

  public static final String JSON_PROPERTY_SUB_SUB_COUNTRY = "subSubCountry";
  private SubSubCountry subSubCountry;

  public GeoName() { 
  }

  public GeoName geoNameId(String geoNameId) {
    
    this.geoNameId = geoNameId;
    return this;
  }

   /**
   * GeoName identifier
   * @return geoNameId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "5128581", value = "GeoName identifier")
  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGeoNameId() {
    return geoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeoNameId(String geoNameId) {
    this.geoNameId = geoNameId;
  }


  public GeoName type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * GeoName type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "GeoName type")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public GeoName name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of city
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "New York City", value = "Name of city")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public GeoName urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Url name
   * @return urlName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "new-york-city-united-states", value = "Url name")
  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public GeoName asciiName(String asciiName) {
    
    this.asciiName = asciiName;
    return this;
  }

   /**
   * Ascii name of city
   * @return asciiName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "New York City", value = "Ascii name of city")
  @JsonProperty(JSON_PROPERTY_ASCII_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAsciiName() {
    return asciiName;
  }


  @JsonProperty(JSON_PROPERTY_ASCII_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAsciiName(String asciiName) {
    this.asciiName = asciiName;
  }


  public GeoName location(HotelOnMapLocation location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HotelOnMapLocation getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(HotelOnMapLocation location) {
    this.location = location;
  }


  public GeoName featureCode(String featureCode) {
    
    this.featureCode = featureCode;
    return this;
  }

   /**
   * Get featureCode
   * @return featureCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FEATURE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFeatureCode() {
    return featureCode;
  }


  @JsonProperty(JSON_PROPERTY_FEATURE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeatureCode(String featureCode) {
    this.featureCode = featureCode;
  }


  public GeoName countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Get countryCode
   * @return countryCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public GeoName timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * Timezone
   * @return timezone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "America/New_York", value = "Timezone")
  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public GeoName country(Country country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Country getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(Country country) {
    this.country = country;
  }


  public GeoName subCountry(SubCountry subCountry) {
    
    this.subCountry = subCountry;
    return this;
  }

   /**
   * Get subCountry
   * @return subCountry
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubCountry getSubCountry() {
    return subCountry;
  }


  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubCountry(SubCountry subCountry) {
    this.subCountry = subCountry;
  }


  public GeoName subSubCountry(SubSubCountry subSubCountry) {
    
    this.subSubCountry = subSubCountry;
    return this;
  }

   /**
   * Get subSubCountry
   * @return subSubCountry
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubSubCountry getSubSubCountry() {
    return subSubCountry;
  }


  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubSubCountry(SubSubCountry subSubCountry) {
    this.subSubCountry = subSubCountry;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoName geoName = (GeoName) o;
    return Objects.equals(this.geoNameId, geoName.geoNameId) &&
        Objects.equals(this.type, geoName.type) &&
        Objects.equals(this.name, geoName.name) &&
        Objects.equals(this.urlName, geoName.urlName) &&
        Objects.equals(this.asciiName, geoName.asciiName) &&
        Objects.equals(this.location, geoName.location) &&
        Objects.equals(this.featureCode, geoName.featureCode) &&
        Objects.equals(this.countryCode, geoName.countryCode) &&
        Objects.equals(this.timezone, geoName.timezone) &&
        Objects.equals(this.country, geoName.country) &&
        Objects.equals(this.subCountry, geoName.subCountry) &&
        Objects.equals(this.subSubCountry, geoName.subSubCountry);
  }

  @Override
  public int hashCode() {
    return Objects.hash(geoNameId, type, name, urlName, asciiName, location, featureCode, countryCode, timezone, country, subCountry, subSubCountry);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoName {\n");
    sb.append("    geoNameId: ").append(toIndentedString(geoNameId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    asciiName: ").append(toIndentedString(asciiName)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    featureCode: ").append(toIndentedString(featureCode)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    subCountry: ").append(toIndentedString(subCountry)).append("\n");
    sb.append("    subSubCountry: ").append(toIndentedString(subSubCountry)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

