package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.EngineConfigurationView;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.RemoveEntryResponse;
import travel.wink.sdk.affiliate.model.ShowSellerUrl400Response;
import travel.wink.sdk.affiliate.model.UpsertEngineConfigurationRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-01T17:00:13.107203+07:00[Asia/Bangkok]")
public class CustomizationApi {
    private ApiClient apiClient;

    public CustomizationApi() {
        this(new ApiClient());
    }

    @Autowired
    public CustomizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Customization
     * Create a new customization and associate it with the specified application.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param companyIdentifier Create customization for this company
     * @param upsertEngineConfigurationRequest The upsertEngineConfigurationRequest parameter
     * @return EngineConfigurationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createApplicationConfigurationRequestCreation(String companyIdentifier, UpsertEngineConfigurationRequest upsertEngineConfigurationRequest) throws WebClientResponseException {
        Object postBody = upsertEngineConfigurationRequest;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertEngineConfigurationRequest' is set
        if (upsertEngineConfigurationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertEngineConfigurationRequest' when calling createApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Customization
     * Create a new customization and associate it with the specified application.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param companyIdentifier Create customization for this company
     * @param upsertEngineConfigurationRequest The upsertEngineConfigurationRequest parameter
     * @return EngineConfigurationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<EngineConfigurationView> createApplicationConfiguration(String companyIdentifier, UpsertEngineConfigurationRequest upsertEngineConfigurationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>() {};
        return createApplicationConfigurationRequestCreation(companyIdentifier, upsertEngineConfigurationRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationView>> createApplicationConfigurationWithHttpInfo(String companyIdentifier, UpsertEngineConfigurationRequest upsertEngineConfigurationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>() {};
        return createApplicationConfigurationRequestCreation(companyIdentifier, upsertEngineConfigurationRequest).toEntity(localVarReturnType);
    }
    /**
     * Remove Customization
     * Remove an existing customization.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove customization for this company
     * @param engineConfigurationIdentifier Remove customization with this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeApplicationConfigurationRequestCreation(String companyIdentifier, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'engineConfigurationIdentifier' is set
        if (engineConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineConfigurationIdentifier' when calling removeApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineConfigurationIdentifier", engineConfigurationIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/{engineConfigurationIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Customization
     * Remove an existing customization.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove customization for this company
     * @param engineConfigurationIdentifier Remove customization with this identifier
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeApplicationConfiguration(String companyIdentifier, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeApplicationConfigurationWithHttpInfo(String companyIdentifier, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Primary Customization
     * Retrieve the primary customization for an application.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customization for this company
     * @param accept The accept parameter
     * @return EngineConfigurationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showApplicationConfigurationRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Primary Customization
     * Retrieve the primary customization for an application.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customization for this company
     * @param accept The accept parameter
     * @return EngineConfigurationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<EngineConfigurationView> showApplicationConfiguration(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>() {};
        return showApplicationConfigurationRequestCreation(companyIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationView>> showApplicationConfigurationWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>() {};
        return showApplicationConfigurationRequestCreation(companyIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Customizations
     * Retrieve a list of customizations for specified company.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customizations for this company
     * @param accept The accept parameter
     * @return List&lt;EngineConfigurationView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showApplicationConfigurationsByOwnerRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showApplicationConfigurationsByOwner", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Customizations
     * Retrieve a list of customizations for specified company.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customizations for this company
     * @param accept The accept parameter
     * @return List&lt;EngineConfigurationView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<EngineConfigurationView> showApplicationConfigurationsByOwner(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>() {};
        return showApplicationConfigurationsByOwnerRequestCreation(companyIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<EngineConfigurationView>>> showApplicationConfigurationsByOwnerWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>() {};
        return showApplicationConfigurationsByOwnerRequestCreation(companyIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Customization
     * Update an existing customization.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Update customization for this company
     * @param engineConfigurationIdentifier Update customization with this application
     * @param upsertEngineConfigurationRequest The upsertEngineConfigurationRequest parameter
     * @return EngineConfigurationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateApplicationConfigurationRequestCreation(String companyIdentifier, String engineConfigurationIdentifier, UpsertEngineConfigurationRequest upsertEngineConfigurationRequest) throws WebClientResponseException {
        Object postBody = upsertEngineConfigurationRequest;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'engineConfigurationIdentifier' is set
        if (engineConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineConfigurationIdentifier' when calling updateApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertEngineConfigurationRequest' is set
        if (upsertEngineConfigurationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertEngineConfigurationRequest' when calling updateApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineConfigurationIdentifier", engineConfigurationIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/{engineConfigurationIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Customization
     * Update an existing customization.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param companyIdentifier Update customization for this company
     * @param engineConfigurationIdentifier Update customization with this application
     * @param upsertEngineConfigurationRequest The upsertEngineConfigurationRequest parameter
     * @return EngineConfigurationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<EngineConfigurationView> updateApplicationConfiguration(String companyIdentifier, String engineConfigurationIdentifier, UpsertEngineConfigurationRequest upsertEngineConfigurationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>() {};
        return updateApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, upsertEngineConfigurationRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationView>> updateApplicationConfigurationWithHttpInfo(String companyIdentifier, String engineConfigurationIdentifier, UpsertEngineConfigurationRequest upsertEngineConfigurationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>() {};
        return updateApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, upsertEngineConfigurationRequest).toEntity(localVarReturnType);
    }
}
