/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 20.3.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import travel.wink.sdk.affiliate.model.Border;
import travel.wink.sdk.affiliate.model.Margin;
import travel.wink.sdk.affiliate.model.Padding;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Title of axis
 */
@ApiModel(description = "Title of axis")
@JsonPropertyOrder({
  CategoryAxisTitle.JSON_PROPERTY_BACKGROUND,
  CategoryAxisTitle.JSON_PROPERTY_BORDER,
  CategoryAxisTitle.JSON_PROPERTY_COLOR,
  CategoryAxisTitle.JSON_PROPERTY_FONT,
  CategoryAxisTitle.JSON_PROPERTY_MARGIN,
  CategoryAxisTitle.JSON_PROPERTY_PADDING,
  CategoryAxisTitle.JSON_PROPERTY_POSITION,
  CategoryAxisTitle.JSON_PROPERTY_ROTATION,
  CategoryAxisTitle.JSON_PROPERTY_TEXT,
  CategoryAxisTitle.JSON_PROPERTY_VISIBLE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-01T17:00:13.107203+07:00[Asia/Bangkok]")
public class CategoryAxisTitle {
  public static final String JSON_PROPERTY_BACKGROUND = "background";
  private String background;

  public static final String JSON_PROPERTY_BORDER = "border";
  private Border border;

  public static final String JSON_PROPERTY_COLOR = "color";
  private String color;

  public static final String JSON_PROPERTY_FONT = "font";
  private String font;

  public static final String JSON_PROPERTY_MARGIN = "margin";
  private Margin margin;

  public static final String JSON_PROPERTY_PADDING = "padding";
  private Padding padding;

  /**
   * Gets or Sets position
   */
  public enum PositionEnum {
    TOP("top"),
    
    BOTTOM("bottom"),
    
    LEFT("left"),
    
    RIGHT("right"),
    
    CENTER("center");

    private String value;

    PositionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PositionEnum fromValue(String value) {
      for (PositionEnum b : PositionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_POSITION = "position";
  private PositionEnum position;

  public static final String JSON_PROPERTY_ROTATION = "rotation";
  private BigDecimal rotation;

  public static final String JSON_PROPERTY_TEXT = "text";
  private String text;

  public static final String JSON_PROPERTY_VISIBLE = "visible";
  private Boolean visible;

  public CategoryAxisTitle() { 
  }

  public CategoryAxisTitle background(String background) {
    
    this.background = background;
    return this;
  }

   /**
   * Get background
   * @return background
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBackground() {
    return background;
  }


  @JsonProperty(JSON_PROPERTY_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBackground(String background) {
    this.background = background;
  }


  public CategoryAxisTitle border(Border border) {
    
    this.border = border;
    return this;
  }

   /**
   * Get border
   * @return border
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Border getBorder() {
    return border;
  }


  @JsonProperty(JSON_PROPERTY_BORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBorder(Border border) {
    this.border = border;
  }


  public CategoryAxisTitle color(String color) {
    
    this.color = color;
    return this;
  }

   /**
   * Get color
   * @return color
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColor(String color) {
    this.color = color;
  }


  public CategoryAxisTitle font(String font) {
    
    this.font = font;
    return this;
  }

   /**
   * Get font
   * @return font
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FONT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFont() {
    return font;
  }


  @JsonProperty(JSON_PROPERTY_FONT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFont(String font) {
    this.font = font;
  }


  public CategoryAxisTitle margin(Margin margin) {
    
    this.margin = margin;
    return this;
  }

   /**
   * Get margin
   * @return margin
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MARGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Margin getMargin() {
    return margin;
  }


  @JsonProperty(JSON_PROPERTY_MARGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMargin(Margin margin) {
    this.margin = margin;
  }


  public CategoryAxisTitle padding(Padding padding) {
    
    this.padding = padding;
    return this;
  }

   /**
   * Get padding
   * @return padding
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PADDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Padding getPadding() {
    return padding;
  }


  @JsonProperty(JSON_PROPERTY_PADDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPadding(Padding padding) {
    this.padding = padding;
  }


  public CategoryAxisTitle position(PositionEnum position) {
    
    this.position = position;
    return this;
  }

   /**
   * Get position
   * @return position
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PositionEnum getPosition() {
    return position;
  }


  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPosition(PositionEnum position) {
    this.position = position;
  }


  public CategoryAxisTitle rotation(BigDecimal rotation) {
    
    this.rotation = rotation;
    return this;
  }

   /**
   * Get rotation
   * @return rotation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getRotation() {
    return rotation;
  }


  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRotation(BigDecimal rotation) {
    this.rotation = rotation;
  }


  public CategoryAxisTitle text(String text) {
    
    this.text = text;
    return this;
  }

   /**
   * Get text
   * @return text
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setText(String text) {
    this.text = text;
  }


  public CategoryAxisTitle visible(Boolean visible) {
    
    this.visible = visible;
    return this;
  }

   /**
   * Get visible
   * @return visible
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VISIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getVisible() {
    return visible;
  }


  @JsonProperty(JSON_PROPERTY_VISIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisible(Boolean visible) {
    this.visible = visible;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CategoryAxisTitle categoryAxisTitle = (CategoryAxisTitle) o;
    return Objects.equals(this.background, categoryAxisTitle.background) &&
        Objects.equals(this.border, categoryAxisTitle.border) &&
        Objects.equals(this.color, categoryAxisTitle.color) &&
        Objects.equals(this.font, categoryAxisTitle.font) &&
        Objects.equals(this.margin, categoryAxisTitle.margin) &&
        Objects.equals(this.padding, categoryAxisTitle.padding) &&
        Objects.equals(this.position, categoryAxisTitle.position) &&
        Objects.equals(this.rotation, categoryAxisTitle.rotation) &&
        Objects.equals(this.text, categoryAxisTitle.text) &&
        Objects.equals(this.visible, categoryAxisTitle.visible);
  }

  @Override
  public int hashCode() {
    return Objects.hash(background, border, color, font, margin, padding, position, rotation, text, visible);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CategoryAxisTitle {\n");
    sb.append("    background: ").append(toIndentedString(background)).append("\n");
    sb.append("    border: ").append(toIndentedString(border)).append("\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    font: ").append(toIndentedString(font)).append("\n");
    sb.append("    margin: ").append(toIndentedString(margin)).append("\n");
    sb.append("    padding: ").append(toIndentedString(padding)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    rotation: ").append(toIndentedString(rotation)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    visible: ").append(toIndentedString(visible)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

