/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.Country;
import travel.wink.sdk.affiliate.model.DynamicSellerListRequest;
import travel.wink.sdk.affiliate.model.GeoName;
import travel.wink.sdk.affiliate.model.PageSellerInventory;

public class DiscoverApi {
    private ApiClient apiClient;

    public DiscoverApi() {
        this(new ApiClient());
    }

    @Autowired
    public DiscoverApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showCitiesForInventoryRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCitiesForInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/city/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoName> showCitiesForInventory(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>(){};
        return this.showCitiesForInventoryRequestCreation(companyIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoName>>> showCitiesForInventoryWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>(){};
        return this.showCitiesForInventoryRequestCreation(companyIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showCountriesForInventoryRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCountriesForInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Country> localVarReturnType = new ParameterizedTypeReference<Country>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Country> showCountriesForInventory(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Country> localVarReturnType = new ParameterizedTypeReference<Country>(){};
        return this.showCountriesForInventoryRequestCreation(companyIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Country>>> showCountriesForInventoryWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Country> localVarReturnType = new ParameterizedTypeReference<Country>(){};
        return this.showCountriesForInventoryRequestCreation(companyIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showDynamicSellerInventoryRequestCreation(String companyIdentifier, DynamicSellerListRequest dynamicSellerListRequest) throws WebClientResponseException {
        DynamicSellerListRequest postBody = dynamicSellerListRequest;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dynamicSellerListRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicSellerListRequest' when calling showDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PageSellerInventory> localVarReturnType = new ParameterizedTypeReference<PageSellerInventory>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageSellerInventory> showDynamicSellerInventory(String companyIdentifier, DynamicSellerListRequest dynamicSellerListRequest) throws WebClientResponseException {
        ParameterizedTypeReference<PageSellerInventory> localVarReturnType = new ParameterizedTypeReference<PageSellerInventory>(){};
        return this.showDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageSellerInventory>> showDynamicSellerInventoryWithHttpInfo(String companyIdentifier, DynamicSellerListRequest dynamicSellerListRequest) throws WebClientResponseException {
        ParameterizedTypeReference<PageSellerInventory> localVarReturnType = new ParameterizedTypeReference<PageSellerInventory>(){};
        return this.showDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

