/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.affiliate.model.HotelOnMapLocation;

@ApiModel(description="A way to persist a GeoJSON circle")
@JsonPropertyOrder(value={"radius", "point"})
public class ConfigurableGeoJsonCircle {
    public static final String JSON_PROPERTY_RADIUS = "radius";
    private Double radius;
    public static final String JSON_PROPERTY_POINT = "point";
    private HotelOnMapLocation point;

    public ConfigurableGeoJsonCircle radius(Double radius) {
        this.radius = radius;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="2.5", required=true, value="Circle radius from center")
    @JsonProperty(value="radius")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Double getRadius() {
        return this.radius;
    }

    @JsonProperty(value="radius")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRadius(Double radius) {
        this.radius = radius;
    }

    public ConfigurableGeoJsonCircle point(HotelOnMapLocation point) {
        this.point = point;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="point")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public HotelOnMapLocation getPoint() {
        return this.point;
    }

    @JsonProperty(value="point")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPoint(HotelOnMapLocation point) {
        this.point = point;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurableGeoJsonCircle configurableGeoJsonCircle = (ConfigurableGeoJsonCircle)o;
        return Objects.equals(this.radius, configurableGeoJsonCircle.radius) && Objects.equals(this.point, configurableGeoJsonCircle.point);
    }

    public int hashCode() {
        return Objects.hash(this.radius, this.point);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConfigurableGeoJsonCircle {\n");
        sb.append("    radius: ").append(this.toIndentedString(this.radius)).append("\n");
        sb.append("    point: ").append(this.toIndentedString(this.point)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

