/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.affiliate.model.HotelOnMapLocation;

@ApiModel(description="Contains the caller's search criteria.")
@JsonPropertyOrder(value={"identifier", "ownerIdentifier", "name", "propertyName", "inventoryName", "continents", "countries", "cities", "showEcoFriendly", "showPetFriendly", "showChildFriendly", "showPopular", "showDirectOnly", "lifestyles", "hotelStars", "aggregateReviewRating", "nearPoint", "radiusInMeters", "inventoryTypes", "defaultCurrencyCode", "primaryOrderBy"})
public class DynamicSellerList {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    private UUID ownerIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROPERTY_NAME = "propertyName";
    private String propertyName;
    public static final String JSON_PROPERTY_INVENTORY_NAME = "inventoryName";
    private String inventoryName;
    public static final String JSON_PROPERTY_CONTINENTS = "continents";
    private List<String> continents = null;
    public static final String JSON_PROPERTY_COUNTRIES = "countries";
    private List<String> countries = null;
    public static final String JSON_PROPERTY_CITIES = "cities";
    private List<String> cities = null;
    public static final String JSON_PROPERTY_SHOW_ECO_FRIENDLY = "showEcoFriendly";
    private Boolean showEcoFriendly = false;
    public static final String JSON_PROPERTY_SHOW_PET_FRIENDLY = "showPetFriendly";
    private Boolean showPetFriendly = false;
    public static final String JSON_PROPERTY_SHOW_CHILD_FRIENDLY = "showChildFriendly";
    private Boolean showChildFriendly = false;
    public static final String JSON_PROPERTY_SHOW_POPULAR = "showPopular";
    private Boolean showPopular = false;
    public static final String JSON_PROPERTY_SHOW_DIRECT_ONLY = "showDirectOnly";
    private Boolean showDirectOnly = false;
    public static final String JSON_PROPERTY_LIFESTYLES = "lifestyles";
    private List<LifestylesEnum> lifestyles = null;
    public static final String JSON_PROPERTY_HOTEL_STARS = "hotelStars";
    private Integer hotelStars;
    public static final String JSON_PROPERTY_AGGREGATE_REVIEW_RATING = "aggregateReviewRating";
    private Integer aggregateReviewRating;
    public static final String JSON_PROPERTY_NEAR_POINT = "nearPoint";
    private HotelOnMapLocation nearPoint;
    public static final String JSON_PROPERTY_RADIUS_IN_METERS = "radiusInMeters";
    private Long radiusInMeters;
    public static final String JSON_PROPERTY_INVENTORY_TYPES = "inventoryTypes";
    private List<InventoryTypesEnum> inventoryTypes = null;
    public static final String JSON_PROPERTY_DEFAULT_CURRENCY_CODE = "defaultCurrencyCode";
    private String defaultCurrencyCode;
    public static final String JSON_PROPERTY_PRIMARY_ORDER_BY = "primaryOrderBy";
    private String primaryOrderBy;

    public DynamicSellerList identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique search result identifier gets populated for when you want to save your query.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public DynamicSellerList ownerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Entity identifier of record creator")
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public DynamicSellerList name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of dynamic list for when user want to persist it")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public DynamicSellerList propertyName(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Shera", value="Regex expression filter matching on property name.")
    @JsonProperty(value="propertyName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPropertyName() {
        return this.propertyName;
    }

    @JsonProperty(value="propertyName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public DynamicSellerList inventoryName(String inventoryName) {
        this.inventoryName = inventoryName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Badmint", value="Regex expression filter matching on inventory name")
    @JsonProperty(value="inventoryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInventoryName() {
        return this.inventoryName;
    }

    @JsonProperty(value="inventoryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInventoryName(String inventoryName) {
        this.inventoryName = inventoryName;
    }

    public DynamicSellerList continents(List<String> continents) {
        this.continents = continents;
        return this;
    }

    public DynamicSellerList addContinentsItem(String continentsItem) {
        if (this.continents == null) {
            this.continents = new ArrayList<String>();
        }
        this.continents.add(continentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Continent filter")
    @JsonProperty(value="continents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getContinents() {
        return this.continents;
    }

    @JsonProperty(value="continents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContinents(List<String> continents) {
        this.continents = continents;
    }

    public DynamicSellerList countries(List<String> countries) {
        this.countries = countries;
        return this;
    }

    public DynamicSellerList addCountriesItem(String countriesItem) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        this.countries.add(countriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Country filter")
    @JsonProperty(value="countries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCountries() {
        return this.countries;
    }

    @JsonProperty(value="countries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountries(List<String> countries) {
        this.countries = countries;
    }

    public DynamicSellerList cities(List<String> cities) {
        this.cities = cities;
        return this;
    }

    public DynamicSellerList addCitiesItem(String citiesItem) {
        if (this.cities == null) {
            this.cities = new ArrayList<String>();
        }
        this.cities.add(citiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="City filter")
    @JsonProperty(value="cities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCities() {
        return this.cities;
    }

    @JsonProperty(value="cities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCities(List<String> cities) {
        this.cities = cities;
    }

    public DynamicSellerList showEcoFriendly(Boolean showEcoFriendly) {
        this.showEcoFriendly = showEcoFriendly;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Filter on eco-friendly hotels")
    @JsonProperty(value="showEcoFriendly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowEcoFriendly() {
        return this.showEcoFriendly;
    }

    @JsonProperty(value="showEcoFriendly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowEcoFriendly(Boolean showEcoFriendly) {
        this.showEcoFriendly = showEcoFriendly;
    }

    public DynamicSellerList showPetFriendly(Boolean showPetFriendly) {
        this.showPetFriendly = showPetFriendly;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Filter on pet-friendly hotels")
    @JsonProperty(value="showPetFriendly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowPetFriendly() {
        return this.showPetFriendly;
    }

    @JsonProperty(value="showPetFriendly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowPetFriendly(Boolean showPetFriendly) {
        this.showPetFriendly = showPetFriendly;
    }

    public DynamicSellerList showChildFriendly(Boolean showChildFriendly) {
        this.showChildFriendly = showChildFriendly;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Filter on child-friendly hotels")
    @JsonProperty(value="showChildFriendly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowChildFriendly() {
        return this.showChildFriendly;
    }

    @JsonProperty(value="showChildFriendly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowChildFriendly(Boolean showChildFriendly) {
        this.showChildFriendly = showChildFriendly;
    }

    public DynamicSellerList showPopular(Boolean showPopular) {
        this.showPopular = showPopular;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Filter on hotel that has had a certain amount of bookings")
    @JsonProperty(value="showPopular")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowPopular() {
        return this.showPopular;
    }

    @JsonProperty(value="showPopular")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowPopular(Boolean showPopular) {
        this.showPopular = showPopular;
    }

    public DynamicSellerList showDirectOnly(Boolean showDirectOnly) {
        this.showDirectOnly = showDirectOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Filter on direct inventory")
    @JsonProperty(value="showDirectOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowDirectOnly() {
        return this.showDirectOnly;
    }

    @JsonProperty(value="showDirectOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowDirectOnly(Boolean showDirectOnly) {
        this.showDirectOnly = showDirectOnly;
    }

    public DynamicSellerList lifestyles(List<LifestylesEnum> lifestyles) {
        this.lifestyles = lifestyles;
        return this;
    }

    public DynamicSellerList addLifestylesItem(LifestylesEnum lifestylesItem) {
        if (this.lifestyles == null) {
            this.lifestyles = new ArrayList<LifestylesEnum>();
        }
        this.lifestyles.add(lifestylesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"LIFESTYLE_RELAX\"]", value="Filter on lifestyles")
    @JsonProperty(value="lifestyles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LifestylesEnum> getLifestyles() {
        return this.lifestyles;
    }

    @JsonProperty(value="lifestyles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyles(List<LifestylesEnum> lifestyles) {
        this.lifestyles = lifestyles;
    }

    public DynamicSellerList hotelStars(Integer hotelStars) {
        this.hotelStars = hotelStars;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4", value="Filter on number of stars the hotel has.")
    @JsonProperty(value="hotelStars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHotelStars() {
        return this.hotelStars;
    }

    @JsonProperty(value="hotelStars")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelStars(Integer hotelStars) {
        this.hotelStars = hotelStars;
    }

    public DynamicSellerList aggregateReviewRating(Integer aggregateReviewRating) {
        this.aggregateReviewRating = aggregateReviewRating;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7", value="Filter on aggregate review score the hotel has")
    @JsonProperty(value="aggregateReviewRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAggregateReviewRating() {
        return this.aggregateReviewRating;
    }

    @JsonProperty(value="aggregateReviewRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAggregateReviewRating(Integer aggregateReviewRating) {
        this.aggregateReviewRating = aggregateReviewRating;
    }

    public DynamicSellerList nearPoint(HotelOnMapLocation nearPoint) {
        this.nearPoint = nearPoint;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="nearPoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HotelOnMapLocation getNearPoint() {
        return this.nearPoint;
    }

    @JsonProperty(value="nearPoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNearPoint(HotelOnMapLocation nearPoint) {
        this.nearPoint = nearPoint;
    }

    public DynamicSellerList radiusInMeters(Long radiusInMeters) {
        this.radiusInMeters = radiusInMeters;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Use this in conjunction with `nearPoint`. Control the distance from point we are searching for.")
    @JsonProperty(value="radiusInMeters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRadiusInMeters() {
        return this.radiusInMeters;
    }

    @JsonProperty(value="radiusInMeters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRadiusInMeters(Long radiusInMeters) {
        this.radiusInMeters = radiusInMeters;
    }

    public DynamicSellerList inventoryTypes(List<InventoryTypesEnum> inventoryTypes) {
        this.inventoryTypes = inventoryTypes;
        return this;
    }

    public DynamicSellerList addInventoryTypesItem(InventoryTypesEnum inventoryTypesItem) {
        if (this.inventoryTypes == null) {
            this.inventoryTypes = new ArrayList<InventoryTypesEnum>();
        }
        this.inventoryTypes.add(inventoryTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"GUEST_ROOM\"]", value="Filter on inventory types")
    @JsonProperty(value="inventoryTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<InventoryTypesEnum> getInventoryTypes() {
        return this.inventoryTypes;
    }

    @JsonProperty(value="inventoryTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInventoryTypes(List<InventoryTypesEnum> inventoryTypes) {
        this.inventoryTypes = inventoryTypes;
    }

    public DynamicSellerList defaultCurrencyCode(String defaultCurrencyCode) {
        this.defaultCurrencyCode = defaultCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Control which currency you want to see prices in.")
    @JsonProperty(value="defaultCurrencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultCurrencyCode() {
        return this.defaultCurrencyCode;
    }

    @JsonProperty(value="defaultCurrencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultCurrencyCode(String defaultCurrencyCode) {
        this.defaultCurrencyCode = defaultCurrencyCode;
    }

    public DynamicSellerList primaryOrderBy(String primaryOrderBy) {
        this.primaryOrderBy = primaryOrderBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4", value="Control how you want the search results sorted. Options are:   - 1: Inventory name - 2: Price: High to low - 3: Price: Low to high - 4: Commission: High to low - 5: Commission: Low to high - 6: Discount: High to low - 7: Discount: Low to high ")
    @JsonProperty(value="primaryOrderBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrimaryOrderBy() {
        return this.primaryOrderBy;
    }

    @JsonProperty(value="primaryOrderBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrimaryOrderBy(String primaryOrderBy) {
        this.primaryOrderBy = primaryOrderBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicSellerList dynamicSellerList = (DynamicSellerList)o;
        return Objects.equals(this.identifier, dynamicSellerList.identifier) && Objects.equals(this.ownerIdentifier, dynamicSellerList.ownerIdentifier) && Objects.equals(this.name, dynamicSellerList.name) && Objects.equals(this.propertyName, dynamicSellerList.propertyName) && Objects.equals(this.inventoryName, dynamicSellerList.inventoryName) && Objects.equals(this.continents, dynamicSellerList.continents) && Objects.equals(this.countries, dynamicSellerList.countries) && Objects.equals(this.cities, dynamicSellerList.cities) && Objects.equals(this.showEcoFriendly, dynamicSellerList.showEcoFriendly) && Objects.equals(this.showPetFriendly, dynamicSellerList.showPetFriendly) && Objects.equals(this.showChildFriendly, dynamicSellerList.showChildFriendly) && Objects.equals(this.showPopular, dynamicSellerList.showPopular) && Objects.equals(this.showDirectOnly, dynamicSellerList.showDirectOnly) && Objects.equals(this.lifestyles, dynamicSellerList.lifestyles) && Objects.equals(this.hotelStars, dynamicSellerList.hotelStars) && Objects.equals(this.aggregateReviewRating, dynamicSellerList.aggregateReviewRating) && Objects.equals(this.nearPoint, dynamicSellerList.nearPoint) && Objects.equals(this.radiusInMeters, dynamicSellerList.radiusInMeters) && Objects.equals(this.inventoryTypes, dynamicSellerList.inventoryTypes) && Objects.equals(this.defaultCurrencyCode, dynamicSellerList.defaultCurrencyCode) && Objects.equals(this.primaryOrderBy, dynamicSellerList.primaryOrderBy);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.ownerIdentifier, this.name, this.propertyName, this.inventoryName, this.continents, this.countries, this.cities, this.showEcoFriendly, this.showPetFriendly, this.showChildFriendly, this.showPopular, this.showDirectOnly, this.lifestyles, this.hotelStars, this.aggregateReviewRating, this.nearPoint, this.radiusInMeters, this.inventoryTypes, this.defaultCurrencyCode, this.primaryOrderBy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DynamicSellerList {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    propertyName: ").append(this.toIndentedString(this.propertyName)).append("\n");
        sb.append("    inventoryName: ").append(this.toIndentedString(this.inventoryName)).append("\n");
        sb.append("    continents: ").append(this.toIndentedString(this.continents)).append("\n");
        sb.append("    countries: ").append(this.toIndentedString(this.countries)).append("\n");
        sb.append("    cities: ").append(this.toIndentedString(this.cities)).append("\n");
        sb.append("    showEcoFriendly: ").append(this.toIndentedString(this.showEcoFriendly)).append("\n");
        sb.append("    showPetFriendly: ").append(this.toIndentedString(this.showPetFriendly)).append("\n");
        sb.append("    showChildFriendly: ").append(this.toIndentedString(this.showChildFriendly)).append("\n");
        sb.append("    showPopular: ").append(this.toIndentedString(this.showPopular)).append("\n");
        sb.append("    showDirectOnly: ").append(this.toIndentedString(this.showDirectOnly)).append("\n");
        sb.append("    lifestyles: ").append(this.toIndentedString(this.lifestyles)).append("\n");
        sb.append("    hotelStars: ").append(this.toIndentedString(this.hotelStars)).append("\n");
        sb.append("    aggregateReviewRating: ").append(this.toIndentedString(this.aggregateReviewRating)).append("\n");
        sb.append("    nearPoint: ").append(this.toIndentedString(this.nearPoint)).append("\n");
        sb.append("    radiusInMeters: ").append(this.toIndentedString(this.radiusInMeters)).append("\n");
        sb.append("    inventoryTypes: ").append(this.toIndentedString(this.inventoryTypes)).append("\n");
        sb.append("    defaultCurrencyCode: ").append(this.toIndentedString(this.defaultCurrencyCode)).append("\n");
        sb.append("    primaryOrderBy: ").append(this.toIndentedString(this.primaryOrderBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InventoryTypesEnum {
        GUEST_ROOM("GUEST_ROOM"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        MEETING_ROOM("MEETING_ROOM"),
        RESTAURANT("RESTAURANT"),
        SPA("SPA"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE"),
        ACTIVITY("ACTIVITY");

        private String value;

        private InventoryTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InventoryTypesEnum fromValue(String value) {
            for (InventoryTypesEnum b : InventoryTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestylesEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestylesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestylesEnum fromValue(String value) {
            for (LifestylesEnum b : LifestylesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

