/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.affiliate.model.Personal;
import travel.wink.sdk.affiliate.model.Preferences;
import travel.wink.sdk.affiliate.model.ProfileUser;

@ApiModel(description="A user profile accompanies this booking IF user has created and enabled sharing of profile")
@JsonPropertyOrder(value={"profileIdentifier", "userIdentifier", "share", "user", "personal", "preferences"})
public class Profile {
    public static final String JSON_PROPERTY_PROFILE_IDENTIFIER = "profileIdentifier";
    private UUID profileIdentifier;
    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    private UUID userIdentifier;
    public static final String JSON_PROPERTY_SHARE = "share";
    private Boolean share;
    public static final String JSON_PROPERTY_USER = "user";
    private ProfileUser user;
    public static final String JSON_PROPERTY_PERSONAL = "personal";
    private Personal personal;
    public static final String JSON_PROPERTY_PREFERENCES = "preferences";
    private Preferences preferences;

    public Profile profileIdentifier(UUID profileIdentifier) {
        this.profileIdentifier = profileIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Profile identifier")
    @JsonProperty(value="profileIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getProfileIdentifier() {
        return this.profileIdentifier;
    }

    @JsonProperty(value="profileIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfileIdentifier(UUID profileIdentifier) {
        this.profileIdentifier = profileIdentifier;
    }

    public Profile userIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="User identifier")
    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public Profile share(Boolean share) {
        this.share = share;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the user wants to share this profile of themselves with hotel(s)")
    @JsonProperty(value="share")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShare() {
        return this.share;
    }

    @JsonProperty(value="share")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShare(Boolean share) {
        this.share = share;
    }

    public Profile user(ProfileUser user) {
        this.user = user;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProfileUser getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUser(ProfileUser user) {
        this.user = user;
    }

    public Profile personal(Personal personal) {
        this.personal = personal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="personal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Personal getPersonal() {
        return this.personal;
    }

    @JsonProperty(value="personal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPersonal(Personal personal) {
        this.personal = personal;
    }

    public Profile preferences(Preferences preferences) {
        this.preferences = preferences;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="preferences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Preferences getPreferences() {
        return this.preferences;
    }

    @JsonProperty(value="preferences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Profile profile = (Profile)o;
        return Objects.equals(this.profileIdentifier, profile.profileIdentifier) && Objects.equals(this.userIdentifier, profile.userIdentifier) && Objects.equals(this.share, profile.share) && Objects.equals(this.user, profile.user) && Objects.equals(this.personal, profile.personal) && Objects.equals(this.preferences, profile.preferences);
    }

    public int hashCode() {
        return Objects.hash(this.profileIdentifier, this.userIdentifier, this.share, this.user, this.personal, this.preferences);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Profile {\n");
        sb.append("    profileIdentifier: ").append(this.toIndentedString(this.profileIdentifier)).append("\n");
        sb.append("    userIdentifier: ").append(this.toIndentedString(this.userIdentifier)).append("\n");
        sb.append("    share: ").append(this.toIndentedString(this.share)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    personal: ").append(this.toIndentedString(this.personal)).append("\n");
        sb.append("    preferences: ").append(this.toIndentedString(this.preferences)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

