/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.affiliate.model.UpsertAddressRequest;

@JsonPropertyOrder(value={"name", "companyType", "type", "vatID", "description", "url", "address", "urls"})
public class UpsertCompanyRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_COMPANY_TYPE = "companyType";
    private CompanyTypeEnum companyType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_VAT_I_D = "vatID";
    private String vatID;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private UpsertAddressRequest address;
    public static final String JSON_PROPERTY_URLS = "urls";
    private List<String> urls = null;

    public UpsertCompanyRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Company 1", required=true, value="Name of company")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public UpsertCompanyRequest companyType(CompanyTypeEnum companyType) {
        this.companyType = companyType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="COMPANY", required=true, value="Type of company")
    @JsonProperty(value="companyType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CompanyTypeEnum getCompanyType() {
        return this.companyType;
    }

    @JsonProperty(value="companyType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCompanyType(CompanyTypeEnum companyType) {
        this.companyType = companyType;
    }

    public UpsertCompanyRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="APPLICATION", required=true, value="Type of company")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public UpsertCompanyRequest vatID(String vatID) {
        this.vatID = vatID;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="vat-1", required=true, value="A VAT id if required")
    @JsonProperty(value="vatID")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVatID() {
        return this.vatID;
    }

    @JsonProperty(value="vatID")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVatID(String vatID) {
        this.vatID = vatID;
    }

    public UpsertCompanyRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A personal message from the company.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public UpsertCompanyRequest url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://www.mymainsite.com", required=true, value="Company's main website")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    public UpsertCompanyRequest address(UpsertAddressRequest address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UpsertAddressRequest getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(UpsertAddressRequest address) {
        this.address = address;
    }

    public UpsertCompanyRequest urls(List<String> urls) {
        this.urls = urls;
        return this;
    }

    public UpsertCompanyRequest addUrlsItem(String urlsItem) {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        this.urls.add(urlsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of all active accounts that could be used for selling or seeing a company's reach.")
    @JsonProperty(value="urls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getUrls() {
        return this.urls;
    }

    @JsonProperty(value="urls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertCompanyRequest upsertCompanyRequest = (UpsertCompanyRequest)o;
        return Objects.equals(this.name, upsertCompanyRequest.name) && Objects.equals((Object)this.companyType, (Object)upsertCompanyRequest.companyType) && Objects.equals((Object)this.type, (Object)upsertCompanyRequest.type) && Objects.equals(this.vatID, upsertCompanyRequest.vatID) && Objects.equals(this.description, upsertCompanyRequest.description) && Objects.equals(this.url, upsertCompanyRequest.url) && Objects.equals(this.address, upsertCompanyRequest.address) && Objects.equals(this.urls, upsertCompanyRequest.urls);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.companyType, this.type, this.vatID, this.description, this.url, this.address, this.urls});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertCompanyRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    companyType: ").append(this.toIndentedString((Object)this.companyType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    vatID: ").append(this.toIndentedString(this.vatID)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    urls: ").append(this.toIndentedString(this.urls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CompanyTypeEnum {
        COMPANY("COMPANY"),
        INDIVIDUAL("INDIVIDUAL");

        private String value;

        private CompanyTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CompanyTypeEnum fromValue(String value) {
            for (CompanyTypeEnum b : CompanyTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        DIRECT("DIRECT"),
        APPLICATION("APPLICATION"),
        HOTEL("HOTEL"),
        TRAVELIKO("TRAVELIKO"),
        CORPORATE("CORPORATE"),
        TRAVEL_AGENT("TRAVEL_AGENT"),
        INFLUENCER("INFLUENCER"),
        BLOGGER("BLOGGER"),
        DESTINATION("DESTINATION");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

