/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 20.3.4-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The time-interval steps when &#x60;baseUnit&#x60; is set either to &#x60;fit&#x60; or &#x60;auto&#x60;. The axis will try to divide the active period into the smallest possible units that yield &#x60;maxDateGroups&#x60; or less discrete intervals.
 */
@ApiModel(description = "The time-interval steps when `baseUnit` is set either to `fit` or `auto`. The axis will try to divide the active period into the smallest possible units that yield `maxDateGroups` or less discrete intervals.")
@JsonPropertyOrder({
  AutoBaseUnitSteps.JSON_PROPERTY_MILLISECONDS,
  AutoBaseUnitSteps.JSON_PROPERTY_SECONDS,
  AutoBaseUnitSteps.JSON_PROPERTY_MINUTES,
  AutoBaseUnitSteps.JSON_PROPERTY_HOURS,
  AutoBaseUnitSteps.JSON_PROPERTY_DAYS,
  AutoBaseUnitSteps.JSON_PROPERTY_WEEKS,
  AutoBaseUnitSteps.JSON_PROPERTY_MONTHS,
  AutoBaseUnitSteps.JSON_PROPERTY_YEARS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-03T20:09:51.912811+07:00[Asia/Bangkok]")
public class AutoBaseUnitSteps {
  public static final String JSON_PROPERTY_MILLISECONDS = "milliseconds";
  private BigDecimal milliseconds;

  public static final String JSON_PROPERTY_SECONDS = "seconds";
  private BigDecimal seconds;

  public static final String JSON_PROPERTY_MINUTES = "minutes";
  private BigDecimal minutes;

  public static final String JSON_PROPERTY_HOURS = "hours";
  private BigDecimal hours;

  public static final String JSON_PROPERTY_DAYS = "days";
  private BigDecimal days;

  public static final String JSON_PROPERTY_WEEKS = "weeks";
  private BigDecimal weeks;

  public static final String JSON_PROPERTY_MONTHS = "months";
  private BigDecimal months;

  public static final String JSON_PROPERTY_YEARS = "years";
  private BigDecimal years;

  public AutoBaseUnitSteps() { 
  }

  public AutoBaseUnitSteps milliseconds(BigDecimal milliseconds) {
    
    this.milliseconds = milliseconds;
    return this;
  }

   /**
   * Get milliseconds
   * @return milliseconds
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MILLISECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMilliseconds() {
    return milliseconds;
  }


  @JsonProperty(JSON_PROPERTY_MILLISECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMilliseconds(BigDecimal milliseconds) {
    this.milliseconds = milliseconds;
  }


  public AutoBaseUnitSteps seconds(BigDecimal seconds) {
    
    this.seconds = seconds;
    return this;
  }

   /**
   * Get seconds
   * @return seconds
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSeconds() {
    return seconds;
  }


  @JsonProperty(JSON_PROPERTY_SECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSeconds(BigDecimal seconds) {
    this.seconds = seconds;
  }


  public AutoBaseUnitSteps minutes(BigDecimal minutes) {
    
    this.minutes = minutes;
    return this;
  }

   /**
   * Get minutes
   * @return minutes
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MINUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMinutes() {
    return minutes;
  }


  @JsonProperty(JSON_PROPERTY_MINUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinutes(BigDecimal minutes) {
    this.minutes = minutes;
  }


  public AutoBaseUnitSteps hours(BigDecimal hours) {
    
    this.hours = hours;
    return this;
  }

   /**
   * Get hours
   * @return hours
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getHours() {
    return hours;
  }


  @JsonProperty(JSON_PROPERTY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHours(BigDecimal hours) {
    this.hours = hours;
  }


  public AutoBaseUnitSteps days(BigDecimal days) {
    
    this.days = days;
    return this;
  }

   /**
   * Get days
   * @return days
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getDays() {
    return days;
  }


  @JsonProperty(JSON_PROPERTY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDays(BigDecimal days) {
    this.days = days;
  }


  public AutoBaseUnitSteps weeks(BigDecimal weeks) {
    
    this.weeks = weeks;
    return this;
  }

   /**
   * Get weeks
   * @return weeks
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_WEEKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getWeeks() {
    return weeks;
  }


  @JsonProperty(JSON_PROPERTY_WEEKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWeeks(BigDecimal weeks) {
    this.weeks = weeks;
  }


  public AutoBaseUnitSteps months(BigDecimal months) {
    
    this.months = months;
    return this;
  }

   /**
   * Get months
   * @return months
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MONTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMonths() {
    return months;
  }


  @JsonProperty(JSON_PROPERTY_MONTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMonths(BigDecimal months) {
    this.months = months;
  }


  public AutoBaseUnitSteps years(BigDecimal years) {
    
    this.years = years;
    return this;
  }

   /**
   * Get years
   * @return years
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_YEARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getYears() {
    return years;
  }


  @JsonProperty(JSON_PROPERTY_YEARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setYears(BigDecimal years) {
    this.years = years;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AutoBaseUnitSteps autoBaseUnitSteps = (AutoBaseUnitSteps) o;
    return Objects.equals(this.milliseconds, autoBaseUnitSteps.milliseconds) &&
        Objects.equals(this.seconds, autoBaseUnitSteps.seconds) &&
        Objects.equals(this.minutes, autoBaseUnitSteps.minutes) &&
        Objects.equals(this.hours, autoBaseUnitSteps.hours) &&
        Objects.equals(this.days, autoBaseUnitSteps.days) &&
        Objects.equals(this.weeks, autoBaseUnitSteps.weeks) &&
        Objects.equals(this.months, autoBaseUnitSteps.months) &&
        Objects.equals(this.years, autoBaseUnitSteps.years);
  }

  @Override
  public int hashCode() {
    return Objects.hash(milliseconds, seconds, minutes, hours, days, weeks, months, years);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AutoBaseUnitSteps {\n");
    sb.append("    milliseconds: ").append(toIndentedString(milliseconds)).append("\n");
    sb.append("    seconds: ").append(toIndentedString(seconds)).append("\n");
    sb.append("    minutes: ").append(toIndentedString(minutes)).append("\n");
    sb.append("    hours: ").append(toIndentedString(hours)).append("\n");
    sb.append("    days: ").append(toIndentedString(days)).append("\n");
    sb.append("    weeks: ").append(toIndentedString(weeks)).append("\n");
    sb.append("    months: ").append(toIndentedString(months)).append("\n");
    sb.append("    years: ").append(toIndentedString(years)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

