/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 20.3.4-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SaveEngineRequest
 */
@JsonPropertyOrder({
  SaveEngineRequest.JSON_PROPERTY_NAME,
  SaveEngineRequest.JSON_PROPERTY_REDIRECT_URIS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-03T20:09:51.912811+07:00[Asia/Bangkok]")
public class SaveEngineRequest {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_REDIRECT_URIS = "redirectUris";
  private List<String> redirectUris = null;

  public SaveEngineRequest() { 
  }

  public SaveEngineRequest name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of this engine application. The first engine for every integrator will have the same name as its company name.
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Engine 1", required = true, value = "Name of this engine application. The first engine for every integrator will have the same name as its company name.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public SaveEngineRequest redirectUris(List<String> redirectUris) {
    
    this.redirectUris = redirectUris;
    return this;
  }

  public SaveEngineRequest addRedirectUrisItem(String redirectUrisItem) {
    if (this.redirectUris == null) {
      this.redirectUris = new ArrayList<>();
    }
    this.redirectUris.add(redirectUrisItem);
    return this;
  }

   /**
   * Where to redirect after web components successfully authenticate. For OAuth2 purposes.
   * @return redirectUris
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"https://my.travel.blog\"]", value = "Where to redirect after web components successfully authenticate. For OAuth2 purposes.")
  @JsonProperty(JSON_PROPERTY_REDIRECT_URIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRedirectUris() {
    return redirectUris;
  }


  @JsonProperty(JSON_PROPERTY_REDIRECT_URIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedirectUris(List<String> redirectUris) {
    this.redirectUris = redirectUris;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SaveEngineRequest saveEngineRequest = (SaveEngineRequest) o;
    return Objects.equals(this.name, saveEngineRequest.name) &&
        Objects.equals(this.redirectUris, saveEngineRequest.redirectUris);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, redirectUris);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SaveEngineRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    redirectUris: ").append(toIndentedString(redirectUris)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

