/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.affiliate.model.RateModifier;
import travel.wink.sdk.affiliate.model.RateModifierBundleModifierOverride;
import travel.wink.sdk.affiliate.model.SimpleDescription;

@ApiModel(description="Promotion bundles for this channel")
@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "name", "enabled", "items", "modifierOverride", "type", "pricingType", "description"})
public class RateModifierBundle {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_ITEMS = "items";
    private List<RateModifier> items = null;
    public static final String JSON_PROPERTY_MODIFIER_OVERRIDE = "modifierOverride";
    private RateModifierBundleModifierOverride modifierOverride;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private List<SimpleDescription> description = null;

    public RateModifierBundle() {
    }

    @JsonCreator
    public RateModifierBundle(@JsonProperty(value="items") List<RateModifier> items) {
        this();
        this.items = items;
    }

    public RateModifierBundle identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public RateModifierBundle hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Hotel identifier.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public RateModifierBundle name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Early bird - Long Term", required=true, value="Internal name of promotion ancillary.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public RateModifierBundle enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Whether this promotion ancillary is enabled or not.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RateModifier> getItems() {
        return this.items;
    }

    public RateModifierBundle modifierOverride(RateModifierBundleModifierOverride modifierOverride) {
        this.modifierOverride = modifierOverride;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="modifierOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RateModifierBundleModifierOverride getModifierOverride() {
        return this.modifierOverride;
    }

    @JsonProperty(value="modifierOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModifierOverride(RateModifierBundleModifierOverride modifierOverride) {
        this.modifierOverride = modifierOverride;
    }

    public RateModifierBundle type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="DISCOUNT", value="Required if manual override modifier is not null")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public RateModifierBundle pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public RateModifierBundle description(List<SimpleDescription> description) {
        this.description = description;
        return this;
    }

    public RateModifierBundle addDescriptionItem(SimpleDescription descriptionItem) {
        if (this.description == null) {
            this.description = new ArrayList<SimpleDescription>();
        }
        this.description.add(descriptionItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescription> getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(List<SimpleDescription> description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RateModifierBundle rateModifierBundle = (RateModifierBundle)o;
        return Objects.equals(this.identifier, rateModifierBundle.identifier) && Objects.equals(this.hotelIdentifier, rateModifierBundle.hotelIdentifier) && Objects.equals(this.name, rateModifierBundle.name) && Objects.equals(this.enabled, rateModifierBundle.enabled) && Objects.equals(this.items, rateModifierBundle.items) && Objects.equals(this.modifierOverride, rateModifierBundle.modifierOverride) && Objects.equals((Object)this.type, (Object)rateModifierBundle.type) && Objects.equals((Object)this.pricingType, (Object)rateModifierBundle.pricingType) && Objects.equals(this.description, rateModifierBundle.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.name, this.enabled, this.items, this.modifierOverride, this.type, this.pricingType, this.description});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RateModifierBundle {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    modifierOverride: ").append(this.toIndentedString(this.modifierOverride)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        PREMIUM("PREMIUM"),
        DISCOUNT("DISCOUNT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        ADULT("PER_ADULT"),
        CHILD("PER_CHILD"),
        NIGHT("PER_NIGHT"),
        PERSON("PER_PERSON"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        HOUR("PER_HOUR"),
        PERSON_PER_STAY("PER_PERSON_PER_STAY"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_STAY("PER_ADULT_PER_STAY"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_STAY("PER_CHILD_PER_STAY"),
        USE("PER_USE"),
        PERSON_PER_USE("PER_PERSON_PER_USE");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

