/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.affiliate.model.SimpleDescription;

@JsonPropertyOrder(value={"identifier", "sellerIdentifier", "sellerInventoryItemName", "engineConfigurationIdentifier", "descriptions", "keywords", "status", "inventoryType", "channelInventoryType", "supplierIdentifier", "channelInventoryIdentifier", "multimediaIdentifiers", "animate", "animateDelay", "sort", "displayType"})
public class SellerInventoryItem {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_SELLER_IDENTIFIER = "sellerIdentifier";
    private UUID sellerIdentifier;
    public static final String JSON_PROPERTY_SELLER_INVENTORY_ITEM_NAME = "sellerInventoryItemName";
    private String sellerInventoryItemName;
    public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
    private UUID engineConfigurationIdentifier;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescription> descriptions = new ArrayList<SimpleDescription>();
    public static final String JSON_PROPERTY_KEYWORDS = "keywords";
    private List<String> keywords = new ArrayList<String>();
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.ACTIVE;
    public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
    private InventoryTypeEnum inventoryType;
    public static final String JSON_PROPERTY_CHANNEL_INVENTORY_TYPE = "channelInventoryType";
    private ChannelInventoryTypeEnum channelInventoryType;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private UUID supplierIdentifier;
    public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
    private UUID channelInventoryIdentifier;
    public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS = "multimediaIdentifiers";
    private List<String> multimediaIdentifiers = new ArrayList<String>();
    public static final String JSON_PROPERTY_ANIMATE = "animate";
    private Boolean animate = false;
    public static final String JSON_PROPERTY_ANIMATE_DELAY = "animateDelay";
    private Integer animateDelay;
    public static final String JSON_PROPERTY_SORT = "sort";
    private SortEnum sort;
    public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
    private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;

    public SellerInventoryItem identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public SellerInventoryItem sellerIdentifier(UUID sellerIdentifier) {
        this.sellerIdentifier = sellerIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Company / Owner identifier")
    @JsonProperty(value="sellerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getSellerIdentifier() {
        return this.sellerIdentifier;
    }

    @JsonProperty(value="sellerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSellerIdentifier(UUID sellerIdentifier) {
        this.sellerIdentifier = sellerIdentifier;
    }

    public SellerInventoryItem sellerInventoryItemName(String sellerInventoryItemName) {
        this.sellerInventoryItemName = sellerInventoryItemName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="My fave travel inventory", required=true, value="Descriptive name of this item for seller use")
    @JsonProperty(value="sellerInventoryItemName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSellerInventoryItemName() {
        return this.sellerInventoryItemName;
    }

    @JsonProperty(value="sellerInventoryItemName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSellerInventoryItemName(String sellerInventoryItemName) {
        this.sellerInventoryItemName = sellerInventoryItemName;
    }

    public SellerInventoryItem engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Which configuration to use with this item")
    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getEngineConfigurationIdentifier() {
        return this.engineConfigurationIdentifier;
    }

    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    }

    public SellerInventoryItem descriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public SellerInventoryItem addDescriptionsItem(SimpleDescription descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="Title and description of inventory.")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<SimpleDescription> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
    }

    public SellerInventoryItem keywords(List<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    public SellerInventoryItem addKeywordsItem(String keywordsItem) {
        this.keywords.add(keywordsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(example="[\"keyword-1\",\"keyword-2\"]", required=true, value="Keywords")
    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=0x7FFFFFFF) List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public SellerInventoryItem status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="ACTIVE", required=true, value="Availability status")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public SellerInventoryItem inventoryType(InventoryTypeEnum inventoryType) {
        this.inventoryType = inventoryType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="HOTEL", required=true, value="The type of inventory being offer up for sale")
    @JsonProperty(value="inventoryType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public InventoryTypeEnum getInventoryType() {
        return this.inventoryType;
    }

    @JsonProperty(value="inventoryType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInventoryType(InventoryTypeEnum inventoryType) {
        this.inventoryType = inventoryType;
    }

    public SellerInventoryItem channelInventoryType(ChannelInventoryTypeEnum channelInventoryType) {
        this.channelInventoryType = channelInventoryType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="GUEST_ROOM", required=true, value="Channel inventory type is a subset of inventory type in that it does not include the `HOTEL` type. THe way it works is, as a seller you might want to sell a guest room but instead of showing the price of that guest room, you would like to display the best room type price for the property.")
    @JsonProperty(value="channelInventoryType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ChannelInventoryTypeEnum getChannelInventoryType() {
        return this.channelInventoryType;
    }

    @JsonProperty(value="channelInventoryType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChannelInventoryType(ChannelInventoryTypeEnum channelInventoryType) {
        this.channelInventoryType = channelInventoryType;
    }

    public SellerInventoryItem supplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Supplier / Hotel identifier that owns this inventory.")
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    public SellerInventoryItem channelInventoryIdentifier(UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The channel inventory record identifier describing the relationship between supplier and seller.")
    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getChannelInventoryIdentifier() {
        return this.channelInventoryIdentifier;
    }

    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChannelInventoryIdentifier(UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
    }

    public SellerInventoryItem multimediaIdentifiers(List<String> multimediaIdentifiers) {
        this.multimediaIdentifiers = multimediaIdentifiers;
        return this;
    }

    public SellerInventoryItem addMultimediaIdentifiersItem(String multimediaIdentifiersItem) {
        this.multimediaIdentifiers.add(multimediaIdentifiersItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(example="[\"cloudinary-image-1\",\"cloudinary-image-2\"]", required=true, value="Reference identifiers to Cloudinary media assets")
    @JsonProperty(value="multimediaIdentifiers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=0x7FFFFFFF) List<String> getMultimediaIdentifiers() {
        return this.multimediaIdentifiers;
    }

    @JsonProperty(value="multimediaIdentifiers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimediaIdentifiers(List<String> multimediaIdentifiers) {
        this.multimediaIdentifiers = multimediaIdentifiers;
    }

    public SellerInventoryItem animate(Boolean animate) {
        this.animate = animate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Create an animated gif instead of a list of images. Feature currently not available. Feel free to enable and it will become available at a later date.")
    @JsonProperty(value="animate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAnimate() {
        return this.animate;
    }

    @JsonProperty(value="animate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnimate(Boolean animate) {
        this.animate = animate;
    }

    public SellerInventoryItem animateDelay(Integer animateDelay) {
        this.animateDelay = animateDelay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="500", value="Controls animation delay in milliseconds.")
    @JsonProperty(value="animateDelay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAnimateDelay() {
        return this.animateDelay;
    }

    @JsonProperty(value="animateDelay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnimateDelay(Integer animateDelay) {
        this.animateDelay = animateDelay;
    }

    public SellerInventoryItem sort(SortEnum sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="POPULARITY", value="The specific badge to display over the image on the Web Component.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SortEnum getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(SortEnum sort) {
        this.sort = sort;
    }

    public SellerInventoryItem displayType(DisplayTypeEnum displayType) {
        this.displayType = displayType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="NATIVE", required=true, value="Indicate which initial values to display first on the front-facing card")
    @JsonProperty(value="displayType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DisplayTypeEnum getDisplayType() {
        return this.displayType;
    }

    @JsonProperty(value="displayType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayType(DisplayTypeEnum displayType) {
        this.displayType = displayType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SellerInventoryItem sellerInventoryItem = (SellerInventoryItem)o;
        return Objects.equals(this.identifier, sellerInventoryItem.identifier) && Objects.equals(this.sellerIdentifier, sellerInventoryItem.sellerIdentifier) && Objects.equals(this.sellerInventoryItemName, sellerInventoryItem.sellerInventoryItemName) && Objects.equals(this.engineConfigurationIdentifier, sellerInventoryItem.engineConfigurationIdentifier) && Objects.equals(this.descriptions, sellerInventoryItem.descriptions) && Objects.equals(this.keywords, sellerInventoryItem.keywords) && Objects.equals((Object)this.status, (Object)sellerInventoryItem.status) && Objects.equals((Object)this.inventoryType, (Object)sellerInventoryItem.inventoryType) && Objects.equals((Object)this.channelInventoryType, (Object)sellerInventoryItem.channelInventoryType) && Objects.equals(this.supplierIdentifier, sellerInventoryItem.supplierIdentifier) && Objects.equals(this.channelInventoryIdentifier, sellerInventoryItem.channelInventoryIdentifier) && Objects.equals(this.multimediaIdentifiers, sellerInventoryItem.multimediaIdentifiers) && Objects.equals(this.animate, sellerInventoryItem.animate) && Objects.equals(this.animateDelay, sellerInventoryItem.animateDelay) && Objects.equals((Object)this.sort, (Object)sellerInventoryItem.sort) && Objects.equals((Object)this.displayType, (Object)sellerInventoryItem.displayType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.sellerIdentifier, this.sellerInventoryItemName, this.engineConfigurationIdentifier, this.descriptions, this.keywords, this.status, this.inventoryType, this.channelInventoryType, this.supplierIdentifier, this.channelInventoryIdentifier, this.multimediaIdentifiers, this.animate, this.animateDelay, this.sort, this.displayType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SellerInventoryItem {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    sellerIdentifier: ").append(this.toIndentedString(this.sellerIdentifier)).append("\n");
        sb.append("    sellerInventoryItemName: ").append(this.toIndentedString(this.sellerInventoryItemName)).append("\n");
        sb.append("    engineConfigurationIdentifier: ").append(this.toIndentedString(this.engineConfigurationIdentifier)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    inventoryType: ").append(this.toIndentedString((Object)this.inventoryType)).append("\n");
        sb.append("    channelInventoryType: ").append(this.toIndentedString((Object)this.channelInventoryType)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    channelInventoryIdentifier: ").append(this.toIndentedString(this.channelInventoryIdentifier)).append("\n");
        sb.append("    multimediaIdentifiers: ").append(this.toIndentedString(this.multimediaIdentifiers)).append("\n");
        sb.append("    animate: ").append(this.toIndentedString(this.animate)).append("\n");
        sb.append("    animateDelay: ").append(this.toIndentedString(this.animateDelay)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString((Object)this.sort)).append("\n");
        sb.append("    displayType: ").append(this.toIndentedString((Object)this.displayType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE"),
        REMOVED("REMOVED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DisplayTypeEnum {
        NATIVE("NATIVE"),
        HOTEL("HOTEL"),
        ROOM("ROOM");

        private String value;

        private DisplayTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DisplayTypeEnum fromValue(String value) {
            for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum InventoryTypeEnum {
        HOTEL("HOTEL"),
        GUEST_ROOM("GUEST_ROOM"),
        MEETING_ROOM("MEETING_ROOM"),
        RESTAURANT("RESTAURANT"),
        SPA("SPA"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        ATTRACTION("ATTRACTION"),
        ACTIVITY("ACTIVITY"),
        PLACE("PLACE");

        private String value;

        private InventoryTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InventoryTypeEnum fromValue(String value) {
            for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChannelInventoryTypeEnum {
        GUEST_ROOM("GUEST_ROOM"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        MEETING_ROOM("MEETING_ROOM"),
        RESTAURANT("RESTAURANT"),
        SPA("SPA"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE"),
        ACTIVITY("ACTIVITY");

        private String value;

        private ChannelInventoryTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChannelInventoryTypeEnum fromValue(String value) {
            for (ChannelInventoryTypeEnum b : ChannelInventoryTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SortEnum {
        MEMBER("MEMBER"),
        PRICE_LOW_TO_HIGH("PRICE_LOW_TO_HIGH"),
        PRICE_HIGH_TO_LOW("PRICE_HIGH_TO_LOW"),
        PRICE("PRICE"),
        POPULARITY("POPULARITY"),
        ECO("ECO"),
        EXPERIENCE("EXPERIENCE"),
        PERK("PERK"),
        LOYALTY("LOYALTY"),
        PACKAGE("PACKAGE");

        private String value;

        private SortEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SortEnum fromValue(String value) {
            for (SortEnum b : SortEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

