/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 21.2.8-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.affiliate.model.UpsertAddressRequest;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertCompanyRequest
 */
@JsonPropertyOrder({
  UpsertCompanyRequest.JSON_PROPERTY_NAME,
  UpsertCompanyRequest.JSON_PROPERTY_LEGAL_NAME,
  UpsertCompanyRequest.JSON_PROPERTY_COMPANY_TYPE,
  UpsertCompanyRequest.JSON_PROPERTY_TYPE,
  UpsertCompanyRequest.JSON_PROPERTY_VAT_I_D,
  UpsertCompanyRequest.JSON_PROPERTY_DESCRIPTION,
  UpsertCompanyRequest.JSON_PROPERTY_URL,
  UpsertCompanyRequest.JSON_PROPERTY_ADDRESS,
  UpsertCompanyRequest.JSON_PROPERTY_URLS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-21T13:34:06.734669+07:00[Asia/Bangkok]")
public class UpsertCompanyRequest {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
  private String legalName;

  /**
   * Type of company
   */
  public enum CompanyTypeEnum {
    COMPANY("COMPANY"),
    
    INDIVIDUAL("INDIVIDUAL");

    private String value;

    CompanyTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CompanyTypeEnum fromValue(String value) {
      for (CompanyTypeEnum b : CompanyTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_COMPANY_TYPE = "companyType";
  private CompanyTypeEnum companyType;

  /**
   * Type of company
   */
  public enum TypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_VAT_I_D = "vatID";
  private String vatID;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private UpsertAddressRequest address;

  public static final String JSON_PROPERTY_URLS = "urls";
  private List<String> urls = null;

  public UpsertCompanyRequest() { 
  }

  public UpsertCompanyRequest name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of company
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Company 1", required = true, value = "Name of company")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public UpsertCompanyRequest legalName(String legalName) {
    
    this.legalName = legalName;
    return this;
  }

   /**
   * Legal name of entity if other than name
   * @return legalName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Legal Company 1", value = "Legal name of entity if other than name")
  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLegalName() {
    return legalName;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalName(String legalName) {
    this.legalName = legalName;
  }


  public UpsertCompanyRequest companyType(CompanyTypeEnum companyType) {
    
    this.companyType = companyType;
    return this;
  }

   /**
   * Type of company
   * @return companyType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "COMPANY", required = true, value = "Type of company")
  @JsonProperty(JSON_PROPERTY_COMPANY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CompanyTypeEnum getCompanyType() {
    return companyType;
  }


  @JsonProperty(JSON_PROPERTY_COMPANY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCompanyType(CompanyTypeEnum companyType) {
    this.companyType = companyType;
  }


  public UpsertCompanyRequest type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of company
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "APPLICATION", required = true, value = "Type of company")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public UpsertCompanyRequest vatID(String vatID) {
    
    this.vatID = vatID;
    return this;
  }

   /**
   * A VAT id if required
   * @return vatID
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "vat-1", required = true, value = "A VAT id if required")
  @JsonProperty(JSON_PROPERTY_VAT_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getVatID() {
    return vatID;
  }


  @JsonProperty(JSON_PROPERTY_VAT_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVatID(String vatID) {
    this.vatID = vatID;
  }


  public UpsertCompanyRequest description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * A personal message from the company.
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A personal message from the company.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public UpsertCompanyRequest url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * Company&#39;s main website
   * @return url
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "https://www.mymainsite.com", required = true, value = "Company's main website")
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrl(String url) {
    this.url = url;
  }


  public UpsertCompanyRequest address(UpsertAddressRequest address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UpsertAddressRequest getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(UpsertAddressRequest address) {
    this.address = address;
  }


  public UpsertCompanyRequest urls(List<String> urls) {
    
    this.urls = urls;
    return this;
  }

  public UpsertCompanyRequest addUrlsItem(String urlsItem) {
    if (this.urls == null) {
      this.urls = new ArrayList<>();
    }
    this.urls.add(urlsItem);
    return this;
  }

   /**
   * List of all active accounts that could be used for selling or seeing a company&#39;s reach.
   * @return urls
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of all active accounts that could be used for selling or seeing a company's reach.")
  @JsonProperty(JSON_PROPERTY_URLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getUrls() {
    return urls;
  }


  @JsonProperty(JSON_PROPERTY_URLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrls(List<String> urls) {
    this.urls = urls;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertCompanyRequest upsertCompanyRequest = (UpsertCompanyRequest) o;
    return Objects.equals(this.name, upsertCompanyRequest.name) &&
        Objects.equals(this.legalName, upsertCompanyRequest.legalName) &&
        Objects.equals(this.companyType, upsertCompanyRequest.companyType) &&
        Objects.equals(this.type, upsertCompanyRequest.type) &&
        Objects.equals(this.vatID, upsertCompanyRequest.vatID) &&
        Objects.equals(this.description, upsertCompanyRequest.description) &&
        Objects.equals(this.url, upsertCompanyRequest.url) &&
        Objects.equals(this.address, upsertCompanyRequest.address) &&
        Objects.equals(this.urls, upsertCompanyRequest.urls);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, legalName, companyType, type, vatID, description, url, address, urls);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertCompanyRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    legalName: ").append(toIndentedString(legalName)).append("\n");
    sb.append("    companyType: ").append(toIndentedString(companyType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    vatID: ").append(toIndentedString(vatID)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    urls: ").append(toIndentedString(urls)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

