package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.AdvancedMapConfiguration;
import travel.wink.sdk.affiliate.model.AdvancedMapConfigurationView;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.InventoryMapMarker;
import travel.wink.sdk.affiliate.model.RemoveEntryResponse;
import travel.wink.sdk.affiliate.model.ShowSellerUrl400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-07T09:36:28.361266+07:00[Asia/Bangkok]")
public class MapsApi {
    private ApiClient apiClient;

    public MapsApi() {
        this(new ApiClient());
    }

    @Autowired
    public MapsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Map
     * Create a new advanced map configuration
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Create map owned by this owner identifier.
     * @param advancedMapConfiguration The advancedMapConfiguration parameter
     * @return AdvancedMapConfigurationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAdvancedMapConfigurationRequestCreation(String companyIdentifier, AdvancedMapConfiguration advancedMapConfiguration) throws WebClientResponseException {
        Object postBody = advancedMapConfiguration;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'advancedMapConfiguration' is set
        if (advancedMapConfiguration == null) {
            throw new WebClientResponseException("Missing the required parameter 'advancedMapConfiguration' when calling createAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/map", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Map
     * Create a new advanced map configuration
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Create map owned by this owner identifier.
     * @param advancedMapConfiguration The advancedMapConfiguration parameter
     * @return AdvancedMapConfigurationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AdvancedMapConfigurationView> createAdvancedMapConfiguration(String companyIdentifier, AdvancedMapConfiguration advancedMapConfiguration) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>() {};
        return createAdvancedMapConfigurationRequestCreation(companyIdentifier, advancedMapConfiguration).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationView>> createAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, AdvancedMapConfiguration advancedMapConfiguration) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>() {};
        return createAdvancedMapConfigurationRequestCreation(companyIdentifier, advancedMapConfiguration).toEntity(localVarReturnType);
    }
    /**
     * Delete Map
     * Remove an advanced map configuration
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove map owned by this owner identifier.
     * @param mapIdentifier Remove map record with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAdvancedMapConfigurationRequestCreation(String companyIdentifier, String mapIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'mapIdentifier' is set
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling removeAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("mapIdentifier", mapIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/map/{mapIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Map
     * Remove an advanced map configuration
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove map owned by this owner identifier.
     * @param mapIdentifier Remove map record with this identifier.
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeAdvancedMapConfiguration(String companyIdentifier, String mapIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, String mapIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Map
     * Retrieve a specific map record
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show map record owned by this owner identifier.
     * @param mapIdentifier Show map record with this identifier.
     * @param accept The accept parameter
     * @return AdvancedMapConfigurationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAdvancedMapConfigurationRequestCreation(String companyIdentifier, String mapIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'mapIdentifier' is set
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling showAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("mapIdentifier", mapIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/map/{mapIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Map
     * Retrieve a specific map record
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show map record owned by this owner identifier.
     * @param mapIdentifier Show map record with this identifier.
     * @param accept The accept parameter
     * @return AdvancedMapConfigurationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AdvancedMapConfigurationView> showAdvancedMapConfiguration(String companyIdentifier, String mapIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>() {};
        return showAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationView>> showAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, String mapIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>() {};
        return showAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Map Marker
     * Retrieve map marker for individual channel inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show map markers for map owned by this owner identifier.
     * @param channelInventoryIdentifier Show map marker for specific inventory.
     * @param accept The accept parameter
     * @return InventoryMapMarker
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAdvancedMapConfigurationMapMarkerRequestCreation(String companyIdentifier, String channelInventoryIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfigurationMapMarker", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'channelInventoryIdentifier' is set
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showAdvancedMapConfigurationMapMarker", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<InventoryMapMarker> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarker>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/map/marker/{channelInventoryIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Map Marker
     * Retrieve map marker for individual channel inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show map markers for map owned by this owner identifier.
     * @param channelInventoryIdentifier Show map marker for specific inventory.
     * @param accept The accept parameter
     * @return InventoryMapMarker
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryMapMarker> showAdvancedMapConfigurationMapMarker(String companyIdentifier, String channelInventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarker> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarker>() {};
        return showAdvancedMapConfigurationMapMarkerRequestCreation(companyIdentifier, channelInventoryIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryMapMarker>> showAdvancedMapConfigurationMapMarkerWithHttpInfo(String companyIdentifier, String channelInventoryIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarker> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarker>() {};
        return showAdvancedMapConfigurationMapMarkerRequestCreation(companyIdentifier, channelInventoryIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Map Markers
     * Retrieve a list of advanced map configuration inventory markers by type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show map markers for list owned by this owner identifier.
     * @param listIdentifier Show map markers for list.
     * @param listType Indicate whether this list is a curated or dynamic list.
     * @param accept The accept parameter
     * @return List&lt;InventoryMapMarker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAdvancedMapConfigurationMapMarkersRequestCreation(String companyIdentifier, String listIdentifier, String listType, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfigurationMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showAdvancedMapConfigurationMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listType' is set
        if (listType == null) {
            throw new WebClientResponseException("Missing the required parameter 'listType' when calling showAdvancedMapConfigurationMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("listType", listType);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<InventoryMapMarker> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarker>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/map/markers/{listType}/{listIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Map Markers
     * Retrieve a list of advanced map configuration inventory markers by type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show map markers for list owned by this owner identifier.
     * @param listIdentifier Show map markers for list.
     * @param listType Indicate whether this list is a curated or dynamic list.
     * @param accept The accept parameter
     * @return List&lt;InventoryMapMarker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<InventoryMapMarker> showAdvancedMapConfigurationMapMarkers(String companyIdentifier, String listIdentifier, String listType, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarker> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarker>() {};
        return showAdvancedMapConfigurationMapMarkersRequestCreation(companyIdentifier, listIdentifier, listType, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventoryMapMarker>>> showAdvancedMapConfigurationMapMarkersWithHttpInfo(String companyIdentifier, String listIdentifier, String listType, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarker> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarker>() {};
        return showAdvancedMapConfigurationMapMarkersRequestCreation(companyIdentifier, listIdentifier, listType, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Maps
     * Retrieve list of existing maps.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List maps owned by this owner identifier.
     * @param accept The accept parameter
     * @return List&lt;AdvancedMapConfigurationView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAdvancedMapConfigurationsRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAdvancedMapConfigurations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/map", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Maps
     * Retrieve list of existing maps.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List maps owned by this owner identifier.
     * @param accept The accept parameter
     * @return List&lt;AdvancedMapConfigurationView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<AdvancedMapConfigurationView> showAdvancedMapConfigurations(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>() {};
        return showAdvancedMapConfigurationsRequestCreation(companyIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<AdvancedMapConfigurationView>>> showAdvancedMapConfigurationsWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>() {};
        return showAdvancedMapConfigurationsRequestCreation(companyIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Update Map
     * Update an advanced map configuration
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update map owned by this owner identifier.
     * @param mapIdentifier update map record with this identifier.
     * @param advancedMapConfiguration The advancedMapConfiguration parameter
     * @return AdvancedMapConfigurationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAdvancedMapConfigurationRequestCreation(String companyIdentifier, String mapIdentifier, AdvancedMapConfiguration advancedMapConfiguration) throws WebClientResponseException {
        Object postBody = advancedMapConfiguration;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'mapIdentifier' is set
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling updateAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'advancedMapConfiguration' is set
        if (advancedMapConfiguration == null) {
            throw new WebClientResponseException("Missing the required parameter 'advancedMapConfiguration' when calling updateAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("mapIdentifier", mapIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/map/{mapIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Map
     * Update an advanced map configuration
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update map owned by this owner identifier.
     * @param mapIdentifier update map record with this identifier.
     * @param advancedMapConfiguration The advancedMapConfiguration parameter
     * @return AdvancedMapConfigurationView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AdvancedMapConfigurationView> updateAdvancedMapConfiguration(String companyIdentifier, String mapIdentifier, AdvancedMapConfiguration advancedMapConfiguration) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>() {};
        return updateAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, advancedMapConfiguration).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationView>> updateAdvancedMapConfigurationWithHttpInfo(String companyIdentifier, String mapIdentifier, AdvancedMapConfiguration advancedMapConfiguration) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationView> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationView>() {};
        return updateAdvancedMapConfigurationRequestCreation(companyIdentifier, mapIdentifier, advancedMapConfiguration).toEntity(localVarReturnType);
    }
}
