/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 21.4.3-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.SimpleDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Multimedia
 */
@ApiModel(description = "Multimedia")
@JsonPropertyOrder({
  Multimedia.JSON_PROPERTY_MULTIMEDIA_IDENTIFIER,
  Multimedia.JSON_PROPERTY_IDENTIFIER,
  Multimedia.JSON_PROPERTY_HOTEL_IDENTIFIER,
  Multimedia.JSON_PROPERTY_TYPE,
  Multimedia.JSON_PROPERTY_SOURCE,
  Multimedia.JSON_PROPERTY_SORT,
  Multimedia.JSON_PROPERTY_PUBLISHED,
  Multimedia.JSON_PROPERTY_CATEGORY,
  Multimedia.JSON_PROPERTY_CAPTIONS,
  Multimedia.JSON_PROPERTY_LIFESTYLE_TYPE,
  Multimedia.JSON_PROPERTY_ANGLE,
  Multimedia.JSON_PROPERTY_WIDTH,
  Multimedia.JSON_PROPERTY_HEIGHT,
  Multimedia.JSON_PROPERTY_IS_LANDSCAPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-07T09:36:28.361266+07:00[Asia/Bangkok]")
public class Multimedia {
  public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
  private UUID multimediaIdentifier;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  /**
   * Whether Cloudinary media is a VIDEO or IMAGE.
   */
  public enum TypeEnum {
    IMAGE("IMAGE"),
    
    VIDEO("VIDEO");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * Currently ONLY using Cloudinary to store all image / video assets.
   */
  public enum SourceEnum {
    YOUTUBE("YOUTUBE"),
    
    CLOUDINARY("CLOUDINARY");

    private String value;

    SourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SourceEnum fromValue(String value) {
      for (SourceEnum b : SourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SOURCE = "source";
  private SourceEnum source = SourceEnum.CLOUDINARY;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort = 999;

  public static final String JSON_PROPERTY_PUBLISHED = "published";
  private Boolean published = false;

  public static final String JSON_PROPERTY_CATEGORY = "category";
  private String category;

  public static final String JSON_PROPERTY_CAPTIONS = "captions";
  private List<SimpleDescription> captions = null;

  /**
   * Associate this media with a specific lifestyle type. A user searching and filtering inventory based on lifestyles can be shown relevant media first.
   */
  public enum LifestyleTypeEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypeEnum fromValue(String value) {
      for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
  private LifestyleTypeEnum lifestyleType;

  public static final String JSON_PROPERTY_ANGLE = "angle";
  private String angle;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Integer width;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Integer height;

  public static final String JSON_PROPERTY_IS_LANDSCAPE = "isLandscape";
  private Boolean isLandscape;

  public Multimedia() { 
  }

  public Multimedia multimediaIdentifier(UUID multimediaIdentifier) {
    
    this.multimediaIdentifier = multimediaIdentifier;
    return this;
  }

   /**
   * Document identifier
   * @return multimediaIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Document identifier")
  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getMultimediaIdentifier() {
    return multimediaIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMultimediaIdentifier(UUID multimediaIdentifier) {
    this.multimediaIdentifier = multimediaIdentifier;
  }


  public Multimedia identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Use this identifier to communicate with Cloudinary.
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "cloudinary-image-1", value = "Use this identifier to communicate with Cloudinary.")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public Multimedia hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Owner identifier of property that owns the multimedia record.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Owner identifier of property that owns the multimedia record.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public Multimedia type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Whether Cloudinary media is a VIDEO or IMAGE.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "IMAGE", value = "Whether Cloudinary media is a VIDEO or IMAGE.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public Multimedia source(SourceEnum source) {
    
    this.source = source;
    return this;
  }

   /**
   * Currently ONLY using Cloudinary to store all image / video assets.
   * @return source
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "CLOUDINARY", value = "Currently ONLY using Cloudinary to store all image / video assets.")
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SourceEnum getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSource(SourceEnum source) {
    this.source = source;
  }


  public Multimedia sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Sort allows you to control how you want to sort this record in a list of media records.
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "Sort allows you to control how you want to sort this record in a list of media records.")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public Multimedia published(Boolean published) {
    
    this.published = published;
    return this;
  }

   /**
   * Instead of deleting the media, choose to un-publish it instead for later re-use. Could be you keep seasonal images of the property.
   * @return published
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Instead of deleting the media, choose to un-publish it instead for later re-use. Could be you keep seasonal images of the property.")
  @JsonProperty(JSON_PROPERTY_PUBLISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPublished() {
    return published;
  }


  @JsonProperty(JSON_PROPERTY_PUBLISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPublished(Boolean published) {
    this.published = published;
  }


  public Multimedia category(String category) {
    
    this.category = category;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PIC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return category
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "Supported OTA specification `PIC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCategory() {
    return category;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategory(String category) {
    this.category = category;
  }


  public Multimedia captions(List<SimpleDescription> captions) {
    
    this.captions = captions;
    return this;
  }

  public Multimedia addCaptionsItem(SimpleDescription captionsItem) {
    if (this.captions == null) {
      this.captions = new ArrayList<>();
    }
    this.captions.add(captionsItem);
    return this;
  }

   /**
   * Localized media captions to give user some context about where this media was taken.
   * @return captions
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Localized media captions to give user some context about where this media was taken.")
  @JsonProperty(JSON_PROPERTY_CAPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescription> getCaptions() {
    return captions;
  }


  @JsonProperty(JSON_PROPERTY_CAPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptions(List<SimpleDescription> captions) {
    this.captions = captions;
  }


  public Multimedia lifestyleType(LifestyleTypeEnum lifestyleType) {
    
    this.lifestyleType = lifestyleType;
    return this;
  }

   /**
   * Associate this media with a specific lifestyle type. A user searching and filtering inventory based on lifestyles can be shown relevant media first.
   * @return lifestyleType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "LIFESTYLE_HEALTH_FITNESS", value = "Associate this media with a specific lifestyle type. A user searching and filtering inventory based on lifestyles can be shown relevant media first.")
  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleTypeEnum getLifestyleType() {
    return lifestyleType;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
    this.lifestyleType = lifestyleType;
  }


  public Multimedia angle(String angle) {
    
    this.angle = angle;
    return this;
  }

   /**
   * Media angle
   * @return angle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "-90", value = "Media angle")
  @JsonProperty(JSON_PROPERTY_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAngle() {
    return angle;
  }


  @JsonProperty(JSON_PROPERTY_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAngle(String angle) {
    this.angle = angle;
  }


  public Multimedia width(Integer width) {
    
    this.width = width;
    return this;
  }

   /**
   * Media width in pixels.
   * @return width
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2560", value = "Media width in pixels.")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWidth(Integer width) {
    this.width = width;
  }


  public Multimedia height(Integer height) {
    
    this.height = height;
    return this;
  }

   /**
   * Media height in pixels.
   * @return height
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1600", value = "Media height in pixels.")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeight(Integer height) {
    this.height = height;
  }


  public Multimedia isLandscape(Boolean isLandscape) {
    
    this.isLandscape = isLandscape;
    return this;
  }

   /**
   * True if media width is greater or equal to height
   * @return isLandscape
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "True if media width is greater or equal to height")
  @JsonProperty(JSON_PROPERTY_IS_LANDSCAPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsLandscape() {
    return isLandscape;
  }


  @JsonProperty(JSON_PROPERTY_IS_LANDSCAPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsLandscape(Boolean isLandscape) {
    this.isLandscape = isLandscape;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Multimedia multimedia = (Multimedia) o;
    return Objects.equals(this.multimediaIdentifier, multimedia.multimediaIdentifier) &&
        Objects.equals(this.identifier, multimedia.identifier) &&
        Objects.equals(this.hotelIdentifier, multimedia.hotelIdentifier) &&
        Objects.equals(this.type, multimedia.type) &&
        Objects.equals(this.source, multimedia.source) &&
        Objects.equals(this.sort, multimedia.sort) &&
        Objects.equals(this.published, multimedia.published) &&
        Objects.equals(this.category, multimedia.category) &&
        Objects.equals(this.captions, multimedia.captions) &&
        Objects.equals(this.lifestyleType, multimedia.lifestyleType) &&
        Objects.equals(this.angle, multimedia.angle) &&
        Objects.equals(this.width, multimedia.width) &&
        Objects.equals(this.height, multimedia.height) &&
        Objects.equals(this.isLandscape, multimedia.isLandscape);
  }

  @Override
  public int hashCode() {
    return Objects.hash(multimediaIdentifier, identifier, hotelIdentifier, type, source, sort, published, category, captions, lifestyleType, angle, width, height, isLandscape);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Multimedia {\n");
    sb.append("    multimediaIdentifier: ").append(toIndentedString(multimediaIdentifier)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    published: ").append(toIndentedString(published)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    captions: ").append(toIndentedString(captions)).append("\n");
    sb.append("    lifestyleType: ").append(toIndentedString(lifestyleType)).append("\n");
    sb.append("    angle: ").append(toIndentedString(angle)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    isLandscape: ").append(toIndentedString(isLandscape)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

