/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 21.4.3-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.RateModifier;
import travel.wink.sdk.affiliate.model.RateModifierBundleModifierOverride;
import travel.wink.sdk.affiliate.model.SimpleDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Promotion bundles for this channel
 */
@ApiModel(description = "Promotion bundles for this channel")
@JsonPropertyOrder({
  RateModifierBundle.JSON_PROPERTY_IDENTIFIER,
  RateModifierBundle.JSON_PROPERTY_HOTEL_IDENTIFIER,
  RateModifierBundle.JSON_PROPERTY_NAME,
  RateModifierBundle.JSON_PROPERTY_ENABLED,
  RateModifierBundle.JSON_PROPERTY_ITEMS,
  RateModifierBundle.JSON_PROPERTY_MODIFIER_OVERRIDE,
  RateModifierBundle.JSON_PROPERTY_TYPE,
  RateModifierBundle.JSON_PROPERTY_PRICING_TYPE,
  RateModifierBundle.JSON_PROPERTY_DESCRIPTION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-07T09:36:28.361266+07:00[Asia/Bangkok]")
public class RateModifierBundle {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_ITEMS = "items";
  private List<RateModifier> items = null;

  public static final String JSON_PROPERTY_MODIFIER_OVERRIDE = "modifierOverride";
  private RateModifierBundleModifierOverride modifierOverride;

  /**
   * Required if manual override modifier is not null
   */
  public enum TypeEnum {
    PREMIUM("PREMIUM"),
    
    DISCOUNT("DISCOUNT");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    ADULT("PER_ADULT"),
    
    CHILD("PER_CHILD"),
    
    NIGHT("PER_NIGHT"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    HOUR("PER_HOUR"),
    
    PERSON_PER_STAY("PER_PERSON_PER_STAY"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_STAY("PER_ADULT_PER_STAY"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_STAY("PER_CHILD_PER_STAY"),
    
    USE("PER_USE"),
    
    PERSON_PER_USE("PER_PERSON_PER_USE");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private List<SimpleDescription> description = null;

  public RateModifierBundle() { 
  }

  @JsonCreator
  public RateModifierBundle(
    @JsonProperty(JSON_PROPERTY_ITEMS) List<RateModifier> items
  ) {
    this();
    this.items = items;
  }

  public RateModifierBundle identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Unique record identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public RateModifierBundle hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Hotel identifier.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public RateModifierBundle name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of promotion ancillary.
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Early bird - Long Term", required = true, value = "Internal name of promotion ancillary.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public RateModifierBundle enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this promotion ancillary is enabled or not.
   * @return enabled
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Whether this promotion ancillary is enabled or not.")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


   /**
   * Get items
   * @return items
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RateModifier> getItems() {
    return items;
  }




  public RateModifierBundle modifierOverride(RateModifierBundleModifierOverride modifierOverride) {
    
    this.modifierOverride = modifierOverride;
    return this;
  }

   /**
   * Get modifierOverride
   * @return modifierOverride
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MODIFIER_OVERRIDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RateModifierBundleModifierOverride getModifierOverride() {
    return modifierOverride;
  }


  @JsonProperty(JSON_PROPERTY_MODIFIER_OVERRIDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModifierOverride(RateModifierBundleModifierOverride modifierOverride) {
    this.modifierOverride = modifierOverride;
  }


  public RateModifierBundle type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Required if manual override modifier is not null
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "DISCOUNT", value = "Required if manual override modifier is not null")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public RateModifierBundle pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null
   * @return pricingType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null")
  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public RateModifierBundle description(List<SimpleDescription> description) {
    
    this.description = description;
    return this;
  }

  public RateModifierBundle addDescriptionItem(SimpleDescription descriptionItem) {
    if (this.description == null) {
      this.description = new ArrayList<>();
    }
    this.description.add(descriptionItem);
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescription> getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(List<SimpleDescription> description) {
    this.description = description;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RateModifierBundle rateModifierBundle = (RateModifierBundle) o;
    return Objects.equals(this.identifier, rateModifierBundle.identifier) &&
        Objects.equals(this.hotelIdentifier, rateModifierBundle.hotelIdentifier) &&
        Objects.equals(this.name, rateModifierBundle.name) &&
        Objects.equals(this.enabled, rateModifierBundle.enabled) &&
        Objects.equals(this.items, rateModifierBundle.items) &&
        Objects.equals(this.modifierOverride, rateModifierBundle.modifierOverride) &&
        Objects.equals(this.type, rateModifierBundle.type) &&
        Objects.equals(this.pricingType, rateModifierBundle.pricingType) &&
        Objects.equals(this.description, rateModifierBundle.description);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, enabled, items, modifierOverride, type, pricingType, description);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RateModifierBundle {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    modifierOverride: ").append(toIndentedString(modifierOverride)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

