/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [TripPay Acquiring](/payment-acquiring): All APIs related to how our Web Components work. - [TripPay](/payment): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 21.15.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.ChartRequest;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * ChartRequestWrapper
 */
@JsonPropertyOrder({
  ChartRequestWrapper.JSON_PROPERTY_IDENTIFIER,
  ChartRequestWrapper.JSON_PROPERTY_OWNER_IDENTIFIER,
  ChartRequestWrapper.JSON_PROPERTY_NAME,
  ChartRequestWrapper.JSON_PROPERTY_SORT,
  ChartRequestWrapper.JSON_PROPERTY_REQUEST
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-08T16:31:43.015348+07:00[Asia/Bangkok]")
public class ChartRequestWrapper {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort = -1;

  public static final String JSON_PROPERTY_REQUEST = "request";
  private ChartRequest request;

  public ChartRequestWrapper() { 
  }

  public ChartRequestWrapper identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Unique record identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public ChartRequestWrapper ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Owner of this chart
   * @return ownerIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Owner of this chart")
  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public ChartRequestWrapper name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Chart name as named by creator
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "My First Chart", required = true, value = "Chart name as named by creator")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public ChartRequestWrapper sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Sort a list of charts by this sort value.
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "Sort a list of charts by this sort value.")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public ChartRequestWrapper request(ChartRequest request) {
    
    this.request = request;
    return this;
  }

   /**
   * Get request
   * @return request
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_REQUEST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ChartRequest getRequest() {
    return request;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequest(ChartRequest request) {
    this.request = request;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChartRequestWrapper chartRequestWrapper = (ChartRequestWrapper) o;
    return Objects.equals(this.identifier, chartRequestWrapper.identifier) &&
        Objects.equals(this.ownerIdentifier, chartRequestWrapper.ownerIdentifier) &&
        Objects.equals(this.name, chartRequestWrapper.name) &&
        Objects.equals(this.sort, chartRequestWrapper.sort) &&
        Objects.equals(this.request, chartRequestWrapper.request);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, ownerIdentifier, name, sort, request);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChartRequestWrapper {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    request: ").append(toIndentedString(request)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

