/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [TripPay Acquiring](/payment-acquiring): All APIs related to how our Web Components work. - [TripPay](/payment): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our payment, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 21.15.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.Address;
import travel.wink.sdk.affiliate.model.CompanyUser;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A Company is our definition of a sales channel / affiliate. A property also has a company record.
 */
@ApiModel(description = "A Company is our definition of a sales channel / affiliate. A property also has a company record.")
@JsonPropertyOrder({
  Company.JSON_PROPERTY_IDENTIFIER,
  Company.JSON_PROPERTY_USER_IDENTIFIER,
  Company.JSON_PROPERTY_OWNER,
  Company.JSON_PROPERTY_NAME,
  Company.JSON_PROPERTY_LEGAL_NAME,
  Company.JSON_PROPERTY_ENABLED,
  Company.JSON_PROPERTY_APPROVED,
  Company.JSON_PROPERTY_COMPANY_TYPE,
  Company.JSON_PROPERTY_TYPE,
  Company.JSON_PROPERTY_VAT_I_D,
  Company.JSON_PROPERTY_DESCRIPTION,
  Company.JSON_PROPERTY_URL,
  Company.JSON_PROPERTY_ADDRESS,
  Company.JSON_PROPERTY_MANAGERS,
  Company.JSON_PROPERTY_URLS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-08T16:31:43.015348+07:00[Asia/Bangkok]")
public class Company {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private CompanyUser owner;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
  private String legalName;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled;

  public static final String JSON_PROPERTY_APPROVED = "approved";
  private Boolean approved = false;

  /**
   * Type of company
   */
  public enum CompanyTypeEnum {
    COMPANY("COMPANY"),
    
    INDIVIDUAL("INDIVIDUAL");

    private String value;

    CompanyTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CompanyTypeEnum fromValue(String value) {
      for (CompanyTypeEnum b : CompanyTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_COMPANY_TYPE = "companyType";
  private CompanyTypeEnum companyType;

  /**
   * Type of sales channel
   */
  public enum TypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_VAT_I_D = "vatID";
  private String vatID;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private Address address;

  public static final String JSON_PROPERTY_MANAGERS = "managers";
  private List<CompanyUser> managers = null;

  public static final String JSON_PROPERTY_URLS = "urls";
  private List<String> urls = null;

  public Company() { 
  }

  public Company identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique identifier
   * @return identifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Unique identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public Company userIdentifier(UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

   /**
   * User identifier
   * @return userIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "User identifier")
  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserIdentifier(UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }


  public Company owner(CompanyUser owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CompanyUser getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwner(CompanyUser owner) {
    this.owner = owner;
  }


  public Company name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of company
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Company 1", required = true, value = "Name of company")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public Company legalName(String legalName) {
    
    this.legalName = legalName;
    return this;
  }

   /**
   * Legal name of entity if other than name
   * @return legalName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Legal Company 1", value = "Legal name of entity if other than name")
  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLegalName() {
    return legalName;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalName(String legalName) {
    this.legalName = legalName;
  }


  public Company enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this company is enabled by payment.
   * @return enabled
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Whether this company is enabled by payment.")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public Company approved(Boolean approved) {
    
    this.approved = approved;
    return this;
  }

   /**
   * Whether this company has been approved by KYC.
   * @return approved
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Whether this company has been approved by KYC.")
  @JsonProperty(JSON_PROPERTY_APPROVED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getApproved() {
    return approved;
  }


  @JsonProperty(JSON_PROPERTY_APPROVED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setApproved(Boolean approved) {
    this.approved = approved;
  }


  public Company companyType(CompanyTypeEnum companyType) {
    
    this.companyType = companyType;
    return this;
  }

   /**
   * Type of company
   * @return companyType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "COMPANY", required = true, value = "Type of company")
  @JsonProperty(JSON_PROPERTY_COMPANY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CompanyTypeEnum getCompanyType() {
    return companyType;
  }


  @JsonProperty(JSON_PROPERTY_COMPANY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCompanyType(CompanyTypeEnum companyType) {
    this.companyType = companyType;
  }


  public Company type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of sales channel
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "APPLICATION", required = true, value = "Type of sales channel")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public Company vatID(String vatID) {
    
    this.vatID = vatID;
    return this;
  }

   /**
   * An optional VAT ID
   * @return vatID
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "vat-1", required = true, value = "An optional VAT ID")
  @JsonProperty(JSON_PROPERTY_VAT_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getVatID() {
    return vatID;
  }


  @JsonProperty(JSON_PROPERTY_VAT_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVatID(String vatID) {
    this.vatID = vatID;
  }


  public Company description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * A personal message from the company.
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A personal message from the company.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public Company url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * Company&#39;s main website
   * @return url
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "https://www.mymainsite.com", required = true, value = "Company's main website")
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrl(String url) {
    this.url = url;
  }


  public Company address(Address address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Address getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(Address address) {
    this.address = address;
  }


  public Company managers(List<CompanyUser> managers) {
    
    this.managers = managers;
    return this;
  }

  public Company addManagersItem(CompanyUser managersItem) {
    if (this.managers == null) {
      this.managers = new ArrayList<>();
    }
    this.managers.add(managersItem);
    return this;
  }

   /**
   * Get managers
   * @return managers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MANAGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CompanyUser> getManagers() {
    return managers;
  }


  @JsonProperty(JSON_PROPERTY_MANAGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setManagers(List<CompanyUser> managers) {
    this.managers = managers;
  }


  public Company urls(List<String> urls) {
    
    this.urls = urls;
    return this;
  }

  public Company addUrlsItem(String urlsItem) {
    if (this.urls == null) {
      this.urls = new ArrayList<>();
    }
    this.urls.add(urlsItem);
    return this;
  }

   /**
   * List of all active accounts that could be used for selling or seeing a company&#39;s reach.
   * @return urls
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of all active accounts that could be used for selling or seeing a company's reach.")
  @JsonProperty(JSON_PROPERTY_URLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getUrls() {
    return urls;
  }


  @JsonProperty(JSON_PROPERTY_URLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrls(List<String> urls) {
    this.urls = urls;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Company company = (Company) o;
    return Objects.equals(this.identifier, company.identifier) &&
        Objects.equals(this.userIdentifier, company.userIdentifier) &&
        Objects.equals(this.owner, company.owner) &&
        Objects.equals(this.name, company.name) &&
        Objects.equals(this.legalName, company.legalName) &&
        Objects.equals(this.enabled, company.enabled) &&
        Objects.equals(this.approved, company.approved) &&
        Objects.equals(this.companyType, company.companyType) &&
        Objects.equals(this.type, company.type) &&
        Objects.equals(this.vatID, company.vatID) &&
        Objects.equals(this.description, company.description) &&
        Objects.equals(this.url, company.url) &&
        Objects.equals(this.address, company.address) &&
        Objects.equals(this.managers, company.managers) &&
        Objects.equals(this.urls, company.urls);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, userIdentifier, owner, name, legalName, enabled, approved, companyType, type, vatID, description, url, address, managers, urls);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Company {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    legalName: ").append(toIndentedString(legalName)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    approved: ").append(toIndentedString(approved)).append("\n");
    sb.append("    companyType: ").append(toIndentedString(companyType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    vatID: ").append(toIndentedString(vatID)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    managers: ").append(toIndentedString(managers)).append("\n");
    sb.append("    urls: ").append(toIndentedString(urls)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

