package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.Country;
import travel.wink.sdk.affiliate.model.DynamicSellerListRequest;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.GeoName;
import travel.wink.sdk.affiliate.model.PageSellerInventory;
import travel.wink.sdk.affiliate.model.ShowSellerUrl400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-16T10:41:04.695846072+07:00[Asia/Bangkok]")
public class DiscoverApi {
    private ApiClient apiClient;

    public DiscoverApi() {
        this(new ApiClient());
    }

    @Autowired
    public DiscoverApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Inventory Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List cities for inventory on behalf of this owner identifier.
     * @param accept The accept parameter
     * @return List&lt;GeoName&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCitiesForInventoryRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCitiesForInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/city/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List cities for inventory on behalf of this owner identifier.
     * @param accept The accept parameter
     * @return List&lt;GeoName&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<GeoName> showCitiesForInventory(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>() {};
        return showCitiesForInventoryRequestCreation(companyIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoName>>> showCitiesForInventoryWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoName> localVarReturnType = new ParameterizedTypeReference<GeoName>() {};
        return showCitiesForInventoryRequestCreation(companyIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Inventory Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List countries for inventory on behalf of this owner identifier.
     * @param accept The accept parameter
     * @return List&lt;Country&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCountriesForInventoryRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCountriesForInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Country> localVarReturnType = new ParameterizedTypeReference<Country>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/country/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List countries for inventory on behalf of this owner identifier.
     * @param accept The accept parameter
     * @return List&lt;Country&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Country> showCountriesForInventory(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Country> localVarReturnType = new ParameterizedTypeReference<Country>() {};
        return showCountriesForInventoryRequestCreation(companyIdentifier, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<Country>>> showCountriesForInventoryWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Country> localVarReturnType = new ParameterizedTypeReference<Country>() {};
        return showCountriesForInventoryRequestCreation(companyIdentifier, accept).toEntityList(localVarReturnType);
    }
    /**
     * Inventory Search
     * Retrieves a paginated result set based on the search criteria of the caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory on behalf of this owner identifier.
     * @param dynamicSellerListRequest The dynamicSellerListRequest parameter
     * @return PageSellerInventory
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showDynamicSellerInventoryRequestCreation(String companyIdentifier, DynamicSellerListRequest dynamicSellerListRequest) throws WebClientResponseException {
        Object postBody = dynamicSellerListRequest;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'dynamicSellerListRequest' is set
        if (dynamicSellerListRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicSellerListRequest' when calling showDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PageSellerInventory> localVarReturnType = new ParameterizedTypeReference<PageSellerInventory>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Inventory Search
     * Retrieves a paginated result set based on the search criteria of the caller.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Browse inventory on behalf of this owner identifier.
     * @param dynamicSellerListRequest The dynamicSellerListRequest parameter
     * @return PageSellerInventory
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageSellerInventory> showDynamicSellerInventory(String companyIdentifier, DynamicSellerListRequest dynamicSellerListRequest) throws WebClientResponseException {
        ParameterizedTypeReference<PageSellerInventory> localVarReturnType = new ParameterizedTypeReference<PageSellerInventory>() {};
        return showDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequest).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageSellerInventory>> showDynamicSellerInventoryWithHttpInfo(String companyIdentifier, DynamicSellerListRequest dynamicSellerListRequest) throws WebClientResponseException {
        ParameterizedTypeReference<PageSellerInventory> localVarReturnType = new ParameterizedTypeReference<PageSellerInventory>() {};
        return showDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequest).toEntity(localVarReturnType);
    }
}
