/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 21.16.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.ConfigurableGeoJsonCircle;
import travel.wink.sdk.affiliate.model.ConfigurableGeoJsonPoint;
import travel.wink.sdk.affiliate.model.ConfigurableGeoJsonPolygon;
import travel.wink.sdk.affiliate.model.ConfigurableGeoJsonRectangle;
import travel.wink.sdk.affiliate.model.HotelOnMapLocation;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Advanced map configuration
 */
@ApiModel(description = "Advanced map configuration")
@JsonPropertyOrder({
  AdvancedMapConfiguration.JSON_PROPERTY_IDENTIFIER,
  AdvancedMapConfiguration.JSON_PROPERTY_OWNER_IDENTIFIER,
  AdvancedMapConfiguration.JSON_PROPERTY_NAME,
  AdvancedMapConfiguration.JSON_PROPERTY_TYPE_IDENTIFIER,
  AdvancedMapConfiguration.JSON_PROPERTY_TYPE,
  AdvancedMapConfiguration.JSON_PROPERTY_CENTER,
  AdvancedMapConfiguration.JSON_PROPERTY_DRAGGABLE,
  AdvancedMapConfiguration.JSON_PROPERTY_ZOOMABLE,
  AdvancedMapConfiguration.JSON_PROPERTY_INITIAL_ZOOM_LEVEL,
  AdvancedMapConfiguration.JSON_PROPERTY_MAP_STYLE,
  AdvancedMapConfiguration.JSON_PROPERTY_MAP_MARKER_COLOR,
  AdvancedMapConfiguration.JSON_PROPERTY_MAP_HEIGHT,
  AdvancedMapConfiguration.JSON_PROPERTY_DISPLAY_TYPE,
  AdvancedMapConfiguration.JSON_PROPERTY_CIRCLES,
  AdvancedMapConfiguration.JSON_PROPERTY_RECTANGLES,
  AdvancedMapConfiguration.JSON_PROPERTY_MARKERS,
  AdvancedMapConfiguration.JSON_PROPERTY_POLYGONS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-16T10:41:04.695846072+07:00[Asia/Bangkok]")
public class AdvancedMapConfiguration {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
  private UUID typeIdentifier;

  /**
   * Type of inventory
   */
  public enum TypeEnum {
    SINGLE("SINGLE"),
    
    LIST("LIST"),
    
    SEARCH("SEARCH");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_CENTER = "center";
  private HotelOnMapLocation center;

  public static final String JSON_PROPERTY_DRAGGABLE = "draggable";
  private Boolean draggable = true;

  public static final String JSON_PROPERTY_ZOOMABLE = "zoomable";
  private Boolean zoomable = true;

  public static final String JSON_PROPERTY_INITIAL_ZOOM_LEVEL = "initialZoomLevel";
  private Integer initialZoomLevel;

  /**
   * Map style
   */
  public enum MapStyleEnum {
    NORMAL("normal"),
    
    CLEAN("clean"),
    
    BLUISH("bluish");

    private String value;

    MapStyleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MapStyleEnum fromValue(String value) {
      for (MapStyleEnum b : MapStyleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MAP_STYLE = "mapStyle";
  private MapStyleEnum mapStyle;

  /**
   * Map marker color
   */
  public enum MapMarkerColorEnum {
    CC2138("cc2138");

    private String value;

    MapMarkerColorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MapMarkerColorEnum fromValue(String value) {
      for (MapMarkerColorEnum b : MapMarkerColorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MAP_MARKER_COLOR = "mapMarkerColor";
  private MapMarkerColorEnum mapMarkerColor;

  public static final String JSON_PROPERTY_MAP_HEIGHT = "mapHeight";
  private Integer mapHeight;

  /**
   * Indicate which initial values to display first on the front-facing card
   */
  public enum DisplayTypeEnum {
    NATIVE("NATIVE"),
    
    HOTEL("HOTEL"),
    
    ROOM("ROOM");

    private String value;

    DisplayTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DisplayTypeEnum fromValue(String value) {
      for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
  private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;

  public static final String JSON_PROPERTY_CIRCLES = "circles";
  private List<ConfigurableGeoJsonCircle> circles = null;

  public static final String JSON_PROPERTY_RECTANGLES = "rectangles";
  private List<ConfigurableGeoJsonRectangle> rectangles = null;

  public static final String JSON_PROPERTY_MARKERS = "markers";
  private List<ConfigurableGeoJsonPoint> markers = null;

  public static final String JSON_PROPERTY_POLYGONS = "polygons";
  private List<ConfigurableGeoJsonPolygon> polygons = null;

  public AdvancedMapConfiguration() { 
  }

  public AdvancedMapConfiguration identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique map identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Unique map identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public AdvancedMapConfiguration ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Map owner identifier
   * @return ownerIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Map owner identifier")
  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public AdvancedMapConfiguration name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of map
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "My lovely map", required = true, value = "Name of map")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public AdvancedMapConfiguration typeIdentifier(UUID typeIdentifier) {
    
    this.typeIdentifier = typeIdentifier;
    return this;
  }

   /**
   * Inventory type identifier. Either a single channel inventory identifier, a list identifier or a dynamic search identifier.
   * @return typeIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Inventory type identifier. Either a single channel inventory identifier, a list identifier or a dynamic search identifier.")
  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getTypeIdentifier() {
    return typeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTypeIdentifier(UUID typeIdentifier) {
    this.typeIdentifier = typeIdentifier;
  }


  public AdvancedMapConfiguration type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of inventory
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "LIST", required = true, value = "Type of inventory")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public AdvancedMapConfiguration center(HotelOnMapLocation center) {
    
    this.center = center;
    return this;
  }

   /**
   * Get center
   * @return center
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CENTER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public HotelOnMapLocation getCenter() {
    return center;
  }


  @JsonProperty(JSON_PROPERTY_CENTER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCenter(HotelOnMapLocation center) {
    this.center = center;
  }


  public AdvancedMapConfiguration draggable(Boolean draggable) {
    
    this.draggable = draggable;
    return this;
  }

   /**
   * User can move around / pan the map
   * @return draggable
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "User can move around / pan the map")
  @JsonProperty(JSON_PROPERTY_DRAGGABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getDraggable() {
    return draggable;
  }


  @JsonProperty(JSON_PROPERTY_DRAGGABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDraggable(Boolean draggable) {
    this.draggable = draggable;
  }


  public AdvancedMapConfiguration zoomable(Boolean zoomable) {
    
    this.zoomable = zoomable;
    return this;
  }

   /**
   * User can zoom in/out of the map
   * @return zoomable
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "User can zoom in/out of the map")
  @JsonProperty(JSON_PROPERTY_ZOOMABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getZoomable() {
    return zoomable;
  }


  @JsonProperty(JSON_PROPERTY_ZOOMABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setZoomable(Boolean zoomable) {
    this.zoomable = zoomable;
  }


  public AdvancedMapConfiguration initialZoomLevel(Integer initialZoomLevel) {
    
    this.initialZoomLevel = initialZoomLevel;
    return this;
  }

   /**
   * Valid Google maps zoom level
   * minimum: 0
   * maximum: 21
   * @return initialZoomLevel
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0) @Max(21)  @ApiModelProperty(example = "15", required = true, value = "Valid Google maps zoom level")
  @JsonProperty(JSON_PROPERTY_INITIAL_ZOOM_LEVEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getInitialZoomLevel() {
    return initialZoomLevel;
  }


  @JsonProperty(JSON_PROPERTY_INITIAL_ZOOM_LEVEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInitialZoomLevel(Integer initialZoomLevel) {
    this.initialZoomLevel = initialZoomLevel;
  }


  public AdvancedMapConfiguration mapStyle(MapStyleEnum mapStyle) {
    
    this.mapStyle = mapStyle;
    return this;
  }

   /**
   * Map style
   * @return mapStyle
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "normal", required = true, value = "Map style")
  @JsonProperty(JSON_PROPERTY_MAP_STYLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MapStyleEnum getMapStyle() {
    return mapStyle;
  }


  @JsonProperty(JSON_PROPERTY_MAP_STYLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMapStyle(MapStyleEnum mapStyle) {
    this.mapStyle = mapStyle;
  }


  public AdvancedMapConfiguration mapMarkerColor(MapMarkerColorEnum mapMarkerColor) {
    
    this.mapMarkerColor = mapMarkerColor;
    return this;
  }

   /**
   * Map marker color
   * @return mapMarkerColor
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "cc2138", required = true, value = "Map marker color")
  @JsonProperty(JSON_PROPERTY_MAP_MARKER_COLOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MapMarkerColorEnum getMapMarkerColor() {
    return mapMarkerColor;
  }


  @JsonProperty(JSON_PROPERTY_MAP_MARKER_COLOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMapMarkerColor(MapMarkerColorEnum mapMarkerColor) {
    this.mapMarkerColor = mapMarkerColor;
  }


  public AdvancedMapConfiguration mapHeight(Integer mapHeight) {
    
    this.mapHeight = mapHeight;
    return this;
  }

   /**
   * Map height in pixels
   * @return mapHeight
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "500", required = true, value = "Map height in pixels")
  @JsonProperty(JSON_PROPERTY_MAP_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMapHeight() {
    return mapHeight;
  }


  @JsonProperty(JSON_PROPERTY_MAP_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMapHeight(Integer mapHeight) {
    this.mapHeight = mapHeight;
  }


  public AdvancedMapConfiguration displayType(DisplayTypeEnum displayType) {
    
    this.displayType = displayType;
    return this;
  }

   /**
   * Indicate which initial values to display first on the front-facing card
   * @return displayType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "NATIVE", required = true, value = "Indicate which initial values to display first on the front-facing card")
  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public DisplayTypeEnum getDisplayType() {
    return displayType;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayType(DisplayTypeEnum displayType) {
    this.displayType = displayType;
  }


  public AdvancedMapConfiguration circles(List<ConfigurableGeoJsonCircle> circles) {
    
    this.circles = circles;
    return this;
  }

  public AdvancedMapConfiguration addCirclesItem(ConfigurableGeoJsonCircle circlesItem) {
    if (this.circles == null) {
      this.circles = new ArrayList<>();
    }
    this.circles.add(circlesItem);
    return this;
  }

   /**
   * Get circles
   * @return circles
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CIRCLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConfigurableGeoJsonCircle> getCircles() {
    return circles;
  }


  @JsonProperty(JSON_PROPERTY_CIRCLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCircles(List<ConfigurableGeoJsonCircle> circles) {
    this.circles = circles;
  }


  public AdvancedMapConfiguration rectangles(List<ConfigurableGeoJsonRectangle> rectangles) {
    
    this.rectangles = rectangles;
    return this;
  }

  public AdvancedMapConfiguration addRectanglesItem(ConfigurableGeoJsonRectangle rectanglesItem) {
    if (this.rectangles == null) {
      this.rectangles = new ArrayList<>();
    }
    this.rectangles.add(rectanglesItem);
    return this;
  }

   /**
   * Get rectangles
   * @return rectangles
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RECTANGLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConfigurableGeoJsonRectangle> getRectangles() {
    return rectangles;
  }


  @JsonProperty(JSON_PROPERTY_RECTANGLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRectangles(List<ConfigurableGeoJsonRectangle> rectangles) {
    this.rectangles = rectangles;
  }


  public AdvancedMapConfiguration markers(List<ConfigurableGeoJsonPoint> markers) {
    
    this.markers = markers;
    return this;
  }

  public AdvancedMapConfiguration addMarkersItem(ConfigurableGeoJsonPoint markersItem) {
    if (this.markers == null) {
      this.markers = new ArrayList<>();
    }
    this.markers.add(markersItem);
    return this;
  }

   /**
   * Get markers
   * @return markers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MARKERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConfigurableGeoJsonPoint> getMarkers() {
    return markers;
  }


  @JsonProperty(JSON_PROPERTY_MARKERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarkers(List<ConfigurableGeoJsonPoint> markers) {
    this.markers = markers;
  }


  public AdvancedMapConfiguration polygons(List<ConfigurableGeoJsonPolygon> polygons) {
    
    this.polygons = polygons;
    return this;
  }

  public AdvancedMapConfiguration addPolygonsItem(ConfigurableGeoJsonPolygon polygonsItem) {
    if (this.polygons == null) {
      this.polygons = new ArrayList<>();
    }
    this.polygons.add(polygonsItem);
    return this;
  }

   /**
   * Get polygons
   * @return polygons
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_POLYGONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConfigurableGeoJsonPolygon> getPolygons() {
    return polygons;
  }


  @JsonProperty(JSON_PROPERTY_POLYGONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolygons(List<ConfigurableGeoJsonPolygon> polygons) {
    this.polygons = polygons;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdvancedMapConfiguration advancedMapConfiguration = (AdvancedMapConfiguration) o;
    return Objects.equals(this.identifier, advancedMapConfiguration.identifier) &&
        Objects.equals(this.ownerIdentifier, advancedMapConfiguration.ownerIdentifier) &&
        Objects.equals(this.name, advancedMapConfiguration.name) &&
        Objects.equals(this.typeIdentifier, advancedMapConfiguration.typeIdentifier) &&
        Objects.equals(this.type, advancedMapConfiguration.type) &&
        Objects.equals(this.center, advancedMapConfiguration.center) &&
        Objects.equals(this.draggable, advancedMapConfiguration.draggable) &&
        Objects.equals(this.zoomable, advancedMapConfiguration.zoomable) &&
        Objects.equals(this.initialZoomLevel, advancedMapConfiguration.initialZoomLevel) &&
        Objects.equals(this.mapStyle, advancedMapConfiguration.mapStyle) &&
        Objects.equals(this.mapMarkerColor, advancedMapConfiguration.mapMarkerColor) &&
        Objects.equals(this.mapHeight, advancedMapConfiguration.mapHeight) &&
        Objects.equals(this.displayType, advancedMapConfiguration.displayType) &&
        Objects.equals(this.circles, advancedMapConfiguration.circles) &&
        Objects.equals(this.rectangles, advancedMapConfiguration.rectangles) &&
        Objects.equals(this.markers, advancedMapConfiguration.markers) &&
        Objects.equals(this.polygons, advancedMapConfiguration.polygons);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, ownerIdentifier, name, typeIdentifier, type, center, draggable, zoomable, initialZoomLevel, mapStyle, mapMarkerColor, mapHeight, displayType, circles, rectangles, markers, polygons);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdvancedMapConfiguration {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    typeIdentifier: ").append(toIndentedString(typeIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    center: ").append(toIndentedString(center)).append("\n");
    sb.append("    draggable: ").append(toIndentedString(draggable)).append("\n");
    sb.append("    zoomable: ").append(toIndentedString(zoomable)).append("\n");
    sb.append("    initialZoomLevel: ").append(toIndentedString(initialZoomLevel)).append("\n");
    sb.append("    mapStyle: ").append(toIndentedString(mapStyle)).append("\n");
    sb.append("    mapMarkerColor: ").append(toIndentedString(mapMarkerColor)).append("\n");
    sb.append("    mapHeight: ").append(toIndentedString(mapHeight)).append("\n");
    sb.append("    displayType: ").append(toIndentedString(displayType)).append("\n");
    sb.append("    circles: ").append(toIndentedString(circles)).append("\n");
    sb.append("    rectangles: ").append(toIndentedString(rectangles)).append("\n");
    sb.append("    markers: ").append(toIndentedString(markers)).append("\n");
    sb.append("    polygons: ").append(toIndentedString(polygons)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

