/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 21.16.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.AddOnOffers;
import travel.wink.sdk.affiliate.model.BookingAddress;
import travel.wink.sdk.affiliate.model.BookingContactInfo;
import travel.wink.sdk.affiliate.model.BookingContract;
import travel.wink.sdk.affiliate.model.BookingInternalTotal;
import travel.wink.sdk.affiliate.model.BookingSourceTotal;
import travel.wink.sdk.affiliate.model.BookingUser;
import travel.wink.sdk.affiliate.model.BookingUserSpecifiedCurrencyTotal;
import travel.wink.sdk.affiliate.model.CommissionableEntry;
import travel.wink.sdk.affiliate.model.EngineConfigurationBookingReport;
import travel.wink.sdk.affiliate.model.ExtraBookingRequest;
import travel.wink.sdk.affiliate.model.HotelOnMap;
import travel.wink.sdk.affiliate.model.Moneys;
import travel.wink.sdk.affiliate.model.PackageOffers;
import travel.wink.sdk.affiliate.model.Review;
import travel.wink.sdk.affiliate.model.RoomStay;
import travel.wink.sdk.affiliate.model.Social;
import travel.wink.sdk.affiliate.model.UserSession;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Booking data object
 */
@ApiModel(description = "Booking data object")
@JsonPropertyOrder({
  Booking.JSON_PROPERTY_TEST,
  Booking.JSON_PROPERTY_DATE,
  Booking.JSON_PROPERTY_GROUP_IDENTIFIER,
  Booking.JSON_PROPERTY_IDENTIFIER,
  Booking.JSON_PROPERTY_ENGINE_CONFIGURATION,
  Booking.JSON_PROPERTY_BOOKING_CODE,
  Booking.JSON_PROPERTY_USER,
  Booking.JSON_PROPERTY_USER_SESSION,
  Booking.JSON_PROPERTY_SERVER_URL,
  Booking.JSON_PROPERTY_CONTACT_INFO,
  Booking.JSON_PROPERTY_ADDRESS,
  Booking.JSON_PROPERTY_SOCIALS,
  Booking.JSON_PROPERTY_REVIEW,
  Booking.JSON_PROPERTY_EMAIL_HEADER_LOGO_URL,
  Booking.JSON_PROPERTY_LOGO_IDENTIFIER,
  Booking.JSON_PROPERTY_HOTEL,
  Booking.JSON_PROPERTY_ROOM_STAY,
  Booking.JSON_PROPERTY_SPECIAL_REQUESTS,
  Booking.JSON_PROPERTY_COMMENT,
  Booking.JSON_PROPERTY_PACKAGE_OFFERS,
  Booking.JSON_PROPERTY_ADD_ON_OFFERS,
  Booking.JSON_PROPERTY_EARLY_CHECK_IN_CHARGE,
  Booking.JSON_PROPERTY_LATE_CHECK_OUT_CHARGE,
  Booking.JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT,
  Booking.JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT,
  Booking.JSON_PROPERTY_HOTEL_IMAGE_URL,
  Booking.JSON_PROPERTY_ROOM_IMAGE_URL,
  Booking.JSON_PROPERTY_COMMISSION_LIST,
  Booking.JSON_PROPERTY_BOOKING_CONTRACT,
  Booking.JSON_PROPERTY_STATUS,
  Booking.JSON_PROPERTY_START_DATE,
  Booking.JSON_PROPERTY_END_DATE,
  Booking.JSON_PROPERTY_SOURCE_TOTAL,
  Booking.JSON_PROPERTY_INTERNAL_TOTAL,
  Booking.JSON_PROPERTY_MEETING_ROOMS,
  Booking.JSON_PROPERTY_RESTAURANTS,
  Booking.JSON_PROPERTY_SPAS,
  Booking.JSON_PROPERTY_ACTIVITIES,
  Booking.JSON_PROPERTY_ATTRACTIONS,
  Booking.JSON_PROPERTY_PLACES,
  Booking.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  Booking.JSON_PROPERTY_FULL_ADDRESS,
  Booking.JSON_PROPERTY_RATE_SOURCE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-16T10:41:04.695846072+07:00[Asia/Bangkok]")
public class Booking {
  public static final String JSON_PROPERTY_TEST = "test";
  private Boolean test;

  public static final String JSON_PROPERTY_DATE = "date";
  private OffsetDateTime date;

  public static final String JSON_PROPERTY_GROUP_IDENTIFIER = "groupIdentifier";
  private UUID groupIdentifier;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_ENGINE_CONFIGURATION = "engineConfiguration";
  private EngineConfigurationBookingReport engineConfiguration;

  public static final String JSON_PROPERTY_BOOKING_CODE = "bookingCode";
  private String bookingCode;

  public static final String JSON_PROPERTY_USER = "user";
  private BookingUser user;

  public static final String JSON_PROPERTY_USER_SESSION = "userSession";
  private UserSession userSession;

  public static final String JSON_PROPERTY_SERVER_URL = "serverUrl";
  private String serverUrl;

  public static final String JSON_PROPERTY_CONTACT_INFO = "contactInfo";
  private BookingContactInfo contactInfo;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private BookingAddress address;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<Social> socials = null;

  public static final String JSON_PROPERTY_REVIEW = "review";
  private Review review;

  public static final String JSON_PROPERTY_EMAIL_HEADER_LOGO_URL = "emailHeaderLogoUrl";
  private String emailHeaderLogoUrl;

  public static final String JSON_PROPERTY_LOGO_IDENTIFIER = "logoIdentifier";
  private String logoIdentifier;

  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private HotelOnMap hotel;

  public static final String JSON_PROPERTY_ROOM_STAY = "roomStay";
  private RoomStay roomStay;

  public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
  private String specialRequests;

  public static final String JSON_PROPERTY_COMMENT = "comment";
  private String comment;

  public static final String JSON_PROPERTY_PACKAGE_OFFERS = "packageOffers";
  private PackageOffers packageOffers;

  public static final String JSON_PROPERTY_ADD_ON_OFFERS = "addOnOffers";
  private AddOnOffers addOnOffers;

  public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE = "earlyCheckInCharge";
  private Moneys earlyCheckInCharge;

  public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE = "lateCheckOutCharge";
  private Moneys lateCheckOutCharge;

  public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT = "earlyCheckInChargePercent";
  private Float earlyCheckInChargePercent;

  public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT = "lateCheckOutChargePercent";
  private Float lateCheckOutChargePercent;

  public static final String JSON_PROPERTY_HOTEL_IMAGE_URL = "hotelImageUrl";
  private String hotelImageUrl;

  public static final String JSON_PROPERTY_ROOM_IMAGE_URL = "roomImageUrl";
  private String roomImageUrl;

  public static final String JSON_PROPERTY_COMMISSION_LIST = "commissionList";
  private List<CommissionableEntry> commissionList = null;

  public static final String JSON_PROPERTY_BOOKING_CONTRACT = "bookingContract";
  private BookingContract bookingContract;

  /**
   * Convenience data point to show which status the booking currently has.
   */
  public enum StatusEnum {
    CANCELLED_BY_HOTEL("CANCELLED_BY_HOTEL"),
    
    CANCELLED_BY_GUEST("CANCELLED_BY_GUEST"),
    
    CANCELLED_BY_ADMIN("CANCELLED_BY_ADMIN"),
    
    CANCELLED_BY_SALES_CHANNEL("CANCELLED_BY_SALES_CHANNEL"),
    
    PAST("PAST"),
    
    ACTIVE("ACTIVE");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private BookingSourceTotal sourceTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private BookingInternalTotal internalTotal;

  public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
  private List<ExtraBookingRequest> meetingRooms = null;

  public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
  private List<ExtraBookingRequest> restaurants = null;

  public static final String JSON_PROPERTY_SPAS = "spas";
  private List<ExtraBookingRequest> spas = null;

  public static final String JSON_PROPERTY_ACTIVITIES = "activities";
  private List<ExtraBookingRequest> activities = null;

  public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
  private List<ExtraBookingRequest> attractions = null;

  public static final String JSON_PROPERTY_PLACES = "places";
  private List<ExtraBookingRequest> places = null;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private BookingUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_FULL_ADDRESS = "fullAddress";
  private String fullAddress;

  /**
   * Rate origin. This is usually the property channel manager.
   */
  public enum RateSourceEnum {
    TRAVELIKO("TRAVELIKO"),
    
    SITEMINDER("SITEMINDER"),
    
    FASTBOOKING("FASTBOOKING"),
    
    RATEGAIN("RATEGAIN"),
    
    CLOUD_BEDS("CLOUD_BEDS"),
    
    YIELD_PLANET("YIELD_PLANET"),
    
    TRAVELCLICK("TRAVELCLICK"),
    
    HOTEL_GURU("HOTEL_GURU"),
    
    OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
    
    BOOKING_JINI("BOOKING_JINI"),
    
    HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
    
    ALLOTZ("ALLOTZ"),
    
    DEDGE("DEDGE"),
    
    RATE_TIGER("RATE_TIGER"),
    
    RESAVENUE("RESAVENUE"),
    
    COMANCHE("COMANCHE"),
    
    OMNIBEES("OMNIBEES"),
    
    EZEE("EZEE"),
    
    SYNXIS("SYNXIS");

    private String value;

    RateSourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RateSourceEnum fromValue(String value) {
      for (RateSourceEnum b : RateSourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  private RateSourceEnum rateSource;

  public Booking() { 
  }

  public Booking test(Boolean test) {
    
    this.test = test;
    return this;
  }

   /**
   * Whether this was a test booking by the property than can safely be deleted again
   * @return test
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Whether this was a test booking by the property than can safely be deleted again")
  @JsonProperty(JSON_PROPERTY_TEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTest() {
    return test;
  }


  @JsonProperty(JSON_PROPERTY_TEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTest(Boolean test) {
    this.test = test;
  }


  public Booking date(OffsetDateTime date) {
    
    this.date = date;
    return this;
  }

   /**
   * Date and time the booking was made.
   * @return date
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Date and time the booking was made.")
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDate(OffsetDateTime date) {
    this.date = date;
  }


  public Booking groupIdentifier(UUID groupIdentifier) {
    
    this.groupIdentifier = groupIdentifier;
    return this;
  }

   /**
   * Unique record identifier for the collection of bookings that were made at the same time.
   * @return groupIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Unique record identifier for the collection of bookings that were made at the same time.")
  @JsonProperty(JSON_PROPERTY_GROUP_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getGroupIdentifier() {
    return groupIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupIdentifier(UUID groupIdentifier) {
    this.groupIdentifier = groupIdentifier;
  }


  public Booking identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Unique record identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public Booking engineConfiguration(EngineConfigurationBookingReport engineConfiguration) {
    
    this.engineConfiguration = engineConfiguration;
    return this;
  }

   /**
   * Get engineConfiguration
   * @return engineConfiguration
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EngineConfigurationBookingReport getEngineConfiguration() {
    return engineConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEngineConfiguration(EngineConfigurationBookingReport engineConfiguration) {
    this.engineConfiguration = engineConfiguration;
  }


  public Booking bookingCode(String bookingCode) {
    
    this.bookingCode = bookingCode;
    return this;
  }

   /**
   * Unique user-friendly booking geoname. This code should be used when corresponding with travelers.
   * @return bookingCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ABC1234", value = "Unique user-friendly booking geoname. This code should be used when corresponding with travelers.")
  @JsonProperty(JSON_PROPERTY_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBookingCode() {
    return bookingCode;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingCode(String bookingCode) {
    this.bookingCode = bookingCode;
  }


  public Booking user(BookingUser user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingUser getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUser(BookingUser user) {
    this.user = user;
  }


  public Booking userSession(UserSession userSession) {
    
    this.userSession = userSession;
    return this;
  }

   /**
   * Get userSession
   * @return userSession
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UserSession getUserSession() {
    return userSession;
  }


  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSession(UserSession userSession) {
    this.userSession = userSession;
  }


  public Booking serverUrl(String serverUrl) {
    
    this.serverUrl = serverUrl;
    return this;
  }

   /**
   * The URL the booking occurred
   * @return serverUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The URL the booking occurred")
  @JsonProperty(JSON_PROPERTY_SERVER_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getServerUrl() {
    return serverUrl;
  }


  @JsonProperty(JSON_PROPERTY_SERVER_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServerUrl(String serverUrl) {
    this.serverUrl = serverUrl;
  }


  public Booking contactInfo(BookingContactInfo contactInfo) {
    
    this.contactInfo = contactInfo;
    return this;
  }

   /**
   * Get contactInfo
   * @return contactInfo
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONTACT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingContactInfo getContactInfo() {
    return contactInfo;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactInfo(BookingContactInfo contactInfo) {
    this.contactInfo = contactInfo;
  }


  public Booking address(BookingAddress address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingAddress getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(BookingAddress address) {
    this.address = address;
  }


  public Booking socials(List<Social> socials) {
    
    this.socials = socials;
    return this;
  }

  public Booking addSocialsItem(Social socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * List of all social network account property has for the traveler to get in touch.
   * @return socials
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "List of all social network account property has for the traveler to get in touch.")
  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Social> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<Social> socials) {
    this.socials = socials;
  }


  public Booking review(Review review) {
    
    this.review = review;
    return this;
  }

   /**
   * Get review
   * @return review
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Review getReview() {
    return review;
  }


  @JsonProperty(JSON_PROPERTY_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReview(Review review) {
    this.review = review;
  }


  public Booking emailHeaderLogoUrl(String emailHeaderLogoUrl) {
    
    this.emailHeaderLogoUrl = emailHeaderLogoUrl;
    return this;
  }

   /**
   * Full url of the image logo optimized for emails
   * @return emailHeaderLogoUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Full url of the image logo optimized for emails")
  @JsonProperty(JSON_PROPERTY_EMAIL_HEADER_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEmailHeaderLogoUrl() {
    return emailHeaderLogoUrl;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL_HEADER_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmailHeaderLogoUrl(String emailHeaderLogoUrl) {
    this.emailHeaderLogoUrl = emailHeaderLogoUrl;
  }


  public Booking logoIdentifier(String logoIdentifier) {
    
    this.logoIdentifier = logoIdentifier;
    return this;
  }

   /**
   * Logo cloudinary identifier for potential reuse
   * @return logoIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Logo cloudinary identifier for potential reuse")
  @JsonProperty(JSON_PROPERTY_LOGO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLogoIdentifier() {
    return logoIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_LOGO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogoIdentifier(String logoIdentifier) {
    this.logoIdentifier = logoIdentifier;
  }


  public Booking hotel(HotelOnMap hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HotelOnMap getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotel(HotelOnMap hotel) {
    this.hotel = hotel;
  }


  public Booking roomStay(RoomStay roomStay) {
    
    this.roomStay = roomStay;
    return this;
  }

   /**
   * Get roomStay
   * @return roomStay
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomStay getRoomStay() {
    return roomStay;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomStay(RoomStay roomStay) {
    this.roomStay = roomStay;
  }


  public Booking specialRequests(String specialRequests) {
    
    this.specialRequests = specialRequests;
    return this;
  }

   /**
   * Free text where the traveler can add a message to the property.
   * @return specialRequests
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Free text where the traveler can add a message to the property.")
  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSpecialRequests() {
    return specialRequests;
  }


  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpecialRequests(String specialRequests) {
    this.specialRequests = specialRequests;
  }


  public Booking comment(String comment) {
    
    this.comment = comment;
    return this;
  }

   /**
   * Internal comment field the payment can add and make available to channel manager partners.
   * @return comment
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Internal comment field the payment can add and make available to channel manager partners.")
  @JsonProperty(JSON_PROPERTY_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getComment() {
    return comment;
  }


  @JsonProperty(JSON_PROPERTY_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setComment(String comment) {
    this.comment = comment;
  }


  public Booking packageOffers(PackageOffers packageOffers) {
    
    this.packageOffers = packageOffers;
    return this;
  }

   /**
   * Get packageOffers
   * @return packageOffers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PACKAGE_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PackageOffers getPackageOffers() {
    return packageOffers;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGE_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageOffers(PackageOffers packageOffers) {
    this.packageOffers = packageOffers;
  }


  public Booking addOnOffers(AddOnOffers addOnOffers) {
    
    this.addOnOffers = addOnOffers;
    return this;
  }

   /**
   * Get addOnOffers
   * @return addOnOffers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddOnOffers getAddOnOffers() {
    return addOnOffers;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnOffers(AddOnOffers addOnOffers) {
    this.addOnOffers = addOnOffers;
  }


  public Booking earlyCheckInCharge(Moneys earlyCheckInCharge) {
    
    this.earlyCheckInCharge = earlyCheckInCharge;
    return this;
  }

   /**
   * Get earlyCheckInCharge
   * @return earlyCheckInCharge
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getEarlyCheckInCharge() {
    return earlyCheckInCharge;
  }


  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEarlyCheckInCharge(Moneys earlyCheckInCharge) {
    this.earlyCheckInCharge = earlyCheckInCharge;
  }


  public Booking lateCheckOutCharge(Moneys lateCheckOutCharge) {
    
    this.lateCheckOutCharge = lateCheckOutCharge;
    return this;
  }

   /**
   * Get lateCheckOutCharge
   * @return lateCheckOutCharge
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getLateCheckOutCharge() {
    return lateCheckOutCharge;
  }


  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLateCheckOutCharge(Moneys lateCheckOutCharge) {
    this.lateCheckOutCharge = lateCheckOutCharge;
  }


  public Booking earlyCheckInChargePercent(Float earlyCheckInChargePercent) {
    
    this.earlyCheckInChargePercent = earlyCheckInChargePercent;
    return this;
  }

   /**
   * Early check-in charge calculated in percent of first room night price.
   * @return earlyCheckInChargePercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0.05", value = "Early check-in charge calculated in percent of first room night price.")
  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getEarlyCheckInChargePercent() {
    return earlyCheckInChargePercent;
  }


  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEarlyCheckInChargePercent(Float earlyCheckInChargePercent) {
    this.earlyCheckInChargePercent = earlyCheckInChargePercent;
  }


  public Booking lateCheckOutChargePercent(Float lateCheckOutChargePercent) {
    
    this.lateCheckOutChargePercent = lateCheckOutChargePercent;
    return this;
  }

   /**
   * Early check-in charge calculated in percent of first room night price.
   * @return lateCheckOutChargePercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0.05", value = "Early check-in charge calculated in percent of first room night price.")
  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLateCheckOutChargePercent() {
    return lateCheckOutChargePercent;
  }


  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLateCheckOutChargePercent(Float lateCheckOutChargePercent) {
    this.lateCheckOutChargePercent = lateCheckOutChargePercent;
  }


  public Booking hotelImageUrl(String hotelImageUrl) {
    
    this.hotelImageUrl = hotelImageUrl;
    return this;
  }

   /**
   * Absolute URL of hotel image that can be used as-is
   * @return hotelImageUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "https://path.to/property-image.jpg", value = "Absolute URL of hotel image that can be used as-is")
  @JsonProperty(JSON_PROPERTY_HOTEL_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelImageUrl() {
    return hotelImageUrl;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelImageUrl(String hotelImageUrl) {
    this.hotelImageUrl = hotelImageUrl;
  }


  public Booking roomImageUrl(String roomImageUrl) {
    
    this.roomImageUrl = roomImageUrl;
    return this;
  }

   /**
   * Absolute URL of room image that can be used as-is
   * @return roomImageUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "https://path.to/room-image.jpg", value = "Absolute URL of room image that can be used as-is")
  @JsonProperty(JSON_PROPERTY_ROOM_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomImageUrl() {
    return roomImageUrl;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomImageUrl(String roomImageUrl) {
    this.roomImageUrl = roomImageUrl;
  }


  public Booking commissionList(List<CommissionableEntry> commissionList) {
    
    this.commissionList = commissionList;
    return this;
  }

  public Booking addCommissionListItem(CommissionableEntry commissionListItem) {
    if (this.commissionList == null) {
      this.commissionList = new ArrayList<>();
    }
    this.commissionList.add(commissionListItem);
    return this;
  }

   /**
   * List of all travel inventory entries that are due a commission to the affiliate.
   * @return commissionList
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "List of all travel inventory entries that are due a commission to the affiliate.")
  @JsonProperty(JSON_PROPERTY_COMMISSION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CommissionableEntry> getCommissionList() {
    return commissionList;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionList(List<CommissionableEntry> commissionList) {
    this.commissionList = commissionList;
  }


  public Booking bookingContract(BookingContract bookingContract) {
    
    this.bookingContract = bookingContract;
    return this;
  }

   /**
   * Get bookingContract
   * @return bookingContract
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingContract getBookingContract() {
    return bookingContract;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingContract(BookingContract bookingContract) {
    this.bookingContract = bookingContract;
  }


  public Booking status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Convenience data point to show which status the booking currently has.
   * @return status
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ACTIVE", value = "Convenience data point to show which status the booking currently has.")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public Booking startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Guest arrival date.
   * @return startDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Wed Jan 01 07:00:00 ICT 2020", value = "Guest arrival date.")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public Booking endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Guest departure date.
   * @return endDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Tue Jan 07 07:00:00 ICT 2020", value = "Guest departure date.")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public Booking sourceTotal(BookingSourceTotal sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingSourceTotal getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(BookingSourceTotal sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  public Booking internalTotal(BookingInternalTotal internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingInternalTotal getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(BookingInternalTotal internalTotal) {
    this.internalTotal = internalTotal;
  }


  public Booking meetingRooms(List<ExtraBookingRequest> meetingRooms) {
    
    this.meetingRooms = meetingRooms;
    return this;
  }

  public Booking addMeetingRoomsItem(ExtraBookingRequest meetingRoomsItem) {
    if (this.meetingRooms == null) {
      this.meetingRooms = new ArrayList<>();
    }
    this.meetingRooms.add(meetingRoomsItem);
    return this;
  }

   /**
   * Meeting room reservation records.
   * @return meetingRooms
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Meeting room reservation records.")
  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ExtraBookingRequest> getMeetingRooms() {
    return meetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRooms(List<ExtraBookingRequest> meetingRooms) {
    this.meetingRooms = meetingRooms;
  }


  public Booking restaurants(List<ExtraBookingRequest> restaurants) {
    
    this.restaurants = restaurants;
    return this;
  }

  public Booking addRestaurantsItem(ExtraBookingRequest restaurantsItem) {
    if (this.restaurants == null) {
      this.restaurants = new ArrayList<>();
    }
    this.restaurants.add(restaurantsItem);
    return this;
  }

   /**
   * Restaurant reservation records.
   * @return restaurants
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Restaurant reservation records.")
  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ExtraBookingRequest> getRestaurants() {
    return restaurants;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurants(List<ExtraBookingRequest> restaurants) {
    this.restaurants = restaurants;
  }


  public Booking spas(List<ExtraBookingRequest> spas) {
    
    this.spas = spas;
    return this;
  }

  public Booking addSpasItem(ExtraBookingRequest spasItem) {
    if (this.spas == null) {
      this.spas = new ArrayList<>();
    }
    this.spas.add(spasItem);
    return this;
  }

   /**
   * Spa reservation records.
   * @return spas
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Spa reservation records.")
  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ExtraBookingRequest> getSpas() {
    return spas;
  }


  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpas(List<ExtraBookingRequest> spas) {
    this.spas = spas;
  }


  public Booking activities(List<ExtraBookingRequest> activities) {
    
    this.activities = activities;
    return this;
  }

  public Booking addActivitiesItem(ExtraBookingRequest activitiesItem) {
    if (this.activities == null) {
      this.activities = new ArrayList<>();
    }
    this.activities.add(activitiesItem);
    return this;
  }

   /**
   * Activity reservation records.
   * @return activities
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Activity reservation records.")
  @JsonProperty(JSON_PROPERTY_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ExtraBookingRequest> getActivities() {
    return activities;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivities(List<ExtraBookingRequest> activities) {
    this.activities = activities;
  }


  public Booking attractions(List<ExtraBookingRequest> attractions) {
    
    this.attractions = attractions;
    return this;
  }

  public Booking addAttractionsItem(ExtraBookingRequest attractionsItem) {
    if (this.attractions == null) {
      this.attractions = new ArrayList<>();
    }
    this.attractions.add(attractionsItem);
    return this;
  }

   /**
   * Attraction reservation records.
   * @return attractions
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Attraction reservation records.")
  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ExtraBookingRequest> getAttractions() {
    return attractions;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttractions(List<ExtraBookingRequest> attractions) {
    this.attractions = attractions;
  }


  public Booking places(List<ExtraBookingRequest> places) {
    
    this.places = places;
    return this;
  }

  public Booking addPlacesItem(ExtraBookingRequest placesItem) {
    if (this.places == null) {
      this.places = new ArrayList<>();
    }
    this.places.add(placesItem);
    return this;
  }

   /**
   * Place reservation records.
   * @return places
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Place reservation records.")
  @JsonProperty(JSON_PROPERTY_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ExtraBookingRequest> getPlaces() {
    return places;
  }


  @JsonProperty(JSON_PROPERTY_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlaces(List<ExtraBookingRequest> places) {
    this.places = places;
  }


  public Booking userSpecifiedCurrencyTotal(BookingUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingUserSpecifiedCurrencyTotal getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(BookingUserSpecifiedCurrencyTotal userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  public Booking fullAddress(String fullAddress) {
    
    this.fullAddress = fullAddress;
    return this;
  }

   /**
   * Convenience data point to return the full hotel address.
   * @return fullAddress
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "204 At home lane, Singapore, Singapore 224333", value = "Convenience data point to return the full hotel address.")
  @JsonProperty(JSON_PROPERTY_FULL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullAddress() {
    return fullAddress;
  }


  @JsonProperty(JSON_PROPERTY_FULL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullAddress(String fullAddress) {
    this.fullAddress = fullAddress;
  }


  public Booking rateSource(RateSourceEnum rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

   /**
   * Rate origin. This is usually the property channel manager.
   * @return rateSource
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "SITEMINDER", value = "Rate origin. This is usually the property channel manager.")
  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RateSourceEnum getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(RateSourceEnum rateSource) {
    this.rateSource = rateSource;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Booking booking = (Booking) o;
    return Objects.equals(this.test, booking.test) &&
        Objects.equals(this.date, booking.date) &&
        Objects.equals(this.groupIdentifier, booking.groupIdentifier) &&
        Objects.equals(this.identifier, booking.identifier) &&
        Objects.equals(this.engineConfiguration, booking.engineConfiguration) &&
        Objects.equals(this.bookingCode, booking.bookingCode) &&
        Objects.equals(this.user, booking.user) &&
        Objects.equals(this.userSession, booking.userSession) &&
        Objects.equals(this.serverUrl, booking.serverUrl) &&
        Objects.equals(this.contactInfo, booking.contactInfo) &&
        Objects.equals(this.address, booking.address) &&
        Objects.equals(this.socials, booking.socials) &&
        Objects.equals(this.review, booking.review) &&
        Objects.equals(this.emailHeaderLogoUrl, booking.emailHeaderLogoUrl) &&
        Objects.equals(this.logoIdentifier, booking.logoIdentifier) &&
        Objects.equals(this.hotel, booking.hotel) &&
        Objects.equals(this.roomStay, booking.roomStay) &&
        Objects.equals(this.specialRequests, booking.specialRequests) &&
        Objects.equals(this.comment, booking.comment) &&
        Objects.equals(this.packageOffers, booking.packageOffers) &&
        Objects.equals(this.addOnOffers, booking.addOnOffers) &&
        Objects.equals(this.earlyCheckInCharge, booking.earlyCheckInCharge) &&
        Objects.equals(this.lateCheckOutCharge, booking.lateCheckOutCharge) &&
        Objects.equals(this.earlyCheckInChargePercent, booking.earlyCheckInChargePercent) &&
        Objects.equals(this.lateCheckOutChargePercent, booking.lateCheckOutChargePercent) &&
        Objects.equals(this.hotelImageUrl, booking.hotelImageUrl) &&
        Objects.equals(this.roomImageUrl, booking.roomImageUrl) &&
        Objects.equals(this.commissionList, booking.commissionList) &&
        Objects.equals(this.bookingContract, booking.bookingContract) &&
        Objects.equals(this.status, booking.status) &&
        Objects.equals(this.startDate, booking.startDate) &&
        Objects.equals(this.endDate, booking.endDate) &&
        Objects.equals(this.sourceTotal, booking.sourceTotal) &&
        Objects.equals(this.internalTotal, booking.internalTotal) &&
        Objects.equals(this.meetingRooms, booking.meetingRooms) &&
        Objects.equals(this.restaurants, booking.restaurants) &&
        Objects.equals(this.spas, booking.spas) &&
        Objects.equals(this.activities, booking.activities) &&
        Objects.equals(this.attractions, booking.attractions) &&
        Objects.equals(this.places, booking.places) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, booking.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.fullAddress, booking.fullAddress) &&
        Objects.equals(this.rateSource, booking.rateSource);
  }

  @Override
  public int hashCode() {
    return Objects.hash(test, date, groupIdentifier, identifier, engineConfiguration, bookingCode, user, userSession, serverUrl, contactInfo, address, socials, review, emailHeaderLogoUrl, logoIdentifier, hotel, roomStay, specialRequests, comment, packageOffers, addOnOffers, earlyCheckInCharge, lateCheckOutCharge, earlyCheckInChargePercent, lateCheckOutChargePercent, hotelImageUrl, roomImageUrl, commissionList, bookingContract, status, startDate, endDate, sourceTotal, internalTotal, meetingRooms, restaurants, spas, activities, attractions, places, userSpecifiedCurrencyTotal, fullAddress, rateSource);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Booking {\n");
    sb.append("    test: ").append(toIndentedString(test)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    groupIdentifier: ").append(toIndentedString(groupIdentifier)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    engineConfiguration: ").append(toIndentedString(engineConfiguration)).append("\n");
    sb.append("    bookingCode: ").append(toIndentedString(bookingCode)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    userSession: ").append(toIndentedString(userSession)).append("\n");
    sb.append("    serverUrl: ").append(toIndentedString(serverUrl)).append("\n");
    sb.append("    contactInfo: ").append(toIndentedString(contactInfo)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    review: ").append(toIndentedString(review)).append("\n");
    sb.append("    emailHeaderLogoUrl: ").append(toIndentedString(emailHeaderLogoUrl)).append("\n");
    sb.append("    logoIdentifier: ").append(toIndentedString(logoIdentifier)).append("\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("    roomStay: ").append(toIndentedString(roomStay)).append("\n");
    sb.append("    specialRequests: ").append(toIndentedString(specialRequests)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    packageOffers: ").append(toIndentedString(packageOffers)).append("\n");
    sb.append("    addOnOffers: ").append(toIndentedString(addOnOffers)).append("\n");
    sb.append("    earlyCheckInCharge: ").append(toIndentedString(earlyCheckInCharge)).append("\n");
    sb.append("    lateCheckOutCharge: ").append(toIndentedString(lateCheckOutCharge)).append("\n");
    sb.append("    earlyCheckInChargePercent: ").append(toIndentedString(earlyCheckInChargePercent)).append("\n");
    sb.append("    lateCheckOutChargePercent: ").append(toIndentedString(lateCheckOutChargePercent)).append("\n");
    sb.append("    hotelImageUrl: ").append(toIndentedString(hotelImageUrl)).append("\n");
    sb.append("    roomImageUrl: ").append(toIndentedString(roomImageUrl)).append("\n");
    sb.append("    commissionList: ").append(toIndentedString(commissionList)).append("\n");
    sb.append("    bookingContract: ").append(toIndentedString(bookingContract)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("    meetingRooms: ").append(toIndentedString(meetingRooms)).append("\n");
    sb.append("    restaurants: ").append(toIndentedString(restaurants)).append("\n");
    sb.append("    spas: ").append(toIndentedString(spas)).append("\n");
    sb.append("    activities: ").append(toIndentedString(activities)).append("\n");
    sb.append("    attractions: ").append(toIndentedString(attractions)).append("\n");
    sb.append("    places: ").append(toIndentedString(places)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    fullAddress: ").append(toIndentedString(fullAddress)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

