/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.EngineConfigurationView;
import travel.wink.sdk.affiliate.model.RemoveEntryResponse;
import travel.wink.sdk.affiliate.model.UpsertEngineConfigurationRequest;

public class CustomizationApi {
    private ApiClient apiClient;

    public CustomizationApi() {
        this(new ApiClient());
    }

    @Autowired
    public CustomizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createApplicationConfigurationRequestCreation(String companyIdentifier, UpsertEngineConfigurationRequest upsertEngineConfigurationRequest) throws WebClientResponseException {
        UpsertEngineConfigurationRequest postBody = upsertEngineConfigurationRequest;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertEngineConfigurationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertEngineConfigurationRequest' when calling createApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineConfigurationView> createApplicationConfiguration(String companyIdentifier, UpsertEngineConfigurationRequest upsertEngineConfigurationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.createApplicationConfigurationRequestCreation(companyIdentifier, upsertEngineConfigurationRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationView>> createApplicationConfigurationWithHttpInfo(String companyIdentifier, UpsertEngineConfigurationRequest upsertEngineConfigurationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.createApplicationConfigurationRequestCreation(companyIdentifier, upsertEngineConfigurationRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec removeApplicationConfigurationRequestCreation(String companyIdentifier, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (engineConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineConfigurationIdentifier' when calling removeApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineConfigurationIdentifier", engineConfigurationIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/{engineConfigurationIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeApplicationConfiguration(String companyIdentifier, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeApplicationConfigurationWithHttpInfo(String companyIdentifier, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showApplicationConfigurationRequestCreation(String companyIdentifier, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (engineConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineConfigurationIdentifier' when calling showApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineConfigurationIdentifier", engineConfigurationIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/{engineConfigurationIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineConfigurationView> showApplicationConfiguration(String companyIdentifier, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.showApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationView>> showApplicationConfigurationWithHttpInfo(String companyIdentifier, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.showApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showApplicationConfigurationsByOwnerRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showApplicationConfigurationsByOwner", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<EngineConfigurationView> showApplicationConfigurationsByOwner(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.showApplicationConfigurationsByOwnerRequestCreation(companyIdentifier, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<EngineConfigurationView>>> showApplicationConfigurationsByOwnerWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.showApplicationConfigurationsByOwnerRequestCreation(companyIdentifier, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPrimaryApplicationConfigurationRequestCreation(String companyIdentifier, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showPrimaryApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineConfigurationView> showPrimaryApplicationConfiguration(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.showPrimaryApplicationConfigurationRequestCreation(companyIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationView>> showPrimaryApplicationConfigurationWithHttpInfo(String companyIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.showPrimaryApplicationConfigurationRequestCreation(companyIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec updateApplicationConfigurationRequestCreation(String companyIdentifier, String engineConfigurationIdentifier, UpsertEngineConfigurationRequest upsertEngineConfigurationRequest) throws WebClientResponseException {
        UpsertEngineConfigurationRequest postBody = upsertEngineConfigurationRequest;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (engineConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineConfigurationIdentifier' when calling updateApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertEngineConfigurationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertEngineConfigurationRequest' when calling updateApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineConfigurationIdentifier", engineConfigurationIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/{engineConfigurationIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineConfigurationView> updateApplicationConfiguration(String companyIdentifier, String engineConfigurationIdentifier, UpsertEngineConfigurationRequest upsertEngineConfigurationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.updateApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, upsertEngineConfigurationRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationView>> updateApplicationConfigurationWithHttpInfo(String companyIdentifier, String engineConfigurationIdentifier, UpsertEngineConfigurationRequest upsertEngineConfigurationRequest) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationView> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationView>(){};
        return this.updateApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, upsertEngineConfigurationRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

