/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"name", "redirectUris"})
public class SaveEngineRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_REDIRECT_URIS = "redirectUris";
    private List<String> redirectUris = null;

    public SaveEngineRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Engine 1", required=true, value="Name of this engine application. The first engine for every integrator will have the same name as its company name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public SaveEngineRequest redirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public SaveEngineRequest addRedirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"https://my.travel.blog\"]", value="Where to redirect after web components successfully authenticate. For OAuth2 purposes.")
    @JsonProperty(value="redirectUris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    @JsonProperty(value="redirectUris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SaveEngineRequest saveEngineRequest = (SaveEngineRequest)o;
        return Objects.equals(this.name, saveEngineRequest.name) && Objects.equals(this.redirectUris, saveEngineRequest.redirectUris);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.redirectUris);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SaveEngineRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

